/*
 * Decompiled with CFR 0.152.
 */
package nl.nn.adapterframework.management.web;

import java.util.function.Function;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.ExceptionMapper;
import javax.ws.rs.ext.Provider;
import nl.nn.adapterframework.management.bus.BusException;
import nl.nn.adapterframework.management.web.ApiException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.messaging.MessageHandlingException;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.security.core.AuthenticationException;
import org.springframework.web.client.HttpClientErrorException;
import org.springframework.web.client.ResourceAccessException;

@Provider
public class SpringBusExceptionHandler
implements ExceptionMapper<MessageHandlingException> {
    private Logger log = LogManager.getLogger((Object)this);

    public Response toResponse(MessageHandlingException mhe) {
        Throwable cause = mhe.getCause();
        for (int i = 0; i < 5 && cause != null; cause = cause.getCause(), ++i) {
            ManagedException mex = ManagedException.parse(cause);
            if (mex == null) continue;
            return mex.toResponse(cause);
        }
        this.log.warn("unhandled exception while sending/receiving information from the Application Bus", (Throwable)mhe);
        return ApiException.formatExceptionResponse(mhe.getMessage(), Response.Status.INTERNAL_SERVER_ERROR);
    }

    public static enum ManagedException {
        AUTHENTICATION(AuthenticationException.class, Response.Status.UNAUTHORIZED),
        AUTHORIZATION(AccessDeniedException.class, Response.Status.FORBIDDEN),
        BUS_EXCEPTION(BusException.class, Response.Status.BAD_REQUEST),
        BACKEND_UNAVAILABLE(ResourceAccessException.class, Response.Status.SERVICE_UNAVAILABLE),
        REQUEST_EXCEPTION(HttpClientErrorException.class, ManagedException::convertHttpClientError);

        private final Class<? extends Throwable> exceptionClass;
        private final Function<Throwable, Response> messageConverter;

        private ManagedException(Class<? extends Throwable> exceptionClass, Response.Status status) {
            this(exceptionClass, (T e) -> ApiException.formatExceptionResponse(e.getMessage(), status));
        }

        private <T extends Throwable> ManagedException(Class<T> exceptionClass, Function<T, Response> messageConverter) {
            this.exceptionClass = exceptionClass;
            this.messageConverter = messageConverter;
        }

        public Response toResponse(Throwable cause) {
            return this.messageConverter.apply(cause);
        }

        public static ManagedException parse(Throwable cause) {
            for (ManagedException me : ManagedException.values()) {
                if (!me.exceptionClass.isAssignableFrom(cause.getClass())) continue;
                return me;
            }
            return null;
        }

        private static Response convertHttpClientError(HttpClientErrorException e) {
            Response.Status status = Response.Status.fromStatusCode((int)e.getRawStatusCode());
            if (Response.Status.Family.SERVER_ERROR == status.getFamily() || status == Response.Status.NOT_FOUND) {
                return ApiException.formatExceptionResponse(status.getStatusCode() + " - " + status.getReasonPhrase(), status);
            }
            return ApiException.formatExceptionResponse(e.getResponseBodyAsString(), status);
        }
    }
}

