/*
 * Decompiled with CFR 0.152.
 */
package nl.nn.adapterframework.management.web;

import java.util.Map;
import javax.annotation.security.PermitAll;
import javax.annotation.security.RolesAllowed;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import nl.nn.adapterframework.management.bus.BusAction;
import nl.nn.adapterframework.management.bus.BusTopic;
import nl.nn.adapterframework.management.web.FrankApiBase;
import nl.nn.adapterframework.management.web.Relation;
import nl.nn.adapterframework.management.web.RequestMessageBuilder;
import nl.nn.adapterframework.util.RequestUtils;
import org.apache.logging.log4j.Level;

@Path(value="/")
public class UpdateLoggingConfig
extends FrankApiBase {
    @GET
    @PermitAll
    @Path(value="/server/logging")
    @Produces(value={"application/json"})
    public Response getLogConfiguration() {
        return this.callSyncGateway(RequestMessageBuilder.create(this, BusTopic.LOG_CONFIGURATION, BusAction.GET));
    }

    @PUT
    @RolesAllowed(value={"IbisDataAdmin", "IbisAdmin", "IbisTester"})
    @Path(value="/server/logging")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response updateLogConfiguration(Map<String, Object> json) {
        Level loglevel = Level.toLevel((String)RequestUtils.getValue(json, "loglevel"), null);
        Boolean logIntermediaryResults = RequestUtils.getBooleanValue(json, "logIntermediaryResults");
        Integer maxMessageLength = RequestUtils.getIntegerValue(json, "maxMessageLength");
        Boolean enableDebugger = RequestUtils.getBooleanValue(json, "enableDebugger");
        RequestMessageBuilder builder = RequestMessageBuilder.create(this, BusTopic.LOG_CONFIGURATION, BusAction.MANAGE);
        builder.addHeader("logLevel", loglevel == null ? null : loglevel.name());
        builder.addHeader("logIntermediaryResults", logIntermediaryResults);
        builder.addHeader("maxMessageLength", maxMessageLength);
        builder.addHeader("enableDebugger", enableDebugger);
        return this.callAsyncGateway(builder);
    }

    @GET
    @RolesAllowed(value={"IbisObserver", "IbisDataAdmin", "IbisAdmin", "IbisTester"})
    @Path(value="/server/logging/settings")
    @Relation(value="logging")
    @Produces(value={"application/json"})
    public Response getLogSettings(@QueryParam(value="filter") String filter) {
        RequestMessageBuilder request = RequestMessageBuilder.create(this, BusTopic.LOG_DEFINITIONS, BusAction.GET);
        request.addHeader("filter", filter);
        return this.callSyncGateway(request);
    }

    @PUT
    @RolesAllowed(value={"IbisDataAdmin", "IbisAdmin", "IbisTester"})
    @Path(value="/server/logging/settings")
    @Consumes(value={"application/json"})
    public Response updateLogger(Map<String, Object> json) {
        RequestMessageBuilder request = RequestMessageBuilder.create(this, BusTopic.LOG_DEFINITIONS, BusAction.MANAGE);
        for (Map.Entry<String, Object> entry : json.entrySet()) {
            String key = entry.getKey();
            Object value = entry.getValue();
            if (key.equalsIgnoreCase("level")) {
                Level level = Level.toLevel((String)("" + value), null);
                if (level == null) continue;
                request.addHeader("level", level.name());
                continue;
            }
            if (key.equalsIgnoreCase("logger")) {
                String logPackage = (String)value;
                request.addHeader("logPackage", logPackage);
                continue;
            }
            if (!key.equalsIgnoreCase("reconfigure")) continue;
            boolean reconfigure = Boolean.parseBoolean("" + value);
            request.addHeader("reconfigure", reconfigure);
        }
        return this.callSyncGateway(request);
    }
}

