/*
 * Decompiled with CFR 0.152.
 */
package nl.nn.adapterframework.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.Map;
import javax.annotation.Nullable;
import nl.nn.adapterframework.management.web.ApiException;
import nl.nn.adapterframework.util.ClassUtils;
import nl.nn.adapterframework.util.StreamUtil;
import org.apache.commons.lang3.StringUtils;
import org.apache.cxf.jaxrs.ext.multipart.Attachment;
import org.apache.cxf.jaxrs.ext.multipart.MultipartBody;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class RequestUtils {
    private static Logger LOG = LogManager.getLogger(RequestUtils.class);

    public static String resolveStringFromMap(MultipartBody inputDataMap, String key) throws ApiException {
        return RequestUtils.resolveStringFromMap(inputDataMap, key, null);
    }

    public static String resolveStringFromMap(MultipartBody inputDataMap, String key, String defaultValue) throws ApiException {
        String result = RequestUtils.resolveTypeFromMap(inputDataMap, key, String.class, null);
        if (StringUtils.isEmpty((CharSequence)result)) {
            if (defaultValue != null) {
                return defaultValue;
            }
            throw new ApiException("Key [" + key + "] may not be empty");
        }
        return result;
    }

    public static String resolveStringWithEncoding(MultipartBody inputDataMap, String key, String defaultEncoding) {
        Attachment msg = inputDataMap.getAttachment(key);
        if (msg != null) {
            String charset;
            String encoding;
            String string = encoding = StringUtils.isNotEmpty((CharSequence)defaultEncoding) ? defaultEncoding : StreamUtil.DEFAULT_INPUT_STREAM_ENCODING;
            if (msg.getContentType().getParameters() != null && StringUtils.isNotEmpty((CharSequence)(charset = (String)msg.getContentType().getParameters().get("charset")))) {
                encoding = charset;
            }
            InputStream is = (InputStream)msg.getObject(InputStream.class);
            try {
                String inputMessage = StreamUtil.streamToString((InputStream)is, (String)"\n", (String)encoding, (boolean)false);
                return StringUtils.isEmpty((CharSequence)inputMessage) ? null : inputMessage;
            }
            catch (UnsupportedEncodingException e) {
                throw new ApiException("unsupported file encoding [" + encoding + "]");
            }
            catch (IOException e) {
                throw new ApiException("error parsing value of key [" + key + "]", e);
            }
        }
        return null;
    }

    public static <T> T resolveTypeFromMap(MultipartBody inputDataMap, String key, Class<T> clazz, T defaultValue) throws ApiException {
        try {
            Attachment attachment = inputDataMap.getAttachment(key);
            if (attachment != null) {
                return RequestUtils.convert(clazz, (InputStream)attachment.getObject(InputStream.class));
            }
        }
        catch (Exception e) {
            LOG.debug("Failed to parse parameter [" + key + "]", (Throwable)e);
        }
        if (defaultValue != null) {
            return defaultValue;
        }
        throw new ApiException("Key [" + key + "] not defined", 400);
    }

    protected static <T> T convert(Class<T> clazz, InputStream is) throws IOException {
        if (clazz.isAssignableFrom(InputStream.class)) {
            return (T)is;
        }
        String str = StreamUtil.streamToString((InputStream)is);
        if (str == null) {
            return null;
        }
        if (clazz.isAssignableFrom(Boolean.TYPE) || clazz.isAssignableFrom(Boolean.class)) {
            return (T)Boolean.valueOf(str);
        }
        return (T)ClassUtils.convertToType(clazz, (String)str);
    }

    @Nullable
    public static String getValue(Map<String, Object> json, String key) {
        Object val = json.get(key);
        if (val != null) {
            return val.toString();
        }
        return null;
    }

    @Nullable
    public static Integer getIntegerValue(Map<String, Object> json, String key) {
        String value = RequestUtils.getValue(json, key);
        if (value != null) {
            return Integer.parseInt(value);
        }
        return null;
    }

    @Nullable
    public static Boolean getBooleanValue(Map<String, Object> json, String key) {
        String value = RequestUtils.getValue(json, key);
        if (value != null) {
            return Boolean.parseBoolean(value);
        }
        return null;
    }
}

