/*
 * Decompiled with CFR 0.152.
 */
package nl.nn.adapterframework.util;

import java.nio.charset.StandardCharsets;
import javax.ws.rs.core.EntityTag;
import javax.ws.rs.core.Response;
import nl.nn.adapterframework.management.bus.BusMessageUtils;
import org.apache.commons.lang3.NotImplementedException;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageHeaders;
import org.springframework.util.DigestUtils;

public class ResponseUtils {
    public static Response.ResponseBuilder convertToJaxRsResponse(Message<?> response) {
        String contentDisposition;
        int status = BusMessageUtils.getIntHeader(response, (String)"status", (Integer)200);
        String mimeType = BusMessageUtils.getHeader(response, (String)"type", null);
        Response.ResponseBuilder builder = Response.status((int)status);
        if (mimeType != null) {
            builder.type(mimeType);
        }
        if (status == 200 || status > 204) {
            builder.entity(response.getPayload());
        }
        if ((contentDisposition = BusMessageUtils.getHeader(response, (String)"contentdisposition", null)) != null) {
            builder.header("Content-Disposition", (Object)contentDisposition);
        }
        return builder;
    }

    public static EntityTag generateETagHeaderValue(Message<?> response) {
        MessageHeaders headers = response.getHeaders();
        String mime = (String)headers.get((Object)"type", String.class);
        if ("application/json".equals(mime)) {
            return ResponseUtils.generateETagHeaderValue(response.getPayload(), true);
        }
        return null;
    }

    private static EntityTag generateETagHeaderValue(Object payload, boolean isWeak) {
        byte[] bytes;
        if (payload instanceof String) {
            bytes = ((String)payload).getBytes(StandardCharsets.UTF_8);
        } else if (payload instanceof byte[]) {
            bytes = (byte[])payload;
        } else {
            throw new NotImplementedException("return type [" + payload.getClass() + "] not implemented");
        }
        return new EntityTag(DigestUtils.md5DigestAsHex((byte[])bytes), isWeak);
    }
}

