/*
 * Decompiled with CFR 0.152.
 */
package nl.nn.adapterframework.web.filters;

import java.io.IOException;
import java.util.List;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import nl.nn.adapterframework.util.StringUtil;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.util.Supplier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.cors.CorsConfiguration;
import org.springframework.web.cors.CorsUtils;

public class CorsFilter
implements Filter {
    private final Logger secLog = LogManager.getLogger((String)"SEC");
    private final Logger log = LogManager.getLogger((Object)this);
    @Value(value="${iaf-api.cors.allowOrigin:*}")
    private String allowedCorsOrigins;
    @Value(value="${iaf-api.cors.exposeHeaders:Allow, ETag, Content-Disposition}")
    private String exposedCorsHeaders;
    @Value(value="${iaf-api.cors.allowMethods:GET, POST, PUT, DELETE, OPTIONS, HEAD}")
    private String allowedCorsMethods;
    @Value(value="${iaf-api.cors.enforced:false}")
    private boolean enforceCORS;
    private CorsConfiguration config = new CorsConfiguration();

    public void init(FilterConfig filterConfig) throws ServletException {
        List allowedOrigins = StringUtil.split((String)this.allowedCorsOrigins);
        for (String domain : allowedOrigins) {
            if ("*".equals(domain) || !domain.contains("*")) {
                this.config.addAllowedOrigin(domain);
                continue;
            }
            this.config.addAllowedOriginPattern(domain);
        }
        Supplier[] supplierArray = new Supplier[2];
        supplierArray[0] = () -> ((CorsConfiguration)this.config).getAllowedOrigins();
        supplierArray[1] = () -> ((CorsConfiguration)this.config).getAllowedOriginPatterns();
        this.log.debug("whitelisted CORS origins: {} and patterns: {}", supplierArray);
    }

    public void doFilter(ServletRequest req, ServletResponse resp, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest request = (HttpServletRequest)req;
        HttpServletResponse response = (HttpServletResponse)resp;
        if (this.enforceCORS && CorsUtils.isCorsRequest((HttpServletRequest)request)) {
            String originHeader = request.getHeader("Origin");
            String origin = this.config.checkOrigin(originHeader);
            if (origin != null) {
                response.setHeader("Access-Control-Allow-Origin", origin);
                String requestHeaders = request.getHeader("Access-Control-Request-Headers");
                if (requestHeaders != null) {
                    response.setHeader("Access-Control-Allow-Headers", requestHeaders);
                }
                response.setHeader("Access-Control-Expose-Headers", this.exposedCorsHeaders);
                response.setHeader("Access-Control-Allow-Methods", this.allowedCorsMethods);
                response.setHeader("Access-Control-Max-Age", "3600");
            } else {
                this.secLog.info("host[" + request.getRemoteHost() + "] tried to access uri[" + request.getPathInfo() + "] with origin[" + originHeader + "] but was blocked due to CORS restrictions");
                this.log.warn("blocked request with origin [{}]", (Object)originHeader);
                response.setStatus(400);
                return;
            }
        }
        if (CorsUtils.isPreFlightRequest((HttpServletRequest)request)) {
            response.setHeader("Allow", this.allowedCorsMethods);
            response.setStatus(200);
        } else {
            chain.doFilter((ServletRequest)request, (ServletResponse)response);
        }
    }

    public void destroy() {
    }
}

