/*
 * Decompiled with CFR 0.152.
 */
package nl.nn.adapterframework.web.filters;

import java.util.EnumSet;
import javax.servlet.DispatcherType;
import javax.servlet.Filter;
import javax.servlet.FilterRegistration;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import javax.servlet.annotation.WebListener;
import nl.nn.adapterframework.util.SpringUtils;
import nl.nn.adapterframework.web.filters.CorsFilter;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.util.Supplier;
import org.springframework.context.ApplicationContext;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;

@WebListener
public class CorsFilterConfigurer
implements ServletContextListener {
    private Logger log = LogManager.getLogger((Object)this);

    public void contextInitialized(ServletContextEvent sce) {
        ServletContext context = sce.getServletContext();
        try {
            FilterRegistration.Dynamic filter = this.createFilter(context);
            String[] urlMapping = new String[]{"/iaf/api/*"};
            filter.addMappingForUrlPatterns(EnumSet.of(DispatcherType.REQUEST), true, urlMapping);
        }
        catch (Exception e) {
            this.log.fatal("unable to create CORS filter", (Throwable)e);
            context.log("unable to create CORS filter", (Throwable)e);
        }
    }

    public void contextDestroyed(ServletContextEvent sce) {
    }

    private FilterRegistration.Dynamic createFilter(ServletContext context) {
        WebApplicationContext wac = WebApplicationContextUtils.getWebApplicationContext((ServletContext)context);
        if (wac != null) {
            Supplier[] supplierArray = new Supplier[1];
            supplierArray[0] = () -> ((WebApplicationContext)wac).getDisplayName();
            this.log.info("creating CorsFilter through Application Context [{}]", supplierArray);
            CorsFilter filterInstance = (CorsFilter)SpringUtils.createBean((ApplicationContext)wac, CorsFilter.class);
            return context.addFilter("CorsFilter", (Filter)filterInstance);
        }
        this.log.info("creating CorsFilter without Application Context");
        return context.addFilter("CorsFilter", CorsFilter.class);
    }
}

