/*
 * Decompiled with CFR 0.152.
 */
package nl.nn.adapterframework.web.filters;

import java.util.EnumSet;
import javax.servlet.DispatcherType;
import javax.servlet.Filter;
import javax.servlet.FilterRegistration;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import javax.servlet.annotation.WebListener;
import nl.nn.adapterframework.util.SpringUtils;
import nl.nn.adapterframework.web.filters.CspFilter;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.util.Supplier;
import org.springframework.context.ApplicationContext;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;

@WebListener
public class CspFilterConfigurer
implements ServletContextListener {
    private Logger log = LogManager.getLogger((Object)this);

    public void contextInitialized(ServletContextEvent sce) {
        ServletContext context = sce.getServletContext();
        try {
            FilterRegistration.Dynamic filter = this.createFilter(context);
            String[] urlMapping = new String[]{"/iaf/gui/*"};
            filter.addMappingForUrlPatterns(EnumSet.of(DispatcherType.REQUEST), true, urlMapping);
        }
        catch (Exception e) {
            this.log.fatal("unable to create CSP filter", (Throwable)e);
            context.log("unable to create CSP filter", (Throwable)e);
        }
    }

    public void contextDestroyed(ServletContextEvent sce) {
    }

    private FilterRegistration.Dynamic createFilter(ServletContext context) {
        WebApplicationContext wac = WebApplicationContextUtils.getWebApplicationContext((ServletContext)context);
        if (wac != null) {
            Supplier[] supplierArray = new Supplier[1];
            supplierArray[0] = () -> ((WebApplicationContext)wac).getDisplayName();
            this.log.info("creating CspFilter through Application Context [{}]", supplierArray);
            CspFilter filterInstance = (CspFilter)SpringUtils.createBean((ApplicationContext)wac, CspFilter.class);
            return context.addFilter("CspFilter", (Filter)filterInstance);
        }
        this.log.info("creating CspFilter without Application Context");
        return context.addFilter("CspFilter", CspFilter.class);
    }
}

