/*
 * Decompiled with CFR 0.152.
 */
package nl.nn.adapterframework.lifecycle.servlets;

import java.io.FileNotFoundException;
import java.net.URL;
import java.util.HashMap;
import nl.nn.adapterframework.lifecycle.servlets.AuthorityMapper;
import nl.nn.adapterframework.lifecycle.servlets.ServletAuthenticatorBase;
import nl.nn.adapterframework.util.ClassUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.core.env.Environment;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.core.authority.mapping.GrantedAuthoritiesMapper;
import org.springframework.security.ldap.authentication.ad.ActiveDirectoryLdapAuthenticationProvider;
import org.springframework.security.ldap.userdetails.LdapUserDetailsMapper;
import org.springframework.security.ldap.userdetails.UserDetailsContextMapper;
import org.springframework.security.web.SecurityFilterChain;

public class ActiveDirectoryAuthenticator
extends ServletAuthenticatorBase {
    private String domainName = null;
    private String url;
    private String baseDn;
    private boolean followReferrals = true;
    private String searchFilter = null;
    private String roleMappingFile = "ldap-role-mapping.properties";
    private URL roleMappingURL = null;

    private void configure() throws FileNotFoundException {
        this.setDefaultValues();
        if (StringUtils.isEmpty((CharSequence)this.url)) {
            throw new IllegalArgumentException("url may not be empty");
        }
        this.roleMappingURL = ClassUtils.getResourceURL((String)this.roleMappingFile);
        if (this.roleMappingURL == null) {
            throw new FileNotFoundException("unable to find LDAP role-mapping file [" + this.roleMappingFile + "]");
        }
        this.log.info("found rolemapping file [{}]", (Object)this.roleMappingURL);
    }

    private void setDefaultValues() {
        Environment env = this.getApplicationContext().getEnvironment();
        String legacyURL = env.getProperty("ldap.auth.url");
        if (StringUtils.isEmpty((CharSequence)this.url) && StringUtils.isNotBlank((CharSequence)legacyURL)) {
            this.url = legacyURL;
        }
        String legacyBaseDn = env.getProperty("ldap.auth.user.base");
        if (StringUtils.isEmpty((CharSequence)this.baseDn) && StringUtils.isNotBlank((CharSequence)legacyBaseDn)) {
            this.baseDn = legacyBaseDn;
        }
    }

    @Override
    public SecurityFilterChain configure(HttpSecurity http) throws Exception {
        this.configure();
        ActiveDirectoryLdapAuthenticationProvider provider = new ActiveDirectoryLdapAuthenticationProvider(this.domainName, this.url, this.baseDn);
        provider.setConvertSubErrorCodesToExceptions(this.log.isDebugEnabled());
        if (StringUtils.isNotEmpty((CharSequence)this.searchFilter)) {
            provider.setSearchFilter(this.searchFilter);
        }
        HashMap<String, String> environment = new HashMap<String, String>();
        if (this.followReferrals) {
            environment.put("java.naming.referral", "follow");
        }
        provider.setContextEnvironmentProperties(environment);
        LdapUserDetailsMapper roleMapper = new LdapUserDetailsMapper();
        roleMapper.setRoleAttributes("memberOf".split(" "));
        roleMapper.setConvertToUpperCase(false);
        roleMapper.setRolePrefix("");
        provider.setUserDetailsContextMapper((UserDetailsContextMapper)roleMapper);
        provider.setAuthoritiesMapper((GrantedAuthoritiesMapper)new AuthorityMapper(this.roleMappingURL, this.getSecurityRoles(), this.getEnvironmentProperties()));
        http.authenticationProvider((AuthenticationProvider)provider);
        String realmName = StringUtils.isNotEmpty((CharSequence)this.domainName) ? this.domainName : this.url;
        http.httpBasic().realmName(realmName);
        return (SecurityFilterChain)http.build();
    }

    public void setDomainName(String domainName) {
        this.domainName = domainName;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public void setBaseDn(String baseDn) {
        this.baseDn = baseDn;
    }

    public void setFollowReferrals(boolean followReferrals) {
        this.followReferrals = followReferrals;
    }

    public void setSearchFilter(String searchFilter) {
        this.searchFilter = searchFilter;
    }

    public void setRoleMappingFile(String roleMappingFile) {
        this.roleMappingFile = roleMappingFile;
    }
}

