/*
 * Decompiled with CFR 0.152.
 */
package nl.nn.adapterframework.lifecycle.servlets;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.stream.Collectors;
import nl.nn.adapterframework.util.StringResolver;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.core.authority.mapping.GrantedAuthoritiesMapper;

public class AuthorityMapper
implements GrantedAuthoritiesMapper {
    private static final Logger log = LogManager.getLogger(AuthorityMapper.class);
    private Map<GrantedAuthority, String> roleToAuthorityMapping = new HashMap<GrantedAuthority, String>();

    public AuthorityMapper(URL roleMappingURL, Set<String> roles, Properties properties) throws IOException {
        Properties roleMappingProperties = new Properties();
        try (InputStream stream = roleMappingURL.openStream();){
            roleMappingProperties.load(stream);
        }
        catch (IOException e) {
            throw new IOException("unable to open role-mapping file [" + roleMappingURL + "]", e);
        }
        for (String role : roles) {
            String value = roleMappingProperties.getProperty(role);
            if (StringUtils.isEmpty((CharSequence)value)) {
                log.warn("role [{}] has not been mapped to anything, ignoring this role", (Object)role);
                continue;
            }
            String resolvedValue = StringResolver.substVars((String)value, (Map)properties);
            if (!StringUtils.isNotEmpty((CharSequence)resolvedValue)) continue;
            SimpleGrantedAuthority grantedAuthority = new SimpleGrantedAuthority("ROLE_" + role);
            this.roleToAuthorityMapping.put((GrantedAuthority)grantedAuthority, resolvedValue);
            log.info("mapped role [{}] to [{}]", (Object)resolvedValue, (Object)grantedAuthority);
        }
    }

    public Collection<? extends GrantedAuthority> mapAuthorities(Collection<? extends GrantedAuthority> authorities) {
        ArrayList mappedAuthorities = new ArrayList();
        List canonicalRoleNames = authorities.stream().map(GrantedAuthority::getAuthority).collect(Collectors.toList());
        this.roleToAuthorityMapping.forEach((authority, key) -> {
            if (canonicalRoleNames.contains(key)) {
                mappedAuthorities.add(authority);
            }
        });
        return mappedAuthorities;
    }
}

