/*
 * Decompiled with CFR 0.152.
 */
package nl.nn.adapterframework.lifecycle.servlets;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import javax.servlet.Filter;
import nl.nn.adapterframework.lifecycle.servlets.ServletAuthenticatorBase;
import nl.nn.adapterframework.util.SpringUtils;
import org.springframework.context.ApplicationContext;
import org.springframework.security.authentication.AuthenticationDetailsSource;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.authentication.ProviderManager;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.core.authority.mapping.MappableAttributesRetriever;
import org.springframework.security.core.userdetails.AuthenticationUserDetailsService;
import org.springframework.security.web.AuthenticationEntryPoint;
import org.springframework.security.web.SecurityFilterChain;
import org.springframework.security.web.authentication.Http403ForbiddenEntryPoint;
import org.springframework.security.web.authentication.preauth.PreAuthenticatedAuthenticationProvider;
import org.springframework.security.web.authentication.preauth.PreAuthenticatedGrantedAuthoritiesUserDetailsService;
import org.springframework.security.web.authentication.preauth.j2ee.J2eeBasedPreAuthenticatedWebAuthenticationDetailsSource;
import org.springframework.security.web.authentication.preauth.j2ee.J2eePreAuthenticatedProcessingFilter;
import org.springframework.security.web.authentication.preauth.j2ee.WebXmlMappableAttributesRetriever;

public class JeeAuthenticator
extends ServletAuthenticatorBase {
    @Override
    public SecurityFilterChain configure(HttpSecurity http) throws Exception {
        AuthenticationManager authManager = this.getAuthenticationManager(http);
        http.addFilter((Filter)this.getProcessingFilter(authManager));
        http.authenticationManager(authManager);
        return (SecurityFilterChain)http.build();
    }

    private AuthenticationManager getAuthenticationManager(HttpSecurity http) {
        PreAuthenticatedAuthenticationProvider provider = this.getAuthenticationProvider(http);
        return new ProviderManager(Arrays.asList(provider));
    }

    private PreAuthenticatedAuthenticationProvider getAuthenticationProvider(HttpSecurity http) {
        PreAuthenticatedAuthenticationProvider authenticationProvider = new PreAuthenticatedAuthenticationProvider();
        authenticationProvider.setPreAuthenticatedUserDetailsService((AuthenticationUserDetailsService)new PreAuthenticatedGrantedAuthoritiesUserDetailsService());
        http.authenticationProvider((AuthenticationProvider)authenticationProvider).setSharedObject(AuthenticationEntryPoint.class, (Object)this.getEntryPoint());
        return authenticationProvider;
    }

    private AuthenticationEntryPoint getEntryPoint() {
        return new Http403ForbiddenEntryPoint();
    }

    private J2eePreAuthenticatedProcessingFilter getProcessingFilter(AuthenticationManager authManager) {
        J2eePreAuthenticatedProcessingFilter filter = new J2eePreAuthenticatedProcessingFilter();
        filter.setAuthenticationDetailsSource((AuthenticationDetailsSource)this.getAuthenticationDetailsSource());
        filter.setAuthenticationManager(authManager);
        return filter;
    }

    private J2eeBasedPreAuthenticatedWebAuthenticationDetailsSource getAuthenticationDetailsSource() {
        J2eeBasedPreAuthenticatedWebAuthenticationDetailsSource authenticationDetailSource = new J2eeBasedPreAuthenticatedWebAuthenticationDetailsSource();
        authenticationDetailSource.setMappableRolesRetriever(this.getWebXmlSecurityRoles());
        return authenticationDetailSource;
    }

    private MappableAttributesRetriever getWebXmlSecurityRoles() {
        DelegatedMappableAttributesRetriever attributeRetriever = new DelegatedMappableAttributesRetriever();
        MappableAttributesRetriever webXml = (MappableAttributesRetriever)SpringUtils.createBean((ApplicationContext)this.getApplicationContext(), WebXmlMappableAttributesRetriever.class);
        attributeRetriever.addMappableAttributes(webXml.getMappableAttributes());
        attributeRetriever.addMappableAttributes(new HashSet<String>(this.getSecurityRoles()));
        return attributeRetriever;
    }

    public static class DelegatedMappableAttributesRetriever
    implements MappableAttributesRetriever {
        private Set<String> mappableAttributes = new HashSet<String>();

        public Set<String> getMappableAttributes() {
            return this.mappableAttributes;
        }

        public void addMappableAttributes(Set<String> mappableAttributes) {
            this.mappableAttributes.addAll(mappableAttributes);
        }
    }
}

