/*
 * Decompiled with CFR 0.152.
 */
package nl.nn.adapterframework.lifecycle.servlets;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import nl.nn.adapterframework.lifecycle.servlets.ServletAuthenticatorBase;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.web.SecurityFilterChain;

public class NoOpAuthenticator
extends ServletAuthenticatorBase {
    private static final String ROLE_PREFIX = "ROLE_";

    @Override
    public SecurityFilterChain configure(HttpSecurity http) throws Exception {
        http.anonymous().authorities(this.getAuthorities());
        return (SecurityFilterChain)http.build();
    }

    @Override
    protected boolean authorizationRequestMatcher(HttpServletRequest request) {
        return false;
    }

    private List<GrantedAuthority> getAuthorities() {
        Set<String> securityRoles = this.getSecurityRoles();
        ArrayList<GrantedAuthority> grantedAuthorities = new ArrayList<GrantedAuthority>(securityRoles.size());
        for (String role : securityRoles) {
            grantedAuthorities.add((GrantedAuthority)new SimpleGrantedAuthority(ROLE_PREFIX + role));
        }
        return grantedAuthorities;
    }
}

