/*
 * Decompiled with CFR 0.152.
 */
package nl.nn.adapterframework.lifecycle.servlets;

import java.io.FileNotFoundException;
import java.net.URL;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import nl.nn.adapterframework.lifecycle.servlets.AuthorityMapper;
import nl.nn.adapterframework.lifecycle.servlets.ServletAuthenticatorBase;
import nl.nn.adapterframework.util.ClassUtils;
import nl.nn.adapterframework.util.EnumUtils;
import nl.nn.adapterframework.util.SpringUtils;
import nl.nn.adapterframework.util.StringUtil;
import org.apache.commons.lang3.StringUtils;
import org.springframework.context.ApplicationContext;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.oauth2.client.CommonOAuth2Provider;
import org.springframework.security.core.authority.mapping.GrantedAuthoritiesMapper;
import org.springframework.security.oauth2.client.InMemoryOAuth2AuthorizedClientService;
import org.springframework.security.oauth2.client.OAuth2AuthorizedClientService;
import org.springframework.security.oauth2.client.registration.ClientRegistration;
import org.springframework.security.oauth2.client.registration.ClientRegistrationRepository;
import org.springframework.security.oauth2.client.registration.InMemoryClientRegistrationRepository;
import org.springframework.security.oauth2.core.AuthorizationGrantType;
import org.springframework.security.oauth2.core.ClientAuthenticationMethod;
import org.springframework.security.web.SecurityFilterChain;

public class OAuth2Authenticator
extends ServletAuthenticatorBase {
    private String scopes;
    private String authorizationUri;
    private String tokenUri;
    private String jwkSetUri;
    private String issuerUri;
    private String userInfoUri;
    private String userNameAttributeName;
    private String clientId = null;
    private String clientSecret = null;
    private String provider;
    private ClientRegistrationRepository clientRepository;
    private String oauthBaseUrl;
    private String roleMappingFile = "oauth-role-mapping.properties";
    private URL roleMappingURL = null;

    @Override
    public SecurityFilterChain configure(HttpSecurity http) throws Exception {
        this.configure();
        http.oauth2Login().clientRegistrationRepository(this.clientRepository).authorizedClientService((OAuth2AuthorizedClientService)new InMemoryOAuth2AuthorizedClientService(this.clientRepository)).authorizationEndpoint().baseUri(this.oauthBaseUrl + "/oauth2/authorization").and().userInfoEndpoint().userAuthoritiesMapper((GrantedAuthoritiesMapper)new AuthorityMapper(this.roleMappingURL, this.getSecurityRoles(), this.getEnvironmentProperties())).and().loginProcessingUrl(this.oauthBaseUrl + "/oauth2/code/*");
        return (SecurityFilterChain)http.build();
    }

    private void configure() throws FileNotFoundException {
        if (StringUtils.isEmpty((CharSequence)this.clientId) || StringUtils.isEmpty((CharSequence)this.clientSecret)) {
            throw new IllegalStateException("clientId and clientSecret must be set");
        }
        this.roleMappingURL = ClassUtils.getResourceURL((String)this.roleMappingFile);
        if (this.roleMappingURL == null) {
            throw new FileNotFoundException("unable to find OAUTH role-mapping file [" + this.roleMappingFile + "]");
        }
        this.log.info("found rolemapping file [{}]", (Object)this.roleMappingURL);
        this.oauthBaseUrl = this.computeBaseUrl();
        this.clientRepository = this.createClientRegistrationRepository();
        SpringUtils.registerSingleton((ApplicationContext)this.getApplicationContext(), (String)"clientRegistrationRepository", (Object)this.clientRepository);
    }

    public ClientRegistrationRepository createClientRegistrationRepository() {
        Stream providers = StringUtil.splitToStream((String)this.provider);
        List registrations = providers.map(this::getRegistration).collect(Collectors.toList());
        return new InMemoryClientRegistrationRepository(registrations);
    }

    private ClientRegistration getRegistration(String provider) {
        ClientRegistration.Builder builder;
        switch (provider.toLowerCase()) {
            case "google": 
            case "github": 
            case "facebook": 
            case "okta": {
                CommonOAuth2Provider commonProvider = (CommonOAuth2Provider)EnumUtils.parse(CommonOAuth2Provider.class, (String)provider);
                builder = commonProvider.getBuilder(provider);
                break;
            }
            case "custom": {
                builder = this.createCustomBuilder(provider, provider.toLowerCase());
                break;
            }
            default: {
                throw new IllegalStateException("unknown OAuth provider");
            }
        }
        builder.clientId(this.clientId).clientSecret(this.clientSecret);
        builder.redirectUri(String.format("{baseUrl}/%s/oauth2/code/{registrationId}", this.oauthBaseUrl));
        return builder.build();
    }

    public ClientRegistration.Builder createCustomBuilder(String name, String registrationId) {
        ClientRegistration.Builder builder = ClientRegistration.withRegistrationId((String)registrationId);
        builder.clientAuthenticationMethod(ClientAuthenticationMethod.CLIENT_SECRET_BASIC);
        builder.authorizationGrantType(AuthorizationGrantType.AUTHORIZATION_CODE);
        builder.scope((Collection)StringUtil.split((String)this.scopes));
        builder.authorizationUri(this.authorizationUri);
        builder.tokenUri(this.tokenUri);
        builder.jwkSetUri(this.jwkSetUri);
        builder.issuerUri(this.issuerUri);
        builder.userInfoUri(this.userInfoUri);
        builder.userNameAttributeName(this.userNameAttributeName);
        builder.clientName(name);
        return builder;
    }

    private String computeBaseUrl() {
        String baseUrl = this.getPrivateEndpoints().stream().findFirst().orElse("");
        if (baseUrl.endsWith("*")) {
            baseUrl = baseUrl.substring(0, baseUrl.length() - 1);
        }
        if (baseUrl.endsWith("/")) {
            baseUrl = baseUrl.substring(0, baseUrl.length() - 1);
        }
        return baseUrl;
    }

    public void setScopes(String scopes) {
        this.scopes = scopes;
    }

    public void setAuthorizationUri(String authorizationUri) {
        this.authorizationUri = authorizationUri;
    }

    public void setTokenUri(String tokenUri) {
        this.tokenUri = tokenUri;
    }

    public void setJwkSetUri(String jwkSetUri) {
        this.jwkSetUri = jwkSetUri;
    }

    public void setIssuerUri(String issuerUri) {
        this.issuerUri = issuerUri;
    }

    public void setUserInfoUri(String userInfoUri) {
        this.userInfoUri = userInfoUri;
    }

    public void setUserNameAttributeName(String userNameAttributeName) {
        this.userNameAttributeName = userNameAttributeName;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public void setClientSecret(String clientSecret) {
        this.clientSecret = clientSecret;
    }

    public void setProvider(String provider) {
        this.provider = provider;
    }

    public void setRoleMappingFile(String roleMappingFile) {
        this.roleMappingFile = roleMappingFile;
    }
}

