/*
 * Decompiled with CFR 0.152.
 */
package nl.nn.adapterframework.lifecycle.servlets;

import javax.servlet.annotation.ServletSecurity;
import nl.nn.adapterframework.util.EnumUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.core.env.PropertyResolver;

public class SecuritySettings {
    private static final Logger log = LogManager.getLogger(SecuritySettings.class);
    public static final String AUTH_ENABLED_KEY = "application.security.http.authentication";
    public static final String HTTPS_ENABLED_KEY = "application.security.http.transportGuarantee";
    private static boolean webSecurityEnabled = true;
    private static ServletSecurity.TransportGuarantee defaultTransportGuarantee = ServletSecurity.TransportGuarantee.CONFIDENTIAL;

    public static void setupDefaultSecuritySettings(PropertyResolver properties) {
        boolean isDtapStageLoc = "LOC".equalsIgnoreCase(properties.getProperty("dtap.stage"));
        String isAuthEnabled = properties.getProperty(AUTH_ENABLED_KEY);
        webSecurityEnabled = StringUtils.isNotEmpty((CharSequence)isAuthEnabled) ? Boolean.parseBoolean(isAuthEnabled) : !isDtapStageLoc;
        String constraintType = properties.getProperty(HTTPS_ENABLED_KEY);
        if (StringUtils.isNotEmpty((CharSequence)constraintType)) {
            try {
                defaultTransportGuarantee = (ServletSecurity.TransportGuarantee)EnumUtils.parse(ServletSecurity.TransportGuarantee.class, (String)constraintType);
            }
            catch (IllegalArgumentException e) {
                log.error("unable to set TransportGuarantee", (Throwable)e);
            }
        } else if (isDtapStageLoc) {
            defaultTransportGuarantee = ServletSecurity.TransportGuarantee.NONE;
        }
    }

    public static boolean isWebSecurityEnabled() {
        return webSecurityEnabled;
    }

    public static ServletSecurity.TransportGuarantee getDefaultTransportGuarantee() {
        return defaultTransportGuarantee;
    }
}

