/*
 * Decompiled with CFR 0.152.
 */
package nl.nn.adapterframework.lifecycle.servlets;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import nl.nn.adapterframework.lifecycle.servlets.IAuthenticator;
import nl.nn.adapterframework.lifecycle.servlets.ServletConfiguration;
import nl.nn.adapterframework.lifecycle.servlets.URLRequestMatcher;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.util.Supplier;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.Environment;
import org.springframework.core.env.MapPropertySource;
import org.springframework.core.env.MutablePropertySources;
import org.springframework.core.env.PropertySource;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.configurers.AuthorizeHttpRequestsConfigurer;
import org.springframework.security.web.SecurityFilterChain;
import org.springframework.security.web.util.matcher.AndRequestMatcher;
import org.springframework.security.web.util.matcher.RequestMatcher;

public abstract class ServletAuthenticatorBase
implements IAuthenticator,
ApplicationContextAware {
    private static final String HTTP_SECURITY_BEAN_NAME = "org.springframework.security.config.annotation.web.configuration.HttpSecurityConfiguration.httpSecurity";
    public static final List<String> DEFAULT_IBIS_ROLES = Collections.unmodifiableList(Arrays.asList("IbisObserver", "IbisAdmin", "IbisDataAdmin", "IbisTester", "IbisWebService"));
    public static final String ALLOW_OPTIONS_REQUESTS_KEY = "application.security.http.allowUnsecureOptionsRequests";
    protected final Logger log = LogManager.getLogger((Object)this);
    private Set<String> publicEndpoints = new HashSet<String>();
    private Set<String> privateEndpoints = new HashSet<String>();
    private ApplicationContext applicationContext;
    private Set<String> securityRoles = new HashSet<String>();
    private Properties applicationConstants = null;
    private boolean allowUnsecureOptionsRequest = false;

    public final void setApplicationContext(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
        Environment env = applicationContext.getEnvironment();
        this.allowUnsecureOptionsRequest = (Boolean)env.getProperty(ALLOW_OPTIONS_REQUESTS_KEY, Boolean.TYPE, (Object)false);
    }

    protected final synchronized Properties getEnvironmentProperties() {
        if (this.applicationConstants == null) {
            this.applicationConstants = new Properties();
            MutablePropertySources pss = ((ConfigurableEnvironment)this.applicationContext.getEnvironment()).getPropertySources();
            for (PropertySource propertySource : pss) {
                if (!(propertySource instanceof MapPropertySource)) continue;
                this.applicationConstants.putAll((Map<?, ?>)((Map)((MapPropertySource)propertySource).getSource()));
            }
        }
        return this.applicationConstants;
    }

    @Override
    public final void registerServlet(ServletConfiguration config) {
        this.addEndpoints(config);
        this.addSecurityRoles(config.getSecurityRoles());
    }

    private void addSecurityRoles(List<String> securityRoles) {
        if (securityRoles.isEmpty()) {
            this.securityRoles.addAll(DEFAULT_IBIS_ROLES);
        } else {
            this.securityRoles.addAll(securityRoles);
        }
    }

    private void addEndpoints(ServletConfiguration config) {
        for (String url : config.getUrlMapping()) {
            if (this.publicEndpoints.contains(url) || this.privateEndpoints.contains(url)) {
                throw new IllegalStateException("endpoint already configured");
            }
            if (url.charAt(0) == '!') {
                String publicUrl = url.substring(1);
                this.log.info("registering public endpoint with url [{}]", (Object)publicUrl);
                this.publicEndpoints.add(publicUrl);
                continue;
            }
            if (config.getSecurityRoles().isEmpty()) {
                this.log.info("registering public endpoint with url pattern [{}]", (Object)url);
                this.publicEndpoints.add(url);
                continue;
            }
            this.log.info("registering private endpoint with url pattern [{}]", (Object)url);
            this.privateEndpoints.add(url);
        }
    }

    protected Set<String> getPrivateEndpoints() {
        return Collections.unmodifiableSet(this.privateEndpoints);
    }

    @Override
    public void build() {
        if (this.applicationContext == null) {
            throw new IllegalStateException("Authenticator is not wired through local BeanFactory");
        }
        if (this.privateEndpoints.isEmpty()) {
            this.log.info("no url matchers found, ignoring Authenticator [{}]", new Supplier[]{this::getClass});
            return;
        }
        ConfigurableListableBeanFactory beanFactory = ((ConfigurableApplicationContext)this.applicationContext).getBeanFactory();
        String name = "HttpSecurityChain-" + this.getClass().getSimpleName() + "-" + this.hashCode();
        beanFactory.registerSingleton(name, (Object)this.createSecurityFilterChain());
    }

    private SecurityFilterChain createSecurityFilterChain() {
        HttpSecurity httpSecurityConfigurer = (HttpSecurity)this.applicationContext.getBean(HTTP_SECURITY_BEAN_NAME, HttpSecurity.class);
        return this.configureHttpSecurity(httpSecurityConfigurer);
    }

    @Override
    public SecurityFilterChain configureHttpSecurity(HttpSecurity http) {
        try {
            http.headers().frameOptions().sameOrigin();
            http.csrf().disable();
            URLRequestMatcher securityRequestMatcher = new URLRequestMatcher(this.privateEndpoints);
            http.securityMatcher((RequestMatcher)securityRequestMatcher);
            http.formLogin().disable();
            http.logout().disable();
            if (!this.publicEndpoints.isEmpty()) {
                ((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)http.authorizeHttpRequests().requestMatchers(new RequestMatcher[]{new URLRequestMatcher(this.publicEndpoints)})).permitAll();
                http.anonymous();
            } else {
                http.anonymous().disable();
            }
            AndRequestMatcher authorizationRequestMatcher = new AndRequestMatcher(new RequestMatcher[]{securityRequestMatcher, this::authorizationRequestMatcher});
            ((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)http.authorizeHttpRequests().requestMatchers(new RequestMatcher[]{authorizationRequestMatcher})).authenticated();
            return this.configure(http);
        }
        catch (Exception e) {
            throw new IllegalStateException("unable to configure Spring Security", e);
        }
    }

    protected boolean authorizationRequestMatcher(HttpServletRequest request) {
        return !this.allowUnsecureOptionsRequest || !"OPTIONS".equals(request.getMethod());
    }

    protected abstract SecurityFilterChain configure(HttpSecurity var1) throws Exception;

    public ApplicationContext getApplicationContext() {
        return this.applicationContext;
    }

    public Set<String> getSecurityRoles() {
        return this.securityRoles;
    }
}

