/*
 * Decompiled with CFR 0.152.
 */
package nl.nn.adapterframework.lifecycle.servlets;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.servlet.Servlet;
import javax.servlet.annotation.ServletSecurity;
import nl.nn.adapterframework.lifecycle.DynamicRegistration;
import nl.nn.adapterframework.lifecycle.servlets.AuthenticationType;
import nl.nn.adapterframework.lifecycle.servlets.SecuritySettings;
import nl.nn.adapterframework.util.EnumUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.EnvironmentAware;
import org.springframework.core.env.Environment;

public class ServletConfiguration
implements InitializingBean,
EnvironmentAware {
    private static final Logger log = LogManager.getLogger(ServletConfiguration.class);
    private static final char SLASH = '/';
    private String name;
    private List<String> securityRoles = Collections.emptyList();
    private List<String> urlMapping;
    private int loadOnStartup = -1;
    private boolean enabled = true;
    private ServletSecurity.TransportGuarantee transportGuarantee;
    private String authenticatorName = null;
    private Servlet servlet;
    private Environment environment;
    private Map<String, String> initParameters = new LinkedHashMap<String, String>();

    public void afterPropertiesSet() {
        this.defaultSecuritySettings();
    }

    public void setSecurityRoles(String[] accessGrantingRoles) {
        if (accessGrantingRoles != null) {
            this.securityRoles = Arrays.asList(accessGrantingRoles);
        }
    }

    @Nonnull
    public List<String> getSecurityRoles() {
        return this.securityRoles;
    }

    public void setName(String servletName) {
        this.name = servletName;
        if (this.name.contains(" ")) {
            throw new IllegalArgumentException("unable to instantiate servlet, servlet name may not contain spaces");
        }
    }

    public void fromServlet(DynamicRegistration.Servlet servlet) {
        this.setName(servlet.getName());
        this.setUrlMapping(servlet.getUrlMapping());
        this.setSecurityRoles(servlet.getAccessGrantingRoles());
        this.setLoadOnStartup(servlet.loadOnStartUp());
        this.setEnabled(servlet.isEnabled());
        this.setServlet((Servlet)servlet);
        if (servlet instanceof DynamicRegistration.ServletWithParameters) {
            Map initParams = ((DynamicRegistration.ServletWithParameters)servlet).getParameters();
            initParams.entrySet().stream().forEach(e -> this.addInitParameter((String)e.getKey(), (String)e.getValue()));
        }
        this.loadProperties();
    }

    public void setServlet(Servlet servlet) {
        this.servlet = servlet;
    }

    public void addInitParameter(String name, String value) {
        this.initParameters.put(name, value);
    }

    public boolean isAuthenticationEnabled() {
        return !this.securityRoles.isEmpty() && !"NONE".equals(this.authenticatorName);
    }

    private void defaultSecuritySettings() {
        this.transportGuarantee = SecuritySettings.getDefaultTransportGuarantee();
        AuthenticationType defaultType = SecuritySettings.isWebSecurityEnabled() ? AuthenticationType.CONTAINER : AuthenticationType.NONE;
        this.authenticatorName = defaultType.name();
    }

    public void loadProperties() {
        String propertyPrefix = "servlet." + this.name + ".";
        this.enabled = (Boolean)this.environment.getProperty(propertyPrefix + "enabled", Boolean.TYPE, (Object)this.enabled);
        this.configureServletSecurity(propertyPrefix);
        String constraintType = this.environment.getProperty(propertyPrefix + "transportGuarantee");
        if (StringUtils.isNotEmpty((CharSequence)constraintType)) {
            this.transportGuarantee = (ServletSecurity.TransportGuarantee)EnumUtils.parse(ServletSecurity.TransportGuarantee.class, (String)constraintType);
        }
        this.loadOnStartup = (Integer)this.environment.getProperty(propertyPrefix + "loadOnStartup", Integer.TYPE, (Object)this.loadOnStartup);
        String mapping = this.environment.getProperty(propertyPrefix + "urlMapping");
        if (StringUtils.isNotEmpty((CharSequence)mapping)) {
            this.setUrlMapping(mapping);
        }
        this.authenticatorName = this.environment.getProperty(propertyPrefix + "authenticator", this.authenticatorName);
    }

    private void configureServletSecurity(String propertyPrefix) {
        String roleNames = this.environment.getProperty(propertyPrefix + "securityRoles");
        if (this.environment.containsProperty(propertyPrefix + "securityroles")) {
            log.warn("property [" + propertyPrefix + "securityroles] has been replaced with [" + propertyPrefix + "securityRoles]");
            roleNames = this.environment.getProperty(propertyPrefix + "securityroles");
        }
        if (StringUtils.isNotEmpty((CharSequence)roleNames)) {
            String[] rolesCopy = roleNames.split(",");
            this.securityRoles = Arrays.asList(rolesCopy);
        }
    }

    private void setUrlMapping(List<String> urlMappings) {
        if (urlMappings == null || urlMappings.isEmpty()) {
            throw new IllegalStateException("servlet must have an URL to map to");
        }
        this.urlMapping = urlMappings.stream().filter(StringUtils::isNotBlank).collect(Collectors.toList());
    }

    public void setUrlMapping(String urlMappingArray) {
        String[] urlMappingsCopy = new String[]{};
        if (StringUtils.isNotEmpty((CharSequence)urlMappingArray)) {
            urlMappingsCopy = urlMappingArray.split(",");
        }
        ArrayList<String> mappings = new ArrayList<String>();
        for (String rawMapping : urlMappingsCopy) {
            char firstChar;
            String mapping = rawMapping.trim();
            if (StringUtils.isBlank((CharSequence)mapping)) continue;
            if ("*".equals(mapping)) {
                mapping = "/*";
            }
            if ((firstChar = mapping.charAt(0)) == '!' && (mapping.charAt(1) != '/' || mapping.charAt(mapping.length() - 1) == '*')) {
                throw new IllegalStateException("when excluding an URL you it must start with '!/' and may not end with a wildcard");
            }
            if (firstChar != '/' && firstChar != '*' && firstChar != '!') {
                mapping = "/" + mapping;
            }
            log.debug("converted raw mapping [{}] to [{}]", (Object)rawMapping, (Object)mapping);
            mappings.add(mapping);
        }
        this.setUrlMapping(mappings);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder(" servlet [" + this.name + "]");
        builder.append(" url(s) " + this.urlMapping);
        builder.append(" loadOnStartup [" + this.loadOnStartup + "]");
        builder.append(" protocol " + (this.transportGuarantee == ServletSecurity.TransportGuarantee.CONFIDENTIAL ? "[HTTPS]" : "[HTTP]"));
        builder.append(" authenticatior [" + this.authenticatorName + "]");
        if (this.isAuthenticationEnabled()) {
            builder.append(" roles " + this.getSecurityRoles());
        } else {
            builder.append(" with no authentication enabled!");
        }
        return builder.toString();
    }

    public String getName() {
        return this.name;
    }

    public List<String> getUrlMapping() {
        return this.urlMapping;
    }

    public int getLoadOnStartup() {
        return this.loadOnStartup;
    }

    public void setLoadOnStartup(int loadOnStartup) {
        this.loadOnStartup = loadOnStartup;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public ServletSecurity.TransportGuarantee getTransportGuarantee() {
        return this.transportGuarantee;
    }

    public String getAuthenticatorName() {
        return this.authenticatorName;
    }

    public Servlet getServlet() {
        return this.servlet;
    }

    public void setEnvironment(Environment environment) {
        this.environment = environment;
    }

    public Map<String, String> getInitParameters() {
        return this.initParameters;
    }
}

