/*
 * Decompiled with CFR 0.152.
 */
package nl.nn.adapterframework.lifecycle.servlets;

import java.util.HashSet;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.security.web.util.matcher.RequestMatcher;

public class URLRequestMatcher
implements RequestMatcher {
    private static final Logger log = LogManager.getLogger(URLRequestMatcher.class);
    private final Set<String> absoluteEndpoints = new HashSet<String>();
    private final Set<String> wildcardEndpoints = new HashSet<String>();

    public URLRequestMatcher(Set<String> rawEndpointsWithExcludes) {
        for (String endpoint : rawEndpointsWithExcludes) {
            if (endpoint.charAt(0) == '!') {
                throw new IllegalArgumentException("endpoint may not start with [!]");
            }
            if (endpoint.charAt(endpoint.length() - 1) == '*') {
                this.wildcardEndpoints.add(endpoint.substring(0, endpoint.length() - 1));
                continue;
            }
            this.absoluteEndpoints.add(endpoint);
        }
        if (this.absoluteEndpoints.isEmpty() && this.wildcardEndpoints.isEmpty()) {
            throw new IllegalArgumentException("must provided at least 1 endpoint");
        }
    }

    public boolean matches(HttpServletRequest request) {
        String path = this.getRequestPath(request);
        if (this.absoluteEndpoints.contains(path)) {
            log.trace("absolute match with path [{}]", (Object)path);
            return true;
        }
        for (String url : this.wildcardEndpoints) {
            if (!path.startsWith(url)) continue;
            log.trace("relative match with url [{}] and path [{}]", (Object)url, (Object)path);
            return true;
        }
        return false;
    }

    private String getRequestPath(HttpServletRequest request) {
        String url = request.getServletPath();
        String pathInfo = request.getPathInfo();
        if (pathInfo != null) {
            url = StringUtils.isNotEmpty((CharSequence)url) ? url + pathInfo : pathInfo;
        }
        return url;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Absolute RequestPatterns ").append(this.absoluteEndpoints);
        sb.append(" Wildcard RequestPatterns ").append(this.wildcardEndpoints);
        return sb.toString();
    }
}

