/*
 * Decompiled with CFR 0.152.
 */
package echopointng;

import echopointng.util.ColorKit;
import nextapp.echo2.app.Border;
import nextapp.echo2.app.Color;
import nextapp.echo2.app.Extent;

public class BorderEx
extends Border {
    public static final BorderEx DEFAULT = new BorderEx(1, Color.BLACK, 1);
    public static final BorderEx NONE = new BorderEx(0, Color.BLACK, 0);
    private Color bottomColor;
    private Extent bottomSize;
    private int bottomStyle;
    private Color color;
    private Color leftColor;
    private Extent leftSize;
    private int leftStyle;
    private Color rightColor;
    private Extent rightSize;
    private int rightStyle;
    private Extent size;
    private int style;
    private Color topColor;
    private Extent topSize;
    private int topStyle;

    public BorderEx() {
        this(1, Color.BLACK, 1);
    }

    public BorderEx(Color color) {
        this(1, color, 1);
    }

    public BorderEx(Extent size, Color color, int style) {
        super(null, null, 0);
        this.setSize(size);
        this.setColor(color);
        this.setStyle(style);
    }

    public BorderEx(Extent leftSize, Color leftColor, int leftStyle, Extent rightSize, Color rightColor, int rightStyle, Extent topSize, Color topColor, int topStyle, Extent bottomSize, Color bottomColor, int bottomStyle) {
        super(null, null, 0);
        this.setLeftColor(leftColor);
        this.setLeftSize(leftSize);
        this.setLeftStyle(leftStyle);
        this.setRightColor(rightColor);
        this.setRightSize(rightSize);
        this.setRightStyle(rightStyle);
        this.setTopColor(topColor);
        this.setTopSize(topSize);
        this.setTopStyle(topStyle);
        this.setBottomColor(bottomColor);
        this.setBottomSize(bottomSize);
        this.setBottomStyle(bottomStyle);
    }

    public BorderEx(int size) {
        this(size, Color.BLACK, 1);
    }

    public BorderEx(int size, Color color) {
        this(size, color, 1);
    }

    public BorderEx(int size, Color color, int style) {
        this(new Extent(size), color, style);
    }

    public BorderEx(int leftSize, Color leftColor, int leftStyle, int rightSize, Color rightColor, int rightStyle, int topSize, Color topColor, int topStyle, int bottomSize, Color bottomColor, int bottomStyle) {
        this(new Extent(leftSize), leftColor, leftStyle, new Extent(rightSize), rightColor, rightStyle, new Extent(topSize), topColor, topStyle, new Extent(bottomSize), bottomColor, bottomStyle);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Border)) {
            return false;
        }
        boolean same = false;
        if (o instanceof BorderEx) {
            BorderEx that = (BorderEx)o;
            same = this.equals(this.leftColor, that.leftColor) && this.equals(this.rightColor, that.rightColor) && this.equals(this.topColor, that.topColor) && this.equals(this.bottomColor, that.bottomColor) && this.equals(this.leftSize, that.leftSize) && this.equals(this.rightSize, that.rightSize) && this.equals(this.topSize, that.topSize) && this.equals(this.bottomSize, that.bottomSize) && this.leftStyle == that.leftStyle && this.rightStyle == that.rightStyle && this.topStyle == that.topStyle && this.bottomStyle == that.bottomStyle;
        } else {
            Border that = (Border)o;
            Color clr = this.leftColor;
            Extent size = this.leftSize;
            int style = this.leftStyle;
            if (this.equals(clr, this.rightColor) && this.equals(clr, this.topColor) && this.equals(clr, this.bottomColor) && this.equals(size, this.rightSize) && this.equals(size, this.topSize) && this.equals(size, this.bottomSize) && style == this.rightStyle && style == this.topStyle && style == this.bottomStyle) {
                same = this.equals(this.getColor(), that.getColor()) && this.equals(this.getSize(), that.getSize()) && this.getStyle() == that.getStyle();
            }
        }
        return same;
    }

    private boolean equals(Object o1, Object o2) {
        if (o1 == o2) {
            return true;
        }
        if (o1 != null) {
            return o1.equals(o2);
        }
        return false;
    }

    public Color getBottomColor() {
        return this.bottomColor;
    }

    public Extent getBottomSize() {
        return this.bottomSize;
    }

    public int getBottomStyle() {
        return this.bottomStyle;
    }

    @Override
    public Color getColor() {
        return this.color;
    }

    public Color getLeftColor() {
        return this.leftColor;
    }

    public Extent getLeftSize() {
        return this.leftSize;
    }

    public int getLeftStyle() {
        return this.leftStyle;
    }

    public Color getRightColor() {
        return this.rightColor;
    }

    public Extent getRightSize() {
        return this.rightSize;
    }

    public int getRightStyle() {
        return this.rightStyle;
    }

    @Override
    public Extent getSize() {
        return this.size;
    }

    @Override
    public int getStyle() {
        return this.style;
    }

    public String getStyleString() {
        switch (this.style) {
            case 0: {
                return "none";
            }
            case 2: {
                return "inset";
            }
            case 3: {
                return "outset";
            }
            case 1: {
                return "solid";
            }
            case 7: {
                return "dotted";
            }
            case 8: {
                return "dashed";
            }
            case 4: {
                return "groove";
            }
            case 5: {
                return "ridge";
            }
            case 6: {
                return "double";
            }
        }
        return "none";
    }

    public Color getTopColor() {
        return this.topColor;
    }

    public Extent getTopSize() {
        return this.topSize;
    }

    public int getTopStyle() {
        return this.topStyle;
    }

    void setAll(Extent size, Color color, int style) {
        this.setLeft(size, color, style);
        this.setRight(size, color, style);
        this.setTop(size, color, style);
        this.setBottom(size, color, style);
    }

    void setAll(int size, Color color, int style) {
        this.setAll(new Extent(size), color, style);
    }

    void setBottom(Extent size, Color color, int style) {
        this.setBottomSize(size);
        this.setBottomColor(color);
        this.setBottomStyle(style);
    }

    void setBottom(int size, Color color, int style) {
        this.setBottom(new Extent(size), color, style);
    }

    void setBottomColor(Color bottomColor) {
        this.bottomColor = bottomColor;
    }

    void setBottomSize(Extent bottomSize) {
        this.bottomSize = bottomSize;
    }

    void setBottomStyle(int bottomStyle) {
        this.bottomStyle = bottomStyle;
    }

    void setColor(Color color) {
        this.color = color;
        this.setLeftColor(color);
        this.setRightColor(color);
        this.setTopColor(color);
        this.setBottomColor(color);
    }

    void setLeft(Extent size, Color color, int style) {
        this.setLeftSize(size);
        this.setLeftColor(color);
        this.setLeftStyle(style);
    }

    void setLeft(int size, Color color, int style) {
        this.setLeft(new Extent(size), color, style);
    }

    void setLeftColor(Color leftColor) {
        this.leftColor = leftColor;
    }

    void setLeftSize(Extent leftSize) {
        this.leftSize = leftSize;
    }

    void setLeftStyle(int leftStyle) {
        this.leftStyle = leftStyle;
    }

    void setRight(Extent size, Color color, int style) {
        this.setRightSize(size);
        this.setRightColor(color);
        this.setRightStyle(style);
    }

    void setRight(int size, Color color, int style) {
        this.setRight(new Extent(size), color, style);
    }

    void setRightColor(Color rightColor) {
        this.rightColor = rightColor;
    }

    void setRightSize(Extent rightSize) {
        this.rightSize = rightSize;
    }

    void setRightStyle(int rightStyle) {
        this.rightStyle = rightStyle;
    }

    void setSize(Extent size) {
        this.size = size;
        this.setLeftSize(size);
        this.setRightSize(size);
        this.setTopSize(size);
        this.setBottomSize(size);
    }

    void setStyle(int style) {
        this.style = style;
        this.setLeftStyle(style);
        this.setRightStyle(style);
        this.setTopStyle(style);
        this.setBottomStyle(style);
    }

    void setTop(Extent size, Color color, int style) {
        this.setTopSize(size);
        this.setTopColor(color);
        this.setTopStyle(style);
    }

    void setTop(int size, Color color, int style) {
        this.setTop(new Extent(size), color, style);
    }

    void setTopColor(Color topColor) {
        this.topColor = topColor;
    }

    void setTopSize(Extent topSize) {
        this.topSize = topSize;
    }

    void setTopStyle(int topStyle) {
        this.topStyle = topStyle;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("border-left:");
        sb.append(this.leftSize == null ? "null" : this.leftSize.toString());
        sb.append(" ");
        sb.append(this.getStyleString());
        sb.append(" ");
        sb.append(this.leftColor == null ? "null" : ColorKit.makeColorString(this.leftColor));
        sb.append("; ");
        sb.append("border-right:");
        sb.append(this.rightSize == null ? "null" : this.rightSize.toString());
        sb.append(" ");
        sb.append(this.getStyleString());
        sb.append(" ");
        sb.append(this.rightColor == null ? "null" : ColorKit.makeColorString(this.rightColor));
        sb.append("; ");
        sb.append("border-top:");
        sb.append(this.topSize == null ? "null" : this.topSize.toString());
        sb.append(" ");
        sb.append(this.getStyleString());
        sb.append(" ");
        sb.append(this.topColor == null ? "null" : ColorKit.makeColorString(this.topColor));
        sb.append("; ");
        sb.append("border-bottom:");
        sb.append(this.bottomSize == null ? "null" : this.bottomSize.toString());
        sb.append(" ");
        sb.append(this.getStyleString());
        sb.append(" ");
        sb.append(this.bottomColor == null ? "null" : ColorKit.makeColorString(this.bottomColor));
        sb.append("; ");
        sb.append("border:");
        sb.append(this.size == null ? "null" : this.size.toString());
        sb.append(" ");
        sb.append(this.getStyleString());
        sb.append(" ");
        sb.append(this.color == null ? "null" : ColorKit.makeColorString(this.color));
        sb.append(";");
        return sb.toString();
    }
}

