/*
 * Decompiled with CFR 0.152.
 */
package echopointng;

import echopointng.AbleComponent;
import echopointng.BorderEx;
import echopointng.ExtentEx;
import echopointng.MutableStyleEx;
import echopointng.util.ColorKit;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.util.EventListener;
import nextapp.echo2.app.Color;
import nextapp.echo2.app.Extent;
import nextapp.echo2.app.Font;
import nextapp.echo2.app.Insets;
import nextapp.echo2.app.Style;
import nextapp.echo2.app.event.ActionEvent;
import nextapp.echo2.app.event.ActionListener;
import nextapp.echo2.app.event.DocumentEvent;
import nextapp.echo2.app.event.DocumentListener;
import nextapp.echo2.app.text.Document;
import nextapp.echo2.app.text.StringDocument;

public class Calculator
extends AbleComponent {
    public static final String ACTION_LISTENERS_CHANGED_PROPERTY = "actionListeners";
    public static Style DEFAULT_STYLE;
    public static final String DOCUMENT_CHANGED_PROPERTY = "document";
    public static final String INPUT_TRANSFER = "transfer";
    public static final String PROPERTY_ACTION_COMMAND = "actionCommand";
    public static final String PROPERTY_BUTTON_BACKGROUND = "buttonBackground";
    public static final String PROPERTY_BUTTON_OPERATOR_FOREGROUND = "buttonOperatorForeground";
    public static final String PROPERTY_BUTTON_NUMBER_FOREGROUND = "buttonNumberForeground";
    public static final String PROPERTY_BUTTON_HEIGHT = "buttonHeight";
    public static final String PROPERTY_BUTTON_WIDTH = "buttonWidth";
    public static final String PROPERTY_DISPLAY_BACKGROUND = "displayBackground";
    public static final String PROPERTY_DISPLAY_FONT = "displayFont";
    public static final String PROPERTY_DISPLAY_FOREGROUND = "displayForeground";
    public static final String PROPERTY_MEMORY = "memory";
    public static final String PROPERTY_TRANSFER = "transfer";
    public static final String TEXT_CHANGED_PROPERTY = "text";
    public static final String DEFAULT_NUMBER_MASK = "########################0.0########################";
    private Document document;
    private DocumentListener documentListener = new DocumentListener(){

        @Override
        public void documentUpdate(DocumentEvent e) {
            Calculator.this.firePropertyChange(Calculator.TEXT_CHANGED_PROPERTY, null, ((Document)e.getSource()).getText());
        }
    };

    public Calculator() {
        this.setDocument(new StringDocument());
        this.setText("0");
    }

    public Calculator(Document document) {
        this.setDocument(document);
    }

    public void addActionListener(ActionListener l) {
        this.getEventListenerList().addListener(ActionListener.class, l);
        this.firePropertyChange(ACTION_LISTENERS_CHANGED_PROPERTY, null, l);
    }

    private void fireActionEvent() {
        if (!this.hasEventListenerList()) {
            return;
        }
        EventListener[] listeners = this.getEventListenerList().getListeners(ActionListener.class);
        ActionEvent e = null;
        for (int i = 0; i < listeners.length; ++i) {
            if (e == null) {
                e = new ActionEvent(this, (String)this.getRenderProperty(PROPERTY_ACTION_COMMAND));
            }
            ((ActionListener)listeners[i]).actionPerformed(e);
        }
    }

    public String getActionCommand() {
        return (String)this.getProperty(PROPERTY_ACTION_COMMAND);
    }

    public Color getButtonBackground() {
        return (Color)this.getProperty(PROPERTY_BUTTON_BACKGROUND);
    }

    public Color getButtonOperatorForeground() {
        return (Color)this.getProperty(PROPERTY_BUTTON_OPERATOR_FOREGROUND);
    }

    public Color getButtonNumberForeground() {
        return (Color)this.getProperty(PROPERTY_BUTTON_NUMBER_FOREGROUND);
    }

    public Extent getButtonHeight() {
        return (Extent)this.getProperty(PROPERTY_BUTTON_HEIGHT);
    }

    public Extent getButtonWidth() {
        return (Extent)this.getProperty(PROPERTY_BUTTON_WIDTH);
    }

    public Color getDisplayBackground() {
        return (Color)this.getProperty(PROPERTY_DISPLAY_BACKGROUND);
    }

    public Font getDisplayFont() {
        return (Font)this.getProperty(PROPERTY_DISPLAY_FONT);
    }

    public Color getDisplayForeground() {
        return (Color)this.getProperty(PROPERTY_DISPLAY_FOREGROUND);
    }

    public Document getDocument() {
        return this.document;
    }

    public String getMemory() {
        return (String)this.getProperty(PROPERTY_MEMORY);
    }

    public String getTransfer() {
        return (String)this.getProperty("transfer");
    }

    public String getText() {
        return this.document.getText();
    }

    public boolean hasActionListeners() {
        return this.hasEventListenerList() && this.getEventListenerList().getListenerCount(ActionListener.class) != 0;
    }

    @Override
    public void processInput(String inputName, Object inputValue) {
        super.processInput(inputName, inputValue);
        if (TEXT_CHANGED_PROPERTY.equals(inputName)) {
            this.setText((String)inputValue);
        }
        if (PROPERTY_MEMORY.equals(inputName)) {
            this.setMemory((String)inputValue);
        }
        if ("transfer".equals(inputName)) {
            this.fireActionEvent();
        }
    }

    public void removeActionListener(ActionListener l) {
        if (!this.hasEventListenerList()) {
            return;
        }
        this.getEventListenerList().removeListener(ActionListener.class, l);
        this.firePropertyChange(ACTION_LISTENERS_CHANGED_PROPERTY, l, null);
    }

    public void setActionCommand(String newValue) {
        this.setProperty(PROPERTY_ACTION_COMMAND, newValue);
    }

    public void setButtonBackground(Color newValue) {
        this.setProperty(PROPERTY_BUTTON_BACKGROUND, newValue);
    }

    public void setButtonOperatorForeground(Color newValue) {
        this.setProperty(PROPERTY_BUTTON_OPERATOR_FOREGROUND, newValue);
    }

    public void setButtonNumberForeground(Color newValue) {
        this.setProperty(PROPERTY_BUTTON_NUMBER_FOREGROUND, newValue);
    }

    public void setButtonHeight(Extent newValue) {
        this.setProperty(PROPERTY_BUTTON_HEIGHT, newValue);
    }

    public void setButtonWidth(Extent newValue) {
        this.setProperty(PROPERTY_BUTTON_WIDTH, newValue);
    }

    public void setDisplayBackground(Color newValue) {
        this.setProperty(PROPERTY_DISPLAY_BACKGROUND, newValue);
    }

    public void setDisplayFont(Font newValue) {
        this.setProperty(PROPERTY_DISPLAY_FONT, newValue);
    }

    public void setDisplayForeground(Color newValue) {
        this.setProperty(PROPERTY_DISPLAY_FOREGROUND, newValue);
    }

    public void setDocument(Document newValue) {
        if (newValue == null) {
            throw new IllegalArgumentException("Document may not be null.");
        }
        Document oldValue = this.getDocument();
        if (oldValue != null) {
            oldValue.removeDocumentListener(this.documentListener);
        }
        newValue.addDocumentListener(this.documentListener);
        this.document = newValue;
    }

    public boolean isValidNumber(String numberText) {
        try {
            DecimalFormat nf = new DecimalFormat(DEFAULT_NUMBER_MASK);
            nf.parse(numberText);
            return true;
        }
        catch (ParseException pe) {
            return false;
        }
    }

    public void setMemory(String newValue) {
        if (newValue != null && !this.isValidNumber(newValue)) {
            throw new IllegalArgumentException("An invalid number " + newValue + " was provided as calculator memory");
        }
        this.setProperty(PROPERTY_MEMORY, newValue);
    }

    public void setTransfer(String newValue) {
        this.setProperty("transfer", newValue);
    }

    public void setText(String newValue) {
        if (newValue != null && !this.isValidNumber(newValue)) {
            throw new IllegalArgumentException("An invalid number " + newValue + " was provided as calculator value");
        }
        this.getDocument().setText(newValue);
    }

    static {
        MutableStyleEx style = new MutableStyleEx();
        style.setProperty(PROPERTY_DISPLAY_BACKGROUND, Color.BLACK);
        style.setProperty(PROPERTY_DISPLAY_FOREGROUND, Color.GREEN);
        style.setProperty(PROPERTY_DISPLAY_FONT, new Font(Font.MONOSPACE, 0, new ExtentEx("8pt")));
        style.setProperty("insets", new Insets(2));
        style.setProperty("border", new BorderEx(1));
        style.setProperty("background", ColorKit.clr("#ECE9D8"));
        style.setProperty("font", new Font(Font.MONOSPACE, 0, new ExtentEx("8pt")));
        style.setProperty(PROPERTY_BUTTON_NUMBER_FOREGROUND, Color.BLUE);
        style.setProperty(PROPERTY_BUTTON_WIDTH, new ExtentEx("35px"));
        style.setProperty(PROPERTY_BUTTON_HEIGHT, new ExtentEx("35px"));
        DEFAULT_STYLE = style;
    }
}

