/*
 * Decompiled with CFR 0.152.
 */
package echopointng;

import echopointng.BorderEx;
import echopointng.Calculator;
import echopointng.DropDown;
import echopointng.MutableStyleEx;
import echopointng.util.ColorKit;
import nextapp.echo2.app.Component;
import nextapp.echo2.app.Style;
import nextapp.echo2.app.TextField;
import nextapp.echo2.app.event.ActionEvent;
import nextapp.echo2.app.event.ActionListener;
import nextapp.echo2.app.event.DocumentEvent;
import nextapp.echo2.app.event.DocumentListener;
import nextapp.echo2.app.text.Document;
import nextapp.echo2.app.text.StringDocument;

public class CalculatorField
extends DropDown {
    public static final Style DEFAULT_TEXT_FIELD_STYLE;
    public static final Style DEFAULT_CALCULATOR_FIELD_STYLE;
    public static final Style DEFAULT_STYLE;
    private InternalListener internalListener = new InternalListener();

    public CalculatorField() {
        this(0.0);
    }

    public CalculatorField(double value) {
        StringDocument document = new StringDocument();
        document.addDocumentListener(this.internalListener);
        TextField textField = new TextField(document);
        Calculator calculator = new Calculator(document);
        calculator.setTransfer("OK");
        calculator.addActionListener(this.internalListener);
        this.setTarget(textField);
        this.setPopUp(calculator);
        textField.setStyle(DEFAULT_TEXT_FIELD_STYLE);
        calculator.setStyle(DEFAULT_CALCULATOR_FIELD_STYLE);
        this.setValue(value);
    }

    public double getValue() {
        Component popup = this.getPopUp();
        if (popup instanceof Calculator) {
            String text = ((Calculator)popup).getText();
            return Double.parseDouble(text);
        }
        return Double.NaN;
    }

    public void setValue(double newValue) {
        Component popup = this.getPopUp();
        if (popup instanceof Calculator) {
            ((Calculator)popup).setText(String.valueOf(newValue));
        }
    }

    public TextField getTextField() {
        return (TextField)this.getTarget();
    }

    public Calculator getCalculator() {
        return (Calculator)this.getPopUp();
    }

    public void setTextField(TextField newValue) {
        if (newValue == null || newValue.getDocument() == null) {
            throw new IllegalArgumentException("The TextField and its Document must be non null.");
        }
        Document document = newValue.getDocument();
        this.setTarget(newValue);
        this.setDocument(document);
    }

    public void setCalculator(Calculator newValue) {
        if (newValue == null || newValue.getDocument() == null) {
            throw new IllegalArgumentException("The Calculator and its Document must be non null.");
        }
        Calculator oldValue = this.getCalculator();
        if (oldValue != null) {
            oldValue.removeActionListener(this.internalListener);
        }
        newValue.addActionListener(this.internalListener);
        Document document = newValue.getDocument();
        this.setPopUp(newValue);
        this.setDocument(document);
    }

    public Document getDocument() {
        if (this.getTextField() != null && this.getTextField().getDocument() != null) {
            return this.getTextField().getDocument();
        }
        if (this.getCalculator() != null && this.getCalculator().getDocument() != null) {
            return this.getCalculator().getDocument();
        }
        return null;
    }

    public void setDocument(Document newValue) {
        if (newValue == null) {
            throw new IllegalArgumentException("The Document must not be null!");
        }
        Document oldValue = this.getDocument();
        if (oldValue != null) {
            oldValue.removeDocumentListener(this.internalListener);
        }
        newValue.addDocumentListener(this.internalListener);
        if (this.getTextField() != null) {
            this.getTextField().setDocument(newValue);
        }
        if (this.getCalculator() != null) {
            this.getCalculator().setDocument(newValue);
        }
    }

    static {
        MutableStyleEx style = new MutableStyleEx();
        style.setProperty("border", new BorderEx(0, null, 0));
        DEFAULT_TEXT_FIELD_STYLE = style;
        style = new MutableStyleEx(Calculator.DEFAULT_STYLE);
        style.setProperty("border", new BorderEx(0, null, 0));
        DEFAULT_CALCULATOR_FIELD_STYLE = style;
        style = new MutableStyleEx(DropDown.DEFAULT_STYLE);
        style.setProperty("popUpBackground", ColorKit.clr("#ECE9D8"));
        DEFAULT_STYLE = style;
    }

    private class InternalListener
    implements ActionListener,
    DocumentListener {
        private InternalListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            CalculatorField.this.setExpanded(false);
        }

        @Override
        public void documentUpdate(DocumentEvent e) {
            CalculatorField.this.firePropertyChange("text", null, null);
        }
    }
}

