/*
 * Decompiled with CFR 0.152.
 */
package echopointng;

import echopointng.BorderEx;
import echopointng.DropDown;
import echopointng.MutableStyleEx;
import java.io.Serializable;
import java.util.EventListener;
import nextapp.echo2.app.Component;
import nextapp.echo2.app.DelegateFocusSupport;
import nextapp.echo2.app.Style;
import nextapp.echo2.app.TextField;
import nextapp.echo2.app.event.ActionEvent;
import nextapp.echo2.app.event.ActionListener;
import nextapp.echo2.app.event.DocumentEvent;
import nextapp.echo2.app.event.DocumentListener;
import nextapp.echo2.app.event.ListDataEvent;
import nextapp.echo2.app.event.ListDataListener;
import nextapp.echo2.app.list.AbstractListComponent;
import nextapp.echo2.app.list.DefaultListModel;
import nextapp.echo2.app.list.ListCellRenderer;
import nextapp.echo2.app.list.ListModel;
import nextapp.echo2.app.text.StringDocument;

public class ComboBox
extends DropDown
implements DelegateFocusSupport {
    public static final String PROPERTY_ACTION_ON_SELECTION = "actionOnSelection";
    public static final String PROPERTY_AUTO_RECALL = "autoRecall";
    public static final String PROPERTY_AUTO_RECALL_LIMIT = "autoRecallLimit";
    public static final String PROPERTY_CASE_SENSITIVE = "caseSensitive";
    public static final String PROPERTY_LIST_ROWCOUNT = "listRowCount";
    public static final String PROPERTY_TEXT_MATCHING = "textMatching";
    public static final String PROPERTY_TEXTFIELD_DOCUMENT = "textFieldDocument";
    public static final String PROPERTY_TEXTFIELD_EDITABLE = "textFieldEditable";
    private static final int DEFAULT_AUTO_RECALL_LIMIT = 20;
    private static final int DEFAULT_TEXT_FIELD_COLUMNS = 20;
    private static final int DEFAULT_LIST_ROWCOUNT = 5;
    public static final Style DEFAULT_TEXT_FIELD_STYLE;
    private TextField textField;
    private ListModel listModel;
    private ListCellRenderer listCellRenderer = AbstractListComponent.DEFAULT_LIST_CELL_RENDERER;
    private boolean selectionPending;
    private TextFieldListener textFieldListener = new TextFieldListener();
    private DocListener docListener = new DocListener();
    private ListDataHandler listListener = new ListDataHandler();

    public ComboBox() {
        this(null, 20, new Object[0]);
    }

    public ComboBox(int columns) {
        this(null, columns, new Object[0]);
    }

    public ComboBox(String text) {
        this(text, 20, new Object[0]);
    }

    public ComboBox(Object[] list) {
        this(null, 20, list);
    }

    public ComboBox(String text, Object[] list) {
        this(text, 20, list);
    }

    public ComboBox(String text, int columns, Object[] list) {
        TextField tf = new TextField(new StringDocument(), text, columns);
        tf.setStyle(DEFAULT_TEXT_FIELD_STYLE);
        this.setTextField(tf);
        this.setListModel(new DefaultListModel(list));
    }

    @Override
    public Component getFocusComponent() {
        return this.getTextField();
    }

    public void addActionListener(ActionListener l) {
        this.getEventListenerList().addListener(ActionListener.class, l);
        this.firePropertyChange("actionListeners", null, l);
        this.textField.addActionListener(this.textFieldListener);
    }

    public void removeActionListener(ActionListener l) {
        this.getEventListenerList().removeListener(ActionListener.class, l);
        this.firePropertyChange("actionListeners", l, null);
        this.textField.removeActionListener(this.textFieldListener);
    }

    @Override
    public void validate() {
        super.validate();
        if (this.selectionPending) {
            this.setExpanded(false);
            this.selectionPending = false;
        }
    }

    private void fireActionEvent() {
        EventListener[] listeners = this.getEventListenerList().getListeners(ActionListener.class);
        ActionEvent e = null;
        for (int i = 0; i < listeners.length; ++i) {
            if (e == null) {
                e = new ActionEvent(this, (String)this.getRenderProperty("actionCommand"));
            }
            ((ActionListener)listeners[i]).actionPerformed(e);
        }
    }

    private void updateListModel() {
        if (this.isAutoRecall()) {
            String text = this.getText();
            if (this.listModel instanceof DefaultListModel && text.length() > 0) {
                int modelSize = this.listModel.size();
                DefaultListModel dm = (DefaultListModel)this.listModel;
                boolean found = false;
                for (int i = 0; i < modelSize; ++i) {
                    if (!text.equals(this.listModel.get(i))) continue;
                    found = true;
                    break;
                }
                if (!found && modelSize < this.getAutoRecallLimit()) {
                    dm.add(text);
                }
            }
        }
    }

    public int getAutoRecallLimit() {
        return ComboBox.getProperty((Component)this, PROPERTY_AUTO_RECALL_LIMIT, 20);
    }

    public ListCellRenderer getListCellRenderer() {
        return this.listCellRenderer;
    }

    public ListModel getListModel() {
        return this.listModel;
    }

    public String getText() {
        return this.textField.getText();
    }

    public int getListRowCount() {
        return ComboBox.getProperty((Component)this, PROPERTY_LIST_ROWCOUNT, 5);
    }

    public TextField getTextField() {
        return this.textField;
    }

    public boolean hasActionListeners() {
        return this.getEventListenerList().getListenerCount(ActionListener.class) != 0;
    }

    public boolean isActionOnSelection() {
        return ComboBox.getProperty((Component)this, PROPERTY_ACTION_ON_SELECTION, false);
    }

    public boolean isAutoRecall() {
        return ComboBox.getProperty((Component)this, PROPERTY_AUTO_RECALL, false);
    }

    public boolean isCaseSensitive() {
        return ComboBox.getProperty((Component)this, PROPERTY_CASE_SENSITIVE, false);
    }

    public boolean isTextMatchingPerformed() {
        return ComboBox.getProperty((Component)this, PROPERTY_TEXT_MATCHING, true);
    }

    public void setAutoRecallLimit(int newValue) {
        ComboBox.setProperty((Component)this, PROPERTY_AUTO_RECALL_LIMIT, newValue);
    }

    public void setAutoRecall(boolean newValue) {
        ComboBox.setProperty((Component)this, PROPERTY_AUTO_RECALL, newValue);
    }

    public void setActionOnSelection(boolean newValue) {
        ComboBox.setProperty((Component)this, PROPERTY_ACTION_ON_SELECTION, newValue);
    }

    public void setCaseSensitive(boolean newValue) {
        ComboBox.setProperty((Component)this, PROPERTY_CASE_SENSITIVE, newValue);
    }

    public void setListRowCount(int newValue) {
        ComboBox.setProperty((Component)this, PROPERTY_LIST_ROWCOUNT, newValue);
    }

    public void setListCellRenderer(ListCellRenderer newValue) {
        if (newValue == null) {
            throw new IllegalArgumentException("The list cell renderer must be non null");
        }
        ListCellRenderer oldValue = this.listCellRenderer;
        this.listCellRenderer = newValue;
        this.firePropertyChange("listCellRenderer", oldValue, newValue);
    }

    public void setListModel(ListModel newValue) {
        if (newValue == null) {
            throw new IllegalArgumentException("The list model must be non null");
        }
        ListModel oldValue = this.listModel;
        if (oldValue != null) {
            oldValue.removeListDataListener(this.listListener);
        }
        newValue.addListDataListener(this.listListener);
        this.listModel = newValue;
        this.firePropertyChange("listModel", oldValue, newValue);
    }

    public void setText(String newValue) {
        this.textField.setText(newValue);
    }

    public void setTextField(TextField newValue) {
        if (newValue == null || newValue.getDocument() == null) {
            throw new IllegalArgumentException("The TextField and its Document must be non null.");
        }
        TextField oldValue = this.textField;
        if (oldValue != null) {
            oldValue.getDocument().removeDocumentListener(this.docListener);
        }
        newValue.getDocument().addDocumentListener(this.docListener);
        this.textField = newValue;
        this.setTarget(newValue);
    }

    public void setTextMatchingPerformed(boolean newValue) {
        ComboBox.setProperty((Component)this, PROPERTY_TEXT_MATCHING, newValue);
    }

    static {
        MutableStyleEx style = new MutableStyleEx();
        style.setProperty("border", new BorderEx(0, null, 0));
        DEFAULT_TEXT_FIELD_STYLE = style;
    }

    private class ListDataHandler
    implements ListDataListener,
    Serializable {
        private ListDataHandler() {
        }

        @Override
        public void contentsChanged(ListDataEvent e) {
            ComboBox.this.firePropertyChange("listData", null, null);
        }

        @Override
        public void intervalAdded(ListDataEvent e) {
            ComboBox.this.firePropertyChange("listData", null, null);
        }

        @Override
        public void intervalRemoved(ListDataEvent e) {
            ComboBox.this.firePropertyChange("listData", null, null);
        }
    }

    private class DocListener
    implements DocumentListener {
        private DocListener() {
        }

        @Override
        public void documentUpdate(DocumentEvent e) {
            ComboBox.this.firePropertyChange(ComboBox.PROPERTY_TEXTFIELD_DOCUMENT, null, null);
        }
    }

    private class TextFieldListener
    implements ActionListener {
        private TextFieldListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ComboBox.this.updateListModel();
            ComboBox.this.fireActionEvent();
            ComboBox.this.setExpanded(false);
            ComboBox.this.selectionPending = true;
        }
    }
}

