/*
 * Decompiled with CFR 0.152.
 */
package echopointng;

import echopointng.AbleComponent;
import echopointng.MutableStyleEx;
import echopointng.able.BackgroundImageable;
import echopointng.able.Positionable;
import echopointng.able.ScrollBarProperties;
import echopointng.able.Scrollable;
import echopointng.able.Stretchable;
import nextapp.echo2.app.Color;
import nextapp.echo2.app.Component;
import nextapp.echo2.app.Extent;
import nextapp.echo2.app.FillImage;
import nextapp.echo2.app.PaneContainer;
import nextapp.echo2.app.Style;

public class ContainerEx
extends AbleComponent
implements PaneContainer,
Positionable,
Scrollable,
BackgroundImageable,
Stretchable {
    public static final Style DEFAULT_STYLE;
    public static final String PROPERTY_BACKGROUND_IMAGE = "backgroundImage";
    public static final String PROPERTY_HORIZONTAL_SCROLL = "horizontalScroll";
    public static final String PROPERTY_VERTICAL_SCROLL = "verticalScroll";

    public ContainerEx() {
    }

    public ContainerEx(Component child) {
        this();
        this.add(child);
    }

    @Override
    public void clear() {
        this.setZIndex(Integer.MIN_VALUE);
        this.setPosition(4);
        this.setLeft(null);
        this.setRight(null);
        this.setTop(null);
        this.setBottom(null);
    }

    @Override
    public FillImage getBackgroundImage() {
        return (FillImage)this.getProperty(PROPERTY_BACKGROUND_IMAGE);
    }

    @Override
    public Extent getBottom() {
        return (Extent)this.getProperty("bottom");
    }

    public Extent getHorizontalScroll() {
        return (Extent)this.getProperty(PROPERTY_HORIZONTAL_SCROLL);
    }

    @Override
    public Extent getLeft() {
        return (Extent)this.getProperty("left");
    }

    @Override
    public int getPosition() {
        return this.getProperty("position", 4);
    }

    @Override
    public Extent getRight() {
        return (Extent)this.getProperty("right");
    }

    @Override
    public Color getScrollBarBaseColor() {
        return (Color)this.getProperty("scrollBarBaseColor");
    }

    @Override
    public int getScrollBarPolicy() {
        return this.getProperty("scrollBarPolicy", 4);
    }

    @Override
    public ScrollBarProperties getScrollBarProperties() {
        return (ScrollBarProperties)this.getProperty("scrollBarProperties");
    }

    @Override
    public Extent getTop() {
        return (Extent)this.getProperty("top");
    }

    public Extent getVerticalScroll() {
        return (Extent)this.getProperty(PROPERTY_VERTICAL_SCROLL);
    }

    @Override
    public int getZIndex() {
        return this.getProperty("zIndex", Integer.MIN_VALUE);
    }

    @Override
    public boolean isPositioned() {
        return this.getPosition() != 1;
    }

    @Override
    public void processInput(String inputName, Object inputValue) {
        if (PROPERTY_HORIZONTAL_SCROLL.equals(inputName)) {
            this.setHorizontalScroll((Extent)inputValue);
        } else if (PROPERTY_VERTICAL_SCROLL.equals(inputName)) {
            this.setVerticalScroll((Extent)inputValue);
        }
    }

    @Override
    public void setBackgroundImage(FillImage newValue) {
        this.setProperty(PROPERTY_BACKGROUND_IMAGE, newValue);
    }

    @Override
    public void setBottom(Extent newValue) {
        this.setProperty("bottom", newValue);
    }

    public void setHorizontalScroll(Extent newValue) {
        this.setProperty(PROPERTY_HORIZONTAL_SCROLL, newValue);
    }

    @Override
    public void setLeft(Extent newValue) {
        this.setProperty("left", newValue);
    }

    @Override
    public void setPosition(int newPositioning) {
        this.setProperty("position", newPositioning);
    }

    @Override
    public void setRight(Extent newValue) {
        this.setProperty("right", newValue);
    }

    @Override
    public void setScrollBarBaseColor(Color newValue) {
        this.setProperty("scrollBarBaseColor", newValue);
    }

    @Override
    public void setScrollBarPolicy(int newScrollBarPolicy) {
        this.setProperty("scrollBarPolicy", newScrollBarPolicy);
    }

    @Override
    public void setScrollBarProperties(ScrollBarProperties newValue) {
        this.setProperty("scrollBarProperties", newValue);
    }

    @Override
    public void setTop(Extent newValue) {
        this.setProperty("top", newValue);
    }

    public void setVerticalScroll(Extent newValue) {
        this.setProperty(PROPERTY_VERTICAL_SCROLL, newValue);
    }

    @Override
    public void setZIndex(int newValue) {
        this.setProperty("zIndex", newValue);
    }

    @Override
    public Extent getMaximumStretchedHeight() {
        return (Extent)this.getProperty("maximumStretchedHeight");
    }

    @Override
    public Extent getMinimumStretchedHeight() {
        return (Extent)this.getProperty("minimumStretchedHeight");
    }

    @Override
    public boolean isHeightStretched() {
        return this.getProperty("heightStretched", false);
    }

    @Override
    public void setHeightStretched(boolean newValue) {
        this.setProperty("heightStretched", newValue);
    }

    @Override
    public void setMaximumStretchedHeight(Extent newValue) {
        Extent.validate(newValue, 1);
        this.setProperty("maximumStretchedHeight", newValue);
    }

    @Override
    public void setMinimumStretchedHeight(Extent newValue) {
        Extent.validate(newValue, 1);
        this.setProperty("minimumStretchedHeight", newValue);
    }

    static {
        MutableStyleEx style = new MutableStyleEx();
        style.setProperty("position", 4);
        DEFAULT_STYLE = style;
    }
}

