/*
 * Decompiled with CFR 0.152.
 */
package echopointng;

import echopointng.ComponentEx;
import echopointng.LabelEx;
import echopointng.MutableStyleEx;
import echopointng.util.ColorKit;
import echopointng.util.reflect.ReflectionKit;
import nextapp.echo2.app.Border;
import nextapp.echo2.app.Component;
import nextapp.echo2.app.Style;

public class EditableLabelEx
extends LabelEx {
    public static final int ACTIVATE_ON_DBLCLICK = 0;
    public static final int ACTIVATE_ON_DELAYEDCLICK = 1;
    public static final String PROPERTY_SYNCHRONIZED_WITH_TARGET = "synchronizedWithTarget";
    public static final String PROPERTY_ACTIVATION_METHOD = "activationMethod";
    public static final Style DEFAULT_STYLE;
    private Component target;

    public EditableLabelEx() {
        this((Component)null);
    }

    public EditableLabelEx(Component target) {
        this.setTarget(target);
    }

    @Override
    public void processInput(String inputName, Object inputValue) {
        super.processInput(inputName, inputValue);
    }

    public Component getTarget() {
        return this.target;
    }

    public void setTarget(Component target) {
        this.target = target;
        if (target != null && !this.isAncestorOf(target)) {
            this.add(target);
        }
    }

    @Override
    public boolean isValidChild(Component component) {
        return true;
    }

    protected void synchroniseWithTarget() {
        Component target = this.getTarget();
        if (target != null) {
            String oldValue = super.getText();
            String newValue = (String)ReflectionKit.invokeIfPresent("getText", new Class[0], String.class, target, new Object[0]);
            if (newValue != null && !newValue.equals(oldValue)) {
                this.setText(newValue);
            }
        }
    }

    public boolean isSynchronisedWithTarget() {
        return ComponentEx.getProperty((Component)this, PROPERTY_SYNCHRONIZED_WITH_TARGET, true);
    }

    @Override
    public String getText() {
        if (this.isSynchronisedWithTarget()) {
            this.synchroniseWithTarget();
        }
        return super.getText();
    }

    public void setSynchronisedWithTarget(boolean newValue) {
        ComponentEx.setProperty((Component)this, PROPERTY_SYNCHRONIZED_WITH_TARGET, newValue);
    }

    public int getActivationMethod() {
        return ComponentEx.getProperty((Component)this, PROPERTY_ACTIVATION_METHOD, 0);
    }

    public void setActivationMethod(int newValue) {
        ComponentEx.setProperty((Component)this, PROPERTY_ACTIVATION_METHOD, newValue);
    }

    @Override
    public void validate() {
        super.validate();
        if (this.isSynchronisedWithTarget()) {
            this.synchroniseWithTarget();
        }
    }

    static {
        MutableStyleEx style = new MutableStyleEx(LabelEx.DEFAULT_STYLE);
        style.setProperty("rolloverEnabled", true);
        style.setProperty("rolloverBackground", ColorKit.makeColor("#DEF3FF"));
        style.setProperty("rolloverBorder", new Border(1, ColorKit.makeColor("#3169C6"), 8));
        style.setProperty("mouseCursor", 3);
        DEFAULT_STYLE = style;
    }
}

