/*
 * Decompiled with CFR 0.152.
 */
package echopointng;

import echopointng.AbleComponent;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import nextapp.echo2.app.Component;
import nextapp.echo2.app.ImageReference;
import nextapp.echo2.app.event.ListDataEvent;
import nextapp.echo2.app.event.ListDataListener;
import nextapp.echo2.app.list.DefaultListModel;
import nextapp.echo2.app.list.ListModel;

public class ListSection
extends AbleComponent {
    public static final String PROPERTY_ORDERING = "ordering";
    public static final String PROPERTY_BULLETS = "bullets";
    public static final String PROPERTY_BULLETS_IMAGE = "bulletsImage";
    public static final String PROPERTY_MODEL = "model";
    public static final int BULLETS_NONE = 0;
    public static final int BULLETS_DISC = 1;
    public static final int BULLETS_CIRCLE = 2;
    public static final int BULLETS_SQUARE = 3;
    public static final int BULLETS_DECIMAL = 4;
    public static final int BULLETS_DECIMAL_LEADING_ZERO = 5;
    public static final int BULLETS_LOWER_ROMAN = 6;
    public static final int BULLETS_UPPER_ROMAN = 7;
    public static final int BULLETS_LOWER_ALPHA = 8;
    public static final int BULLETS_UPPER_ALPHA = 9;
    public static final int BULLETS_LOWER_GREEK = 10;
    public static final int BULLETS_LOWER_LATIN = 11;
    public static final int BULLETS_UPPER_LATIN = 12;
    public static final int BULLETS_DEFAULT = 1;
    public static final int ORDERED = 0;
    public static final int UNORDERED = 1;
    private ListDataHandler dataListener;

    public ListSection() {
        this(1, new ArrayList());
    }

    public ListSection(Object[] arrList) {
        this(1, arrList);
    }

    public ListSection(int ordering) {
        this(ordering, new ArrayList());
    }

    public ListSection(int ordering, Object[] arrList) {
        ArrayList<Object> newList = new ArrayList<Object>(arrList.length);
        for (int i = 0; i < arrList.length; ++i) {
            newList.add(arrList[i]);
        }
        this.construct(ordering, newList);
    }

    public ListSection(int ordering, List newList) {
        this.construct(ordering, newList);
    }

    public void add(Object object) {
        this.add(object, this.getModel().size());
    }

    public void add(Object object, int index) {
        if (object instanceof Component) {
            this.add((Component)object, index);
        } else {
            this.addImpl(object, index);
        }
    }

    @Override
    public void add(Component c) {
        this.add(c, -1);
    }

    @Override
    public void add(Component c, int index) {
        if (index == -1) {
            super.add(c, -1);
            index = this.getModel().size();
        } else if (index >= this.getComponentCount()) {
            super.add(c, -1);
        } else {
            super.add(c, index);
        }
        this.addImpl(c, index);
    }

    private void addImpl(Object object, int index) {
        if (this.getModel() instanceof DefaultListModel) {
            ((DefaultListModel)this.getModel()).add(index, object);
        }
    }

    public void addListDataListener(ListDataListener l) {
        this.getModel().addListDataListener(l);
    }

    private void construct(int ordering, List newList) {
        this.dataListener = new ListDataHandler();
        this.setOrdering(ordering);
        DefaultListModel model = new DefaultListModel(newList.toArray());
        this.setModel(model);
        model.addListDataListener(this.dataListener);
    }

    public int getBullets() {
        return this.getProperty(PROPERTY_BULLETS, 1);
    }

    public ImageReference getBulletsImage() {
        return (ImageReference)this.getProperty(PROPERTY_BULLETS_IMAGE);
    }

    public Object[] getList() {
        ListModel model = this.getModel();
        Object[] arr = new Object[model.size()];
        for (int i = 0; i < model.size(); ++i) {
            arr[i] = model.get(i);
        }
        return arr;
    }

    public ListModel getModel() {
        return (ListModel)this.getProperty(PROPERTY_MODEL);
    }

    public int getOrdering() {
        return this.getProperty(PROPERTY_ORDERING, 1);
    }

    public void remove(Object object) {
        ListModel model = this.getModel();
        if (model instanceof DefaultListModel) {
            for (int i = 0; i < model.size(); ++i) {
                Object o = model.get(i);
                if (o != object) continue;
                ((DefaultListModel)model).remove(o);
                break;
            }
        }
    }

    @Override
    public void remove(Component c) {
        super.remove(c);
        if (this.getModel() instanceof DefaultListModel) {
            ((DefaultListModel)this.getModel()).remove(c);
        }
    }

    public void removeListDataListener(ListDataListener l) {
        this.getModel().removeListDataListener(l);
    }

    public void setBullets(int newBullets) {
        this.setProperty(PROPERTY_BULLETS, newBullets);
    }

    public void setBulletsImage(ImageReference newBulletsImage) {
        this.setProperty(PROPERTY_BULLETS_IMAGE, newBulletsImage);
    }

    public void setList(Object[] newList) {
        this.setProperty(PROPERTY_MODEL, new DefaultListModel(newList));
    }

    public void setList(List newList) {
        this.setProperty(PROPERTY_MODEL, new DefaultListModel(newList.toArray(new Object[newList.size()])));
    }

    public void setModel(ListModel newModel) {
        if (newModel == null) {
            throw new IllegalStateException("The ListSection must have a non null ListModel");
        }
        ListModel oldValue = this.getModel();
        if (oldValue != null) {
            oldValue.removeListDataListener(this.dataListener);
        }
        if (newModel != null) {
            newModel.addListDataListener(this.dataListener);
        }
        this.setProperty(PROPERTY_MODEL, newModel);
    }

    public void setOrdering(int newOrdering) {
        this.setProperty(PROPERTY_ORDERING, newOrdering);
    }

    private class ListDataHandler
    implements ListDataListener,
    Serializable {
        private ListDataHandler() {
        }

        @Override
        public void contentsChanged(ListDataEvent e) {
            ListSection.this.firePropertyChange("listDataChanged", null, null);
        }

        @Override
        public void intervalAdded(ListDataEvent e) {
            ListSection.this.firePropertyChange("listDataChanged", null, null);
        }

        @Override
        public void intervalRemoved(ListDataEvent e) {
            ListSection.this.firePropertyChange("listDataChanged", null, null);
        }
    }
}

