/*
 * Decompiled with CFR 0.152.
 */
package echopointng;

import echopointng.ComponentEx;
import echopointng.MenuItem;
import echopointng.MutableStyleEx;
import echopointng.util.ColorKit;
import nextapp.echo2.app.Alignment;
import nextapp.echo2.app.Border;
import nextapp.echo2.app.Color;
import nextapp.echo2.app.Component;
import nextapp.echo2.app.Extent;
import nextapp.echo2.app.FillImage;
import nextapp.echo2.app.ImageReference;
import nextapp.echo2.app.Insets;
import nextapp.echo2.app.ResourceImageReference;
import nextapp.echo2.app.Style;

public class Menu
extends MenuItem {
    public static final ImageReference DEFAULT_SUBMENU_IMAGE;
    public static final int OPEN_ON_MOUSEOVER = 0;
    public static final int OPEN_ON_CLICK = 1;
    public static final int OPEN_ON_SUBMENU_CLICK = 2;
    public static final String PROPERTY_BACKGROUND_IMAGE = "backgroundImage";
    public static final String PROPERTY_DRAW_OUTER_BORDERS = "drawOuterBorders";
    public static final String PROPERTY_HORIZONTAL = "horizontal";
    public static final String PROPERTY_KEEP_ALIVE = "keepAlive";
    public static final String PROPERTY_LEFT_OFFSET = "leftOffset";
    public static final String PROPERTY_MENU_ALWAYS_ON_TOP = "menuAlwaysOnTop";
    public static final String PROPERTY_MENU_BACKGROUND = "menuBackground";
    public static final String PROPERTY_MENU_BACKGROUND_IMAGE = "menuBackgroundImage";
    public static final String PROPERTY_MENU_BORDER = "menuBorder";
    public static final String PROPERTY_MENU_FOREGROUND = "menuForeground";
    public static final String PROPERTY_MENU_INSETS = "menuInsets";
    public static final String PROPERTY_MENU_OUTSETS = "menuOutsets";
    public static final String PROPERTY_OPEN_OPTION = "openOption";
    public static final String PROPERTY_PROPERTY_CHILDREN = "styleChildren";
    public static final String PROPERTY_STYLE_CHILDREN = "styleChildren";
    public static final String PROPERTY_SUBMENU_IMAGE = "submenuImage";
    public static final String PROPERTY_SUBMENU_IMAGE_ALIGNMENT = "submenuImageAlignment";
    public static final String PROPERTY_SUBMENU_IMAGE_BORDERED = "submenuImageBordered";
    public static final String PROPERTY_SUBMENU_ROLLOVER_IMAGE = "submenuRolloverImage";
    public static final String PROPERTY_TOP_OFFSET = "topOffset";
    public static final Style DEFAULT_STYLE;

    public Menu() {
        this((String)null, (ImageReference)null);
    }

    public Menu(MenuItem menuItem) {
        this((String)null, (ImageReference)null);
    }

    public Menu(ImageReference icon) {
        this((String)null, icon);
    }

    public Menu(String text) {
        this(text, null);
    }

    public Menu(String text, ImageReference icon) {
        super(text, icon);
    }

    @Override
    public void add(Component c) {
        if (c instanceof MenuItem) {
            this.addMenuItem((MenuItem)c);
        } else {
            super.add(c, -1);
        }
    }

    public void add(MenuItem menuItem) {
        this.addMenuItem(menuItem);
    }

    public MenuItem add(String text) {
        MenuItem menuItem = new MenuItem(text);
        return this.addMenuItem(menuItem);
    }

    private MenuItem addMenuItem(MenuItem menuItem) {
        if (this.isStyleChildren()) {
            this.styleMenuItem(menuItem);
        }
        super.add(menuItem, -1);
        return menuItem;
    }

    public int getLeftOffset() {
        return ComponentEx.getProperty((Component)this, PROPERTY_LEFT_OFFSET, 0);
    }

    public boolean getMenuAlwaysOnTop() {
        return ComponentEx.getProperty((Component)this, PROPERTY_MENU_ALWAYS_ON_TOP, false);
    }

    public Color getMenuBackground() {
        return (Color)ComponentEx.getProperty(this, PROPERTY_MENU_BACKGROUND);
    }

    public FillImage getMenuBackgroundImage() {
        return (FillImage)ComponentEx.getProperty(this, PROPERTY_MENU_BACKGROUND_IMAGE);
    }

    public Border getMenuBorder() {
        return (Border)this.getProperty(PROPERTY_MENU_BORDER);
    }

    public Color getMenuForeground() {
        return (Color)ComponentEx.getProperty(this, PROPERTY_MENU_FOREGROUND);
    }

    public Insets getMenuInsets() {
        return (Insets)ComponentEx.getProperty(this, PROPERTY_MENU_INSETS);
    }

    public MenuItem[] getMenuItems() {
        Component[] children = this.getComponents();
        int miCount = 0;
        for (int i = 0; i < children.length; ++i) {
            if (!(children[i] instanceof MenuItem)) continue;
            ++miCount;
        }
        MenuItem[] miChildren = new MenuItem[miCount];
        miCount = 0;
        for (int i = 0; i < children.length; ++i) {
            if (!(children[i] instanceof MenuItem)) continue;
            miChildren[miCount] = (MenuItem)children[i];
            ++miCount;
        }
        return miChildren;
    }

    public Insets getMenuOutsets() {
        return (Insets)ComponentEx.getProperty(this, PROPERTY_MENU_OUTSETS);
    }

    public int getOpenOption() {
        return ComponentEx.getProperty((Component)this, PROPERTY_OPEN_OPTION, 0);
    }

    public ImageReference getSubmenuImage() {
        return (ImageReference)ComponentEx.getProperty(this, PROPERTY_SUBMENU_IMAGE);
    }

    public int getSubmenuImageAlignment() {
        return ComponentEx.getProperty((Component)this, PROPERTY_SUBMENU_IMAGE_ALIGNMENT, 5);
    }

    public ImageReference getSubmenuRolloverImage() {
        return (ImageReference)ComponentEx.getProperty(this, PROPERTY_SUBMENU_ROLLOVER_IMAGE);
    }

    public int getTopOffset() {
        return ComponentEx.getProperty((Component)this, PROPERTY_TOP_OFFSET, 0);
    }

    public boolean isClickToOpen() {
        return this.getOpenOption() == 1 || this.getOpenOption() == 2;
    }

    public boolean isDrawOuterBorders() {
        return ComponentEx.getProperty((Component)this, PROPERTY_DRAW_OUTER_BORDERS, true);
    }

    public boolean isHorizontal() {
        return ComponentEx.getProperty((Component)this, PROPERTY_HORIZONTAL, false);
    }

    public boolean isKeepAlive() {
        return ComponentEx.getProperty((Component)this, PROPERTY_KEEP_ALIVE, false);
    }

    public boolean isStyleChildren() {
        return ComponentEx.getProperty((Component)this, "styleChildren", false);
    }

    public boolean isSubmenuImageBordered() {
        return ComponentEx.getProperty((Component)this, PROPERTY_SUBMENU_IMAGE_BORDERED, true);
    }

    public void setClickToOpen(boolean clickToOpen) {
        if (clickToOpen) {
            this.setOpenOption(1);
        } else {
            this.setOpenOption(0);
        }
    }

    public void setDrawOuterBorders(boolean newValue) {
        ComponentEx.setProperty((Component)this, PROPERTY_DRAW_OUTER_BORDERS, newValue);
    }

    public void setHorizontal(boolean newValue) {
        ComponentEx.setProperty((Component)this, PROPERTY_HORIZONTAL, newValue);
    }

    public void setKeepAlive(boolean newValue) {
        ComponentEx.setProperty((Component)this, PROPERTY_KEEP_ALIVE, newValue);
    }

    public void setLeftOffset(int newLeftOffset) {
        ComponentEx.setProperty((Component)this, PROPERTY_LEFT_OFFSET, newLeftOffset);
    }

    public void setMenuAlwaysOnTop(boolean newValue) {
        ComponentEx.setProperty((Component)this, PROPERTY_MENU_ALWAYS_ON_TOP, newValue);
    }

    public void setMenuBackground(Color menuBackground) {
        ComponentEx.setProperty((Component)this, PROPERTY_MENU_BACKGROUND, menuBackground);
    }

    public void setMenuBackgroundImage(FillImage newValue) {
        ComponentEx.setProperty((Component)this, PROPERTY_MENU_BACKGROUND_IMAGE, newValue);
    }

    public void setMenuBorder(Border newValue) {
        ComponentEx.setProperty((Component)this, PROPERTY_MENU_BORDER, newValue);
    }

    public void setMenuForeground(Color menuForeground) {
        ComponentEx.setProperty((Component)this, PROPERTY_MENU_FOREGROUND, menuForeground);
    }

    public void setMenuInsets(Insets menuInsets) {
        ComponentEx.setProperty((Component)this, PROPERTY_MENU_INSETS, menuInsets);
    }

    public void setMenuOutsets(Insets menuOutsets) {
        ComponentEx.setProperty((Component)this, PROPERTY_MENU_INSETS, menuOutsets);
    }

    public void setOpenOption(int newValue) {
        if (newValue != 1 && newValue != 0 && newValue != 2) {
            throw new IllegalArgumentException("The Menu's open option must be either OPEN_ON_CLICK, OPEN_ON_MOUSEOVER or OPEN_ON_SUBMENU_CLICK");
        }
        ComponentEx.setProperty((Component)this, PROPERTY_OPEN_OPTION, newValue);
    }

    public void setStyleChildren(boolean newValue) {
        ComponentEx.setProperty((Component)this, "styleChildren", newValue);
    }

    public void setSubmenuImage(ImageReference newImageRef) {
        ComponentEx.setProperty((Component)this, PROPERTY_SUBMENU_IMAGE, newImageRef);
    }

    public void setSubmenuImageAlignment(int newAlignment) {
        if (newAlignment != 3 && newAlignment != 5) {
            throw new IllegalArgumentException("SubmenuImageAlignment must be Alignment.LEFT or Alignment.RIGHT!");
        }
        ComponentEx.setProperty((Component)this, PROPERTY_SUBMENU_IMAGE_ALIGNMENT, newAlignment);
    }

    public void setSubmenuImageBordered(boolean newValue) {
        ComponentEx.setProperty((Component)this, PROPERTY_SUBMENU_IMAGE_BORDERED, newValue);
    }

    public void setSubmenuRolloverImage(ImageReference newValue) {
        ComponentEx.setProperty((Component)this, PROPERTY_SUBMENU_ROLLOVER_IMAGE, newValue);
    }

    public void setTopOffset(int newTopOffset) {
        ComponentEx.setProperty((Component)this, PROPERTY_TOP_OFFSET, newTopOffset);
    }

    public void styleAllMenuItems() {
        MenuItem[] items = this.getMenuItems();
        for (int i = 0; i < items.length; ++i) {
            MenuItem item = items[i];
            this.styleMenuItem(item);
            if (!(item instanceof Menu)) continue;
            ((Menu)item).styleAllMenuItems();
        }
    }

    public void styleMenuItem(MenuItem menuItem) {
        menuItem.setStyle(this.getStyle());
        this.copyProperty(menuItem, "font");
        this.copyProperty(menuItem, "foreground");
        this.copyProperty(menuItem, "background");
        this.copyProperty(menuItem, PROPERTY_BACKGROUND_IMAGE);
        this.copyProperty(menuItem, "border");
        this.copyProperty(menuItem, "insets");
        this.copyProperty(menuItem, "outsets");
        this.copyProperty(menuItem, "rolloverBackground");
        this.copyProperty(menuItem, "rolloverBackgroundImage");
        this.copyProperty(menuItem, "rolloverBorder");
        this.copyProperty(menuItem, "rolloverEnabled");
        this.copyProperty(menuItem, "rolloverFont");
        this.copyProperty(menuItem, "rolloverForeground");
        if (menuItem instanceof Menu) {
            Menu menu = (Menu)menuItem;
            this.copyProperty(menu, PROPERTY_MENU_BACKGROUND);
            this.copyProperty(menu, PROPERTY_MENU_BACKGROUND_IMAGE);
            this.copyProperty(menu, PROPERTY_MENU_BORDER);
            this.copyProperty(menu, PROPERTY_MENU_FOREGROUND);
            this.copyProperty(menu, PROPERTY_MENU_INSETS);
            this.copyProperty(menu, PROPERTY_MENU_OUTSETS);
            this.copyProperty(menu, PROPERTY_SUBMENU_IMAGE);
            this.copyProperty(menu, PROPERTY_SUBMENU_ROLLOVER_IMAGE);
            this.copyProperty(menu, PROPERTY_SUBMENU_IMAGE_BORDERED);
            this.copyProperty(menu, PROPERTY_SUBMENU_IMAGE_ALIGNMENT);
            this.copyProperty(menu, PROPERTY_MENU_ALWAYS_ON_TOP);
            this.copyProperty(menu, PROPERTY_OPEN_OPTION);
        }
    }

    private void copyProperty(MenuItem menuItem, String propertyName) {
        menuItem.setProperty(propertyName, this.getProperty(propertyName));
    }

    public void styleAllMenuItemsByName(String menuStyleName, String menuItemStyleName) {
        this.setStyleName(menuStyleName);
        MenuItem[] items = this.getMenuItems();
        for (int i = 0; i < items.length; ++i) {
            MenuItem item = items[i];
            if (item instanceof Menu) {
                item.setStyleName(menuStyleName);
                ((Menu)item).styleAllMenuItemsByName(menuStyleName, menuItemStyleName);
                continue;
            }
            item.setStyleName(menuItemStyleName);
        }
    }

    public void styleAllMenuItems(Style menuStyle, Style menuItemStyle) {
        this.setStyle(menuStyle);
        MenuItem[] items = this.getMenuItems();
        for (int i = 0; i < items.length; ++i) {
            MenuItem item = items[i];
            if (item instanceof Menu) {
                item.setStyle(menuStyle);
                ((Menu)item).styleAllMenuItems(menuStyle, menuItemStyle);
                continue;
            }
            item.setStyle(menuItemStyle);
        }
    }

    @Override
    public boolean isValidChild(Component component) {
        return true;
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer("Menu");
        if (this.getId() != null) {
            sb.append(" - ");
            sb.append(this.getId());
        }
        if (this.getText() != null) {
            sb.append(" : ");
            sb.append(this.getText());
        }
        return sb.toString();
    }

    static {
        String imagePath = "/echopointng/resource/images/";
        DEFAULT_SUBMENU_IMAGE = new ResourceImageReference(imagePath + "menu_submenuBlack.gif", new Extent(11), new Extent(11));
        MutableStyleEx style = new MutableStyleEx(MenuItem.DEFAULT_STYLE);
        style.setProperty(PROPERTY_MENU_ALWAYS_ON_TOP, false);
        style.setProperty(PROPERTY_MENU_BORDER, new Border(1, ColorKit.makeColor("#000000"), 1));
        style.setProperty(PROPERTY_MENU_BACKGROUND, ColorKit.makeColor("#FFFFFF"));
        style.setProperty(PROPERTY_SUBMENU_IMAGE, DEFAULT_SUBMENU_IMAGE);
        style.setProperty(PROPERTY_SUBMENU_IMAGE_ALIGNMENT, 5);
        style.setProperty(PROPERTY_SUBMENU_IMAGE_BORDERED, true);
        style.setProperty(PROPERTY_MENU_INSETS, new Insets(1));
        style.setProperty(PROPERTY_MENU_OUTSETS, new Insets(0));
        style.setProperty("textAlignment", new Alignment(4, 4));
        style.setProperty(PROPERTY_HORIZONTAL, false);
        style.setProperty("styleChildren", true);
        DEFAULT_STYLE = style;
    }
}

