/*
 * Decompiled with CFR 0.152.
 */
package echopointng;

import echopointng.ComponentEx;
import echopointng.ContentPaneEx;
import java.util.ArrayList;
import java.util.List;
import nextapp.echo2.app.Component;
import nextapp.echo2.app.IllegalChildException;

public class StackedPaneEx
extends ContentPaneEx {
    public static final String STACK_CHANGED_PROPERTY = "stack";
    public static final String PROPERTY_LAZY_RENDER_ENABLED = "lazyRenderEnabled";
    private List stack = new ArrayList();

    public StackedPaneEx() {
        this(new Component[0]);
    }

    public StackedPaneEx(Component c) {
        this(new Component[]{c});
    }

    public StackedPaneEx(Component[] components) {
        this.setFocusTraversalParticipant(false);
        if (components != null) {
            for (int i = 0; i < components.length; ++i) {
                this.push(components[i]);
            }
        }
    }

    protected void fireStackChanged() {
        this.firePropertyChange(STACK_CHANGED_PROPERTY, null, null);
    }

    public void push(Component c) {
        if (c == null) {
            throw new IllegalArgumentException("The Component c must not be null");
        }
        Component peek = this.peek();
        if (peek != c) {
            if (this.stack.contains(c)) {
                this.stack.remove(c);
            }
            this.stack.add(c);
            if (!this.isAncestorOf(c)) {
                super.add(c, -1);
            }
            this.fireStackChanged();
        }
    }

    public void push(Component[] components) {
        if (components != null) {
            for (int i = 0; i < components.length; ++i) {
                this.push(components[i]);
            }
        }
    }

    @Override
    public void add(Component c) {
        this.push(c);
    }

    public Component pop() {
        if (this.stack.size() == 0) {
            return null;
        }
        int oldSize = this.stack.size();
        Component popped = this.peek();
        this.stack.remove(popped);
        if (oldSize != this.stack.size()) {
            this.fireStackChanged();
        }
        return popped;
    }

    public Component popAndRemove() {
        Component popped = this.pop();
        super.remove(popped);
        return popped;
    }

    public Component[] popUntilTop(Component c) {
        ArrayList<Component> poppedList = new ArrayList<Component>();
        Component peekComponent = this.peek();
        while (peekComponent != null && peekComponent != c) {
            Component popped = this.pop();
            if (popped != null) {
                poppedList.add(popped);
            }
            peekComponent = this.peek();
        }
        return poppedList.toArray(new Component[poppedList.size()]);
    }

    public Component peek() {
        if (this.stack.size() == 0) {
            return null;
        }
        return (Component)this.stack.get(this.stack.size() - 1);
    }

    public Component peek(int index) {
        if (this.stack.size() == 0) {
            return null;
        }
        return (Component)this.stack.get(index);
    }

    public int size() {
        return this.stack.size();
    }

    public void insert(Component c, int index) {
        if (index >= this.stack.size()) {
            this.push(c);
        } else {
            this.stack.add(index, c);
            if (!this.isAncestorOf(c)) {
                super.add(c);
            }
            this.fireStackChanged();
        }
    }

    @Override
    public void add(Component c, int index) throws IllegalChildException {
        this.insert(c, index);
    }

    @Override
    public void remove(Component c) {
        super.remove(c);
        if (this.stack.contains(c)) {
            this.stack.remove(c);
            this.fireStackChanged();
        }
    }

    @Override
    public void remove(int index) {
        int oldSize = this.stack.size();
        Component c = (Component)this.stack.get(index);
        this.stack.remove(c);
        super.remove(c);
        if (oldSize != this.stack.size()) {
            this.fireStackChanged();
        }
    }

    @Override
    public void removeAll() {
        int oldSize = this.stack.size();
        this.stack.clear();
        super.removeAll();
        if (oldSize != this.stack.size()) {
            this.fireStackChanged();
        }
    }

    public void empty() {
        this.removeAll();
    }

    public boolean isLazyRenderEnabled() {
        return ComponentEx.getProperty((Component)this, PROPERTY_LAZY_RENDER_ENABLED, true);
    }

    public void setLazyRenderEnabled(boolean newValue) {
        ComponentEx.setProperty((Component)this, PROPERTY_LAZY_RENDER_ENABLED, newValue);
    }
}

