/*
 * Decompiled with CFR 0.152.
 */
package echopointng;

import echopointng.AbleComponent;
import echopointng.BorderEx;
import echopointng.MutableStyleEx;
import echopointng.able.ScrollBarProperties;
import echopointng.able.Scrollable;
import echopointng.able.Stretchable;
import echopointng.model.DefaultSingleSelectionModel;
import echopointng.model.SingleSelectionModel;
import echopointng.tabbedpane.DefaultTabModel;
import echopointng.tabbedpane.TabModel;
import echopointng.util.ComponentTracker;
import echopointng.util.reflect.ReflectionKit;
import java.io.Serializable;
import nextapp.echo2.app.Color;
import nextapp.echo2.app.Component;
import nextapp.echo2.app.Extent;
import nextapp.echo2.app.PaneContainer;
import nextapp.echo2.app.Style;
import nextapp.echo2.app.button.AbstractButton;
import nextapp.echo2.app.event.ActionEvent;
import nextapp.echo2.app.event.ActionListener;
import nextapp.echo2.app.event.ChangeEvent;
import nextapp.echo2.app.event.ChangeListener;

public class TabbedPane
extends AbleComponent
implements PaneContainer,
Stretchable,
Scrollable {
    public static final Style DEFAULT_STYLE;
    public static final String PROPERTY_MODEL = "model";
    public static final String PROPERTY_SELECTION_MODEL = "selectionModel";
    public static final String PROPERTY_TAB_BORDER_STYLE = "tabBorderStyle";
    public static final String PROPERTY_TAB_LEAD_IN_WIDTH = "tabLeadInWidth";
    public static final String PROPERTY_TAB_PLACEMENT = "tabPlacement";
    public static final String PROPERTY_TAB_SPACING = "tabSpacing";
    public static final int TAB_LINE_AND_CONTENT = 1;
    public static final int TAB_LINE_ONLY = 2;
    public static final int TAB_STRIP_AND_CONTENT = 3;
    public static final int TAB_STRIP_ONLY = 4;
    private ComponentTracker contentTracker = new ComponentTracker(this);
    private int currentlySelectedIndex = -1;
    private TabActionListener internalActionListener = new TabActionListener();
    private TabModelListener internalModelListener = new TabModelListener();
    private TabSelectionListener internalSelectionListener = new TabSelectionListener();
    private ComponentTracker tabsTracker = new ComponentTracker(this);

    public TabbedPane() {
        this(new DefaultTabModel());
    }

    public TabbedPane(TabModel tabModel) {
        this.setSelectionModel(new DefaultSingleSelectionModel());
        this.setModel(tabModel);
        if (tabModel.size() > 0) {
            this.getSelectionModel().setSelectedIndex(0);
        }
    }

    public TabModel getModel() {
        return (TabModel)this.getProperty(PROPERTY_MODEL);
    }

    public int getSelectedIndex() {
        return this.getSelectionModel().getSelectedIndex();
    }

    public SingleSelectionModel getSelectionModel() {
        return (SingleSelectionModel)this.getProperty(PROPERTY_SELECTION_MODEL);
    }

    public int getTabBorderStyle() {
        return this.getProperty(PROPERTY_TAB_BORDER_STYLE, 3);
    }

    public Extent getTabLeadInWidth() {
        return (Extent)this.getProperty(PROPERTY_TAB_LEAD_IN_WIDTH);
    }

    public int getTabPlacement() {
        return this.getProperty(PROPERTY_TAB_PLACEMENT, 6);
    }

    public int getTabSpacing() {
        return this.getProperty(PROPERTY_TAB_SPACING, 5);
    }

    @Override
    public void processInput(String inputName, Object inputValue) {
        super.processInput(inputName, inputValue);
        if ("click".equals(inputName)) {
            int selectedIndex = Integer.parseInt((String)inputValue);
            this.setSelectedIndex(selectedIndex);
            this.firePropertyChange(null, null, null);
        }
    }

    private void removeAllTabComponents() {
        Component[] children = this.tabsTracker.getComponents();
        for (int i = 0; i < children.length; ++i) {
            if (!(children[i] instanceof AbstractButton)) continue;
            ((AbstractButton)children[i]).removeActionListener(this.internalActionListener);
        }
        this.tabsTracker.removeAll();
    }

    private void removeAllTabContent() {
        this.contentTracker.removeAll();
    }

    public void setModel(TabModel model) {
        if (model == null) {
            throw new IllegalArgumentException("The TabbedPane model must not be null!");
        }
        TabModel oldValue = this.getModel();
        if (oldValue != model && oldValue != null) {
            oldValue.removeChangeListener(this.internalModelListener);
        }
        model.addChangeListener(this.internalModelListener);
        this.setProperty(PROPERTY_MODEL, model);
    }

    public void setSelectedIndex(int index) {
        this.getSelectionModel().setSelectedIndex(index);
    }

    public void setSelectionModel(SingleSelectionModel selectionModel) {
        if (selectionModel == null) {
            throw new IllegalArgumentException("The TabbedPane selectionModel must not be null!");
        }
        SingleSelectionModel oldValue = this.getSelectionModel();
        if (oldValue != selectionModel && oldValue != null) {
            oldValue.removeChangeListener(this.internalSelectionListener);
        }
        selectionModel.addChangeListener(this.internalSelectionListener);
        this.setProperty(PROPERTY_SELECTION_MODEL, selectionModel);
    }

    public void setTabBorderStyle(int newValue) {
        switch (newValue) {
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                break;
            }
            default: {
                throw new IllegalArgumentException("tabBorderStyle must one of TAB_LINE_AND_CONTENT, TAB_LINE_ONLY, TAB_STRIP_AND_CONTENT, TAB_STRIP_ONLY");
            }
        }
        this.setProperty(PROPERTY_TAB_BORDER_STYLE, newValue);
    }

    public void setTabLeadInWidth(Extent newValue) {
        this.setProperty(PROPERTY_TAB_LEAD_IN_WIDTH, newValue);
    }

    public void setTabPlacement(int tabPlacement) {
        switch (tabPlacement) {
            case 6: 
            case 7: {
                break;
            }
            default: {
                throw new IllegalArgumentException("The TabbedPane tabPlacement value is invalid : " + tabPlacement);
            }
        }
        this.setProperty(PROPERTY_TAB_PLACEMENT, tabPlacement);
    }

    public void setTabSpacing(int tabSpacing) {
        this.setProperty(PROPERTY_TAB_SPACING, tabSpacing);
    }

    public int size() {
        return this.getModel().size();
    }

    @Override
    public void validate() {
        super.validate();
        TabModel model = this.getModel();
        int selectedIndex = this.getSelectionModel().getSelectedIndex();
        int tabCount = model.size();
        for (int i = 0; i < tabCount; ++i) {
            Component tabComponent = model.getTabAt(this, i, i == selectedIndex);
            if (tabComponent == null) {
                throw new IllegalStateException("There must be a non null tab at index : " + i);
            }
            if (tabComponent != null && !this.isAncestorOf(tabComponent)) {
                this.tabsTracker.add(tabComponent);
            }
            ReflectionKit.invokeIfPresent("removeActionListener", new Class[]{ActionListener.class}, null, tabComponent, new Object[]{this.internalActionListener});
            ReflectionKit.invokeIfPresent("addActionListener", new Class[]{ActionListener.class}, null, tabComponent, new Object[]{this.internalActionListener});
            if (!(tabComponent instanceof AbstractButton)) continue;
            AbstractButton btn = (AbstractButton)tabComponent;
            btn.removeActionListener(this.internalActionListener);
            btn.addActionListener(this.internalActionListener);
        }
    }

    @Override
    public Extent getMaximumStretchedHeight() {
        return (Extent)this.getProperty("maximumStretchedHeight");
    }

    @Override
    public Extent getMinimumStretchedHeight() {
        return (Extent)this.getProperty("minimumStretchedHeight");
    }

    @Override
    public boolean isHeightStretched() {
        return this.getProperty("heightStretched", false);
    }

    @Override
    public void setHeightStretched(boolean newValue) {
        this.setProperty("heightStretched", newValue);
    }

    @Override
    public void setMaximumStretchedHeight(Extent newValue) {
        Extent.validate(newValue, 1);
        this.setProperty("maximumStretchedHeight", newValue);
    }

    @Override
    public void setMinimumStretchedHeight(Extent newValue) {
        Extent.validate(newValue, 1);
        this.setProperty("minimumStretchedHeight", newValue);
    }

    @Override
    public Color getScrollBarBaseColor() {
        return (Color)this.getProperty("scrollBarBaseColor");
    }

    @Override
    public int getScrollBarPolicy() {
        return this.getProperty("scrollBarPolicy", 4);
    }

    @Override
    public ScrollBarProperties getScrollBarProperties() {
        return (ScrollBarProperties)this.getProperty("scrollBarProperties");
    }

    @Override
    public void setScrollBarBaseColor(Color newValue) {
        this.setProperty("scrollBarBaseColor", newValue);
    }

    @Override
    public void setScrollBarPolicy(int newScrollBarPolicy) {
        this.setProperty("scrollBarPolicy", newScrollBarPolicy);
    }

    @Override
    public void setScrollBarProperties(ScrollBarProperties newValue) {
        this.setProperty("scrollBarProperties", newValue);
    }

    static {
        MutableStyleEx style = new MutableStyleEx();
        style.setProperty(PROPERTY_TAB_PLACEMENT, 6);
        style.setProperty(PROPERTY_TAB_SPACING, 5);
        style.setProperty("border", new BorderEx(1));
        style.setProperty(PROPERTY_TAB_BORDER_STYLE, 3);
        DEFAULT_STYLE = style;
    }

    private class TabSelectionListener
    implements ChangeListener,
    Serializable {
        private TabSelectionListener() {
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            Component newContent;
            SingleSelectionModel srcSelectionModel = (SingleSelectionModel)e.getSource();
            TabModel model = TabbedPane.this.getModel();
            int newSelectedIndex = srcSelectionModel.getSelectedIndex();
            TabbedPane.this.removeAllTabContent();
            if (TabbedPane.this.currentlySelectedIndex >= 0) {
                model.releaseTabAt(TabbedPane.this.currentlySelectedIndex);
            }
            if (newSelectedIndex >= 0 && (newContent = model.getTabContentAt(newSelectedIndex)) != null) {
                TabbedPane.this.contentTracker.add(newContent);
            }
            TabbedPane.this.currentlySelectedIndex = newSelectedIndex;
            TabbedPane.this.firePropertyChange(null, null, null);
        }
    }

    private class TabModelListener
    implements ChangeListener,
    Serializable {
        private TabModelListener() {
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            TabModel model = TabbedPane.this.getModel();
            SingleSelectionModel selectionModel = TabbedPane.this.getSelectionModel();
            int selectedIndex = TabbedPane.this.getSelectionModel().getSelectedIndex();
            TabbedPane.this.removeAllTabContent();
            TabbedPane.this.removeAllTabComponents();
            int newTabCount = model.size();
            if (newTabCount <= 0) {
                selectionModel.setSelectedIndex(-1);
            } else {
                if (selectedIndex >= newTabCount) {
                    selectedIndex = newTabCount - 1;
                } else if (selectedIndex < 0) {
                    selectedIndex = 0;
                }
                selectionModel.setSelectedIndex(selectedIndex);
                Component tabContent = model.getTabContentAt(selectedIndex);
                if (!TabbedPane.this.isAncestorOf(tabContent)) {
                    TabbedPane.this.contentTracker.add(tabContent);
                }
                TabbedPane.this.firePropertyChange(null, null, null);
            }
        }
    }

    private class TabActionListener
    implements ActionListener,
    Serializable {
        private TabActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (e.getSource() instanceof Component) {
                Component tabComponent = (Component)e.getSource();
                int index = TabbedPane.this.getModel().indexOfTab(tabComponent);
                if (index != -1) {
                    TabbedPane.this.getSelectionModel().setSelectedIndex(index);
                }
                TabbedPane.this.firePropertyChange(null, null, null);
            }
        }
    }
}

