/*
 * Decompiled with CFR 0.152.
 */
package echopointng.image;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import nextapp.echo2.app.ApplicationInstance;
import nextapp.echo2.app.Extent;
import nextapp.echo2.app.StreamImageReference;

public class URLImageReference
extends StreamImageReference {
    private static final Map extContentType = new HashMap();
    private URL resourceURL;
    private String contentType;
    private Extent width;
    private Extent height;
    private String id = ApplicationInstance.generateSystemId();
    private static final int BUFFER_SIZE = 4096;

    private static String determineContentType(URL imageURL) {
        String resourceName = imageURL.toExternalForm();
        int extensionDelimiterPosition = resourceName.lastIndexOf(".");
        if (extensionDelimiterPosition == -1) {
            throw new IllegalArgumentException("Invalid content type (URL resource has no extension: " + resourceName + ")");
        }
        String extension = resourceName.substring(extensionDelimiterPosition + 1).toLowerCase();
        String contentType = (String)extContentType.get(extension);
        if (contentType == null) {
            throw new IllegalArgumentException("Invalid content type (no matching content type: " + resourceName + ")");
        }
        return contentType;
    }

    public URLImageReference(URL imageURL) {
        this(imageURL, URLImageReference.determineContentType(imageURL), null, null);
    }

    public URLImageReference(URL imageURL, String contentType) {
        this(imageURL, contentType, null, null);
    }

    public URLImageReference(URL imageURL, Extent width, Extent height) {
        this(imageURL, URLImageReference.determineContentType(imageURL), width, height);
    }

    public URLImageReference(URL imageURL, String contentType, Extent width, Extent height) {
        this.resourceURL = imageURL;
        this.contentType = contentType;
        this.width = width;
        this.height = height;
    }

    @Override
    public String getRenderId() {
        return this.id;
    }

    @Override
    public String getContentType() {
        return this.contentType;
    }

    @Override
    public Extent getHeight() {
        return this.height;
    }

    @Override
    public Extent getWidth() {
        return this.width;
    }

    public void update() {
    }

    @Override
    public void render(OutputStream out) throws IOException {
        InputStream in = null;
        byte[] buffer = new byte[4096];
        int bytesRead = 0;
        in = this.resourceURL.openStream();
        do {
            if ((bytesRead = in.read(buffer)) <= 0) continue;
            out.write(buffer, 0, bytesRead);
        } while (bytesRead > 0);
        try {
            in.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    static {
        extContentType.put("gif", "image/gif");
        extContentType.put("png", "image/png");
        extContentType.put("jpeg", "image/jpeg");
        extContentType.put("jpg", "image/jpg");
        extContentType.put("bmp", "image/bmp");
        extContentType.put("cod", "image/cis-cod");
        extContentType.put("cpi", "image/cpi");
        extContentType.put("fif", "image/fif");
        extContentType.put("ief", "image/ief");
        extContentType.put("rip", "image/rip");
        extContentType.put("tif", "image/tiff");
        extContentType.put("tiff", "image/tiff");
        extContentType.put("svh", "image/svh");
        extContentType.put("mcf", "image/vasa");
        extContentType.put("svf", "image/vnd");
        extContentType.put("dwg", "image/vnd");
        extContentType.put("dxf", "image/vnd");
        extContentType.put("wbmp", "image/vnd.wap.wbmp");
        extContentType.put("xif", "image/vnd.xiff");
        extContentType.put("wi", "image/wavelet");
        extContentType.put("clp", "image/x-clp");
        extContentType.put("ras", "image/x-cmu-raster");
        extContentType.put("cmx", "image/x-cmx");
        extContentType.put("emf", "image/x-emf");
        extContentType.put("etf", "image/x-etf");
        extContentType.put("fpx", "image/x-fpx");
        extContentType.put("fh5", "image/x-freehand");
        extContentType.put("fh4", "image/x-freehand");
        extContentType.put("fhc", "image/x-freehand");
        extContentType.put("cut", "image/x-halo-cut");
        extContentType.put("jps", "image/x-jps");
        extContentType.put("dsf", "image/x-mgx-dsf");
        extContentType.put("pnm", "image/x-portable-anymap");
        extContentType.put("pbm", "image/x-portable-bitmap");
        extContentType.put("pgm", "image/x-portable-graymap");
        extContentType.put("ppm", "image/x-portable-pixmap");
        extContentType.put("qti", "image/x-quicktime");
        extContentType.put("rgb", "image/x-rgb");
        extContentType.put("wmf", "image/x-wmf");
        extContentType.put("xbm", "image/x-xbitmap");
        extContentType.put("xpm", "image/x-xpixmap");
        extContentType.put("xwd", "image/x-xwindowdump");
    }
}

