/*
 * Decompiled with CFR 0.152.
 */
package echopointng.layout;

import echopointng.able.Alignable;
import echopointng.able.BackgroundImageable;
import echopointng.able.Borderable;
import echopointng.able.Floatable;
import echopointng.able.Insetable;
import echopointng.able.MouseCursorable;
import echopointng.able.Positionable;
import echopointng.able.Sizeable;
import java.io.Serializable;
import nextapp.echo2.app.Alignment;
import nextapp.echo2.app.Border;
import nextapp.echo2.app.Color;
import nextapp.echo2.app.Extent;
import nextapp.echo2.app.FillImage;
import nextapp.echo2.app.Font;
import nextapp.echo2.app.Insets;
import nextapp.echo2.app.LayoutData;
import nextapp.echo2.app.MutableStyle;

public class DisplayLayoutData
implements LayoutData,
Serializable,
Positionable,
Sizeable,
MouseCursorable,
Insetable,
Borderable,
Alignable,
BackgroundImageable,
Floatable {
    public static final String PROPERTY_TOOL_TIP_TEXT = "toolTipText";
    public static final String PROPERTY_INLINE_LAYOUT = "inlineLayout";
    private MutableStyle localStyle = new MutableStyle();

    public DisplayLayoutData() {
    }

    public DisplayLayoutData(Extent left, Extent top) {
        this.setPosition(2);
        this.setLeft(left);
        this.setTop(top);
    }

    @Override
    public void clear() {
        this.setZIndex(Integer.MIN_VALUE);
        this.setPosition(1);
        this.setLeft(null);
        this.setRight(null);
        this.setTop(null);
        this.setBottom(null);
    }

    public Color getBackground() {
        return (Color)this.localStyle.getProperty("background");
    }

    @Override
    public Border getBorder() {
        return (Border)this.getProperty("border");
    }

    @Override
    public Extent getBottom() {
        return (Extent)this.getProperty("bottom");
    }

    @Override
    public int getClearFloat() {
        return this.getProperty("clearfloat", 10);
    }

    @Override
    public int getFloat() {
        return this.getProperty("float", 0);
    }

    public Font getFont() {
        return (Font)this.localStyle.getProperty("font");
    }

    public Color getForeground() {
        return (Color)this.localStyle.getProperty("foreground");
    }

    @Override
    public Extent getHeight() {
        return (Extent)this.getProperty("height");
    }

    @Override
    public Insets getInsets() {
        return (Insets)this.getProperty("insets");
    }

    @Override
    public Extent getLeft() {
        return (Extent)this.getProperty("left");
    }

    @Override
    public int getMouseCursor() {
        return this.getProperty("mouseCursor", 0);
    }

    @Override
    public String getMouseCursorUri() {
        return (String)this.getProperty("mouseCursorUri");
    }

    @Override
    public Insets getOutsets() {
        return (Insets)this.getProperty("outsets");
    }

    @Override
    public int getPosition() {
        return this.getProperty("position", 1);
    }

    protected Object getProperty(String propertyName) {
        return this.localStyle.getProperty(propertyName);
    }

    protected boolean getProperty(String propertyName, boolean defaultValue) {
        Boolean obj = (Boolean)this.getProperty(propertyName);
        return obj == null ? defaultValue : obj;
    }

    protected int getProperty(String propertyName, int defaultValue) {
        Integer obj = (Integer)this.getProperty(propertyName);
        return obj == null ? defaultValue : obj;
    }

    @Override
    public Object getRenderProperty(String propertyName) {
        return this.getProperty(propertyName);
    }

    @Override
    public Object getRenderProperty(String propertyName, Object defaultValue) {
        Object obj = this.getProperty(propertyName);
        return obj == null ? defaultValue : obj;
    }

    @Override
    public Extent getRight() {
        return (Extent)this.getProperty("right");
    }

    @Override
    public Extent getTop() {
        return (Extent)this.getProperty("top");
    }

    @Override
    public Extent getWidth() {
        return (Extent)this.getProperty("width");
    }

    @Override
    public int getZIndex() {
        return this.getProperty("zIndex", Integer.MIN_VALUE);
    }

    @Override
    public boolean isPositioned() {
        return this.getPosition() != 1;
    }

    public void setBackground(Color newValue) {
        this.setProperty("background", newValue);
    }

    @Override
    public void setBorder(Border newValue) {
        this.setProperty("border", newValue);
    }

    @Override
    public void setBottom(Extent newValue) {
        this.setProperty("bottom", newValue);
    }

    @Override
    public void setClearFloat(int newValue) {
        switch (newValue) {
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                this.setProperty("clearfloat", newValue);
                break;
            }
            default: {
                throw new IllegalArgumentException("Illegal float clearing value");
            }
        }
    }

    @Override
    public void setFloat(int newValue) {
        switch (newValue) {
            case 0: 
            case 1: 
            case 2: {
                this.setProperty("float", newValue);
                break;
            }
            default: {
                throw new IllegalArgumentException("Illegal float value");
            }
        }
    }

    public void setFont(Font newValue) {
        this.setProperty("font", newValue);
    }

    public void setForeground(Color newValue) {
        this.setProperty("foreground", newValue);
    }

    @Override
    public void setHeight(Extent newValue) {
        this.setProperty("height", newValue);
    }

    @Override
    public void setInsets(Insets newValue) {
        this.setProperty("insets", newValue);
    }

    @Override
    public void setLeft(Extent newValue) {
        this.setProperty("left", newValue);
    }

    @Override
    public void setMouseCursor(int mouseCursor) {
        this.setProperty("mouseCursor", mouseCursor);
    }

    @Override
    public void setMouseCursorUri(String mouseCursorURI) {
        this.setProperty("mouseCursorUri", mouseCursorURI);
    }

    @Override
    public void setOutsets(Insets newValue) {
        this.setProperty("outsets", newValue);
    }

    @Override
    public void setPosition(int newPositioning) {
        this.setProperty("position", newPositioning);
    }

    protected void setProperty(String propertyName, boolean newValue) {
        this.setProperty(propertyName, (Object)newValue);
    }

    protected void setProperty(String propertyName, int newValue) {
        this.setProperty(propertyName, new Integer(newValue));
    }

    protected void setProperty(String propertyName, Object newValue) {
        this.localStyle.setProperty(propertyName, newValue);
    }

    @Override
    public void setRight(Extent newValue) {
        this.setProperty("right", newValue);
    }

    @Override
    public void setTop(Extent newValue) {
        this.setProperty("top", newValue);
    }

    @Override
    public void setWidth(Extent newValue) {
        this.setProperty("width", newValue);
    }

    @Override
    public void setZIndex(int newValue) {
        this.setProperty("zIndex", newValue);
    }

    @Override
    public Alignment getAlignment() {
        return (Alignment)this.getProperty("alignment");
    }

    @Override
    public FillImage getBackgroundImage() {
        return (FillImage)this.getProperty("backgroundImage");
    }

    @Override
    public void setAlignment(Alignment newValue) {
        this.setProperty("alignment", newValue);
    }

    @Override
    public void setBackgroundImage(FillImage newValue) {
        this.setProperty("backgroundImage", newValue);
    }

    public String getToolTipText() {
        return (String)this.getProperty(PROPERTY_TOOL_TIP_TEXT);
    }

    public void setToolTipText(String newValue) {
        this.setProperty(PROPERTY_TOOL_TIP_TEXT, newValue);
    }

    public boolean isInlineLayout() {
        return this.getProperty(PROPERTY_INLINE_LAYOUT, false);
    }

    public void setInlineLayout(boolean newValue) {
        this.setProperty(PROPERTY_INLINE_LAYOUT, newValue);
    }
}

