/*
 * Decompiled with CFR 0.152.
 */
package echopointng.model;

import echopointng.DateChooser;
import echopointng.model.CalendarEvent;
import echopointng.model.CalendarSelectionListener;
import echopointng.model.CalendarSelectionModel;
import java.io.Serializable;
import java.util.Calendar;
import java.util.EventListener;
import nextapp.echo2.app.event.EventListenerList;

public class DefaultCalendarSelectionModel
implements CalendarSelectionModel,
Serializable {
    private Calendar displayedDate;
    protected EventListenerList listenerList = new EventListenerList();
    private Calendar selectedDate;

    private Calendar copyCal(Calendar cal) {
        return DateChooser.calendarCopy(cal);
    }

    public DefaultCalendarSelectionModel(Calendar cal) {
        this.selectedDate = this.copyCal(cal);
        this.displayedDate = this.copyCal(cal);
        this.displayedDate.set(5, 1);
    }

    @Override
    public void addListener(CalendarSelectionListener l) {
        this.listenerList.addListener(CalendarSelectionListener.class, l);
    }

    private void fireSelectedChanged() {
        EventListener[] listeners = this.listenerList.getListeners(CalendarSelectionListener.class);
        CalendarEvent calEvent = new CalendarEvent(this, this.selectedDate);
        for (int index = 0; index < listeners.length; ++index) {
            ((CalendarSelectionListener)listeners[index]).selectedDateChange(calEvent);
        }
    }

    private void fireDisplayedChanged() {
        EventListener[] listeners = this.listenerList.getListeners(CalendarSelectionListener.class);
        CalendarEvent calEvent = new CalendarEvent(this, this.displayedDate);
        for (int index = 0; index < listeners.length; ++index) {
            ((CalendarSelectionListener)listeners[index]).displayedDateChange(calEvent);
        }
    }

    @Override
    public Calendar getDisplayedDate() {
        return this.displayedDate;
    }

    @Override
    public Calendar getSelectedDate() {
        return this.selectedDate;
    }

    @Override
    public void removeListener(CalendarSelectionListener l) {
        this.listenerList.removeListener(CalendarSelectionListener.class, l);
    }

    @Override
    public void setDisplayedDate(Calendar cal) {
        if (!this.displayedDate.equals(cal)) {
            this.displayedDate = this.copyCal(cal);
            this.fireDisplayedChanged();
        }
    }

    @Override
    public void setSelectedDate(Calendar cal) {
        if (cal != null && this.selectedDate == null || cal == null && this.selectedDate != null || this.selectedDate != null && !this.selectedDate.equals(cal)) {
            this.selectedDate = this.copyCal(cal);
            this.fireSelectedChanged();
        }
    }

    @Override
    public void setDates(Calendar newSelectedDate, Calendar newDisplayedDate) {
        boolean selectedSet = false;
        boolean displayedSet = false;
        if (newSelectedDate != null && this.selectedDate == null || !this.selectedDate.equals(newSelectedDate)) {
            this.selectedDate = this.copyCal(newSelectedDate);
            selectedSet = true;
        }
        if (newDisplayedDate != null && this.displayedDate == null || !this.displayedDate.equals(newDisplayedDate)) {
            this.displayedDate = this.copyCal(newDisplayedDate);
            displayedSet = true;
        }
        if (selectedSet) {
            this.fireSelectedChanged();
        }
        if (displayedSet) {
            this.fireDisplayedChanged();
        }
    }
}

