/*
 * Decompiled with CFR 0.152.
 */
package echopointng.richtext;

import echopointng.RichTextArea;
import echopointng.richtext.RichTextRenderer;
import echopointng.util.ColorKit;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import nextapp.echo2.app.Border;
import nextapp.echo2.app.Color;
import nextapp.echo2.app.ImageReference;
import nextapp.echo2.app.ResourceImageReference;

public class DefaultRichTextRenderer
implements RichTextRenderer,
Serializable {
    public static String[][] DEFAULT_SUPPORTED_COMMANDS = new String[][]{{"hintNewLine", null}, {"bold", "Bold (Ctrl+B)"}, {"italic", "Italic (Ctrl+I)"}, {"underline", "Underline (Ctrl+U)"}, {"subscript", "Subscript (Ctrl+-)"}, {"superscript", "Superscript (Ctrl+=)"}, {"hintSpacer", null}, {"forecolor", "Foreground Color"}, {"hilitecolor", "Background Color"}, {"hintSpacer", null}, {"copy", "Copy (Ctrl+C)"}, {"cut", "Cut (Ctrl+X)"}, {"paste", "Paste (Ctrl+V)"}, {"undo", "Undo (Ctrl+Z)"}, {"redo", "Redo (Ctrl+Y)"}, {"hintSpacer", null}, {"justifyleft", "Align Left (Ctrl+L)"}, {"justifycenter", "Center (Ctrl+E)"}, {"justifyright", "Align Right (Ctrl+R)"}, {"justifyfull", "Justify (Ctrl+J)"}, {"indent", "Increase Indent"}, {"outdent", "Decrease Indent"}, {"hintSpacer", null}, {"insertorderedlist", "Numbers"}, {"insertunorderedlist", "Bullets"}, {"hintSpacer", null}, {"spellcheck", "Spell Check"}, {"selectall", "Select All (Ctrl+A)"}, {"removeformat", "Remove All Format"}, {"hintSpacer", null}, {"inserthorizontalrule", "Insert Horizontal Ruler"}, {"createlink", "Create Hyperlink (Ctrl+K)"}, {"insertimage", "Insert Image"}};
    private static final String path = "/echopointng/resource/images/richtext/";
    public static Object[][] DEFAULT_COMMAND_IMAGES = new Object[][]{{"bold", new ResourceImageReference("/echopointng/resource/images/richtext/ep_rt_bold.gif")}, {"copy", new ResourceImageReference("/echopointng/resource/images/richtext/ep_rt_copy.gif")}, {"createlink", new ResourceImageReference("/echopointng/resource/images/richtext/ep_rt_createlink.gif")}, {"cut", new ResourceImageReference("/echopointng/resource/images/richtext/ep_rt_cut.gif")}, {"forecolor", new ResourceImageReference("/echopointng/resource/images/richtext/ep_rt_forecolor.gif")}, {"hilitecolor", new ResourceImageReference("/echopointng/resource/images/richtext/ep_rt_hilitecolor.gif")}, {"indent", new ResourceImageReference("/echopointng/resource/images/richtext/ep_rt_indent.gif")}, {"inserthorizontalrule", new ResourceImageReference("/echopointng/resource/images/richtext/ep_rt_inserthorizontalrule.gif")}, {"insertimage", new ResourceImageReference("/echopointng/resource/images/richtext/ep_rt_insertimage.gif")}, {"insertorderedlist", new ResourceImageReference("/echopointng/resource/images/richtext/ep_rt_insertorderedlist.gif")}, {"insertunorderedlist", new ResourceImageReference("/echopointng/resource/images/richtext/ep_rt_insertunorderedlist.gif")}, {"italic", new ResourceImageReference("/echopointng/resource/images/richtext/ep_rt_italic.gif")}, {"justifycenter", new ResourceImageReference("/echopointng/resource/images/richtext/ep_rt_justifycenter.gif")}, {"justifyfull", new ResourceImageReference("/echopointng/resource/images/richtext/ep_rt_justifyfull.gif")}, {"justifyleft", new ResourceImageReference("/echopointng/resource/images/richtext/ep_rt_justifyleft.gif")}, {"justifyright", new ResourceImageReference("/echopointng/resource/images/richtext/ep_rt_justifyright.gif")}, {"outdent", new ResourceImageReference("/echopointng/resource/images/richtext/ep_rt_outdent.gif")}, {"paste", new ResourceImageReference("/echopointng/resource/images/richtext/ep_rt_paste.gif")}, {"redo", new ResourceImageReference("/echopointng/resource/images/richtext/ep_rt_redo.gif")}, {"removeformat", new ResourceImageReference("/echopointng/resource/images/richtext/ep_rt_removeformat.gif")}, {"selectall", new ResourceImageReference("/echopointng/resource/images/richtext/ep_rt_selectall.gif")}, {"spellcheck", new ResourceImageReference("/echopointng/resource/images/richtext/ep_rt_spell.gif")}, {"subscript", new ResourceImageReference("/echopointng/resource/images/richtext/ep_rt_subscript.gif")}, {"superscript", new ResourceImageReference("/echopointng/resource/images/richtext/ep_rt_superscript.gif")}, {"underline", new ResourceImageReference("/echopointng/resource/images/richtext/ep_rt_underline.gif")}, {"undo", new ResourceImageReference("/echopointng/resource/images/richtext/ep_rt_undo.gif")}};
    public static final String[][] SIMPLE_FONT_NAMES = new String[][]{{"arial,helvetica,sans-serif", "Arial"}, {"courier,monospace", "Courier"}, {"courier new,courier,monospace", "Courier New"}, {"helvetica,sans-serif", "Helvetica"}, {"times,serif", "Times"}, {"times new roman,times,serif", "Times New Roman"}, {"verdana,arial,helvetica,sans-serif", "Verdana"}};
    public static final String[][] EXTENDED_FONT_NAMES = new String[][]{{"arial,helvetica,sans-serif", "Arial"}, {"courier,monospace", "Courier"}, {"courier new,courier,monospace", "Courier New"}, {"helvetica,sans-serif", "Helvetica"}, {"times,serif", "Times"}, {"times new roman,times,serif", "Times New Roman"}, {"verdana,arial,helvetica,sans-serif", "Verdana"}, {"bookman old style", "Bookman Old Style"}, {"tahoma", "Tahoma"}, {"garamond", "Garamond"}, {"georgia", "Georgia"}, {"haettenschweiler", "Haettenschweiler"}, {"lucida console", "Lucinda Console"}, {"impact", "Impact"}, {"century gothic", "Century Gothic"}, {"book antiqua", "Book Antiqua"}, {"comic sans ms", "Comic Sans MS"}, {"webdings", "Webdings"}, {"wingdings", "Wingdings"}};
    public static final String[][] DEFAULT_FONT_NAMES = EXTENDED_FONT_NAMES;
    public static final String[][] DEFAULT_FONT_SIZES = new String[][]{{"1", "1 (8 pt)"}, {"2", "2 (10 pt)"}, {"3", "3 (12 pt)"}, {"4", "4 (14 pt)"}, {"5", "5 (18 pt)"}, {"6", "6 (24 pt)"}, {"7", "7 (36 pt)"}};
    public static final String[][] DEFAULT_PARAGRAPH_STYLES = new String[][]{{"p", "Normal"}, {"h1", "Heading 1"}, {"h2", "Heading 2"}, {"h3", "Heading 3"}, {"h4", "Heading 4"}, {"h5", "Heading 5"}, {"h6", "Heading 6"}, {"pre", "Preformatted"}, {"address", "Address"}};
    public static final Color[] DEFAULT_COLOR_CHOICES = new Color[]{ColorKit.makeColor("#FFFFFF"), ColorKit.makeColor("#FFCCCC"), ColorKit.makeColor("#FFCC99"), ColorKit.makeColor("#FFFF99"), ColorKit.makeColor("#FFFFCC"), ColorKit.makeColor("#99FF99"), ColorKit.makeColor("#99FFFF"), ColorKit.makeColor("#CCFFFF"), ColorKit.makeColor("#CCCCFF"), ColorKit.makeColor("#FFCCFF"), ColorKit.makeColor("#CCCCCC"), ColorKit.makeColor("#FF6666"), ColorKit.makeColor("#FF9966"), ColorKit.makeColor("#FFFF66"), ColorKit.makeColor("#FFFF33"), ColorKit.makeColor("#66FF99"), ColorKit.makeColor("#33FFFF"), ColorKit.makeColor("#66FFFF"), ColorKit.makeColor("#9999FF"), ColorKit.makeColor("#FF99FF"), ColorKit.makeColor("#C0C0C0"), ColorKit.makeColor("#FF0000"), ColorKit.makeColor("#FF9900"), ColorKit.makeColor("#FFCC66"), ColorKit.makeColor("#FFFF00"), ColorKit.makeColor("#33FF33"), ColorKit.makeColor("#66CCCC"), ColorKit.makeColor("#33CCFF"), ColorKit.makeColor("#6666CC"), ColorKit.makeColor("#CC66CC"), ColorKit.makeColor("#999999"), ColorKit.makeColor("#CC0000"), ColorKit.makeColor("#FF6600"), ColorKit.makeColor("#FFCC33"), ColorKit.makeColor("#FFCC00"), ColorKit.makeColor("#33CC00"), ColorKit.makeColor("#00CCCC"), ColorKit.makeColor("#3366FF"), ColorKit.makeColor("#6633FF"), ColorKit.makeColor("#CC33CC"), ColorKit.makeColor("#666666"), ColorKit.makeColor("#990000"), ColorKit.makeColor("#CC6600"), ColorKit.makeColor("#CC9933"), ColorKit.makeColor("#999900"), ColorKit.makeColor("#009900"), ColorKit.makeColor("#339999"), ColorKit.makeColor("#3333FF"), ColorKit.makeColor("#6600CC"), ColorKit.makeColor("#993399"), ColorKit.makeColor("#333333"), ColorKit.makeColor("#660000"), ColorKit.makeColor("#993300"), ColorKit.makeColor("#996633"), ColorKit.makeColor("#666600"), ColorKit.makeColor("#006600"), ColorKit.makeColor("#336666"), ColorKit.makeColor("#000099"), ColorKit.makeColor("#333399"), ColorKit.makeColor("#663366"), ColorKit.makeColor("#000000"), ColorKit.makeColor("#330000"), ColorKit.makeColor("#663300"), ColorKit.makeColor("#663333"), ColorKit.makeColor("#333300"), ColorKit.makeColor("#003300"), ColorKit.makeColor("#003333"), ColorKit.makeColor("#000066"), ColorKit.makeColor("#330099"), ColorKit.makeColor("#330033")};
    private String[][] fontNames = DEFAULT_FONT_NAMES;
    private String[][] fontSizes = DEFAULT_FONT_SIZES;
    private String[][] paragraphStyles = DEFAULT_PARAGRAPH_STYLES;
    private Map commandImages = new HashMap();

    public DefaultRichTextRenderer() {
        for (int i = 0; i < DEFAULT_COMMAND_IMAGES.length; ++i) {
            this.commandImages.put(DEFAULT_COMMAND_IMAGES[i][0], DEFAULT_COMMAND_IMAGES[i][1]);
        }
    }

    private String[][] copyCommandsExcept(String[][] allCommands, String[] exceptCmds) {
        int len = allCommands.length - exceptCmds.length;
        String[][] commands = new String[len][2];
        int j = 0;
        for (int i = 0; i < allCommands.length; ++i) {
            String cmd = allCommands[i][0];
            boolean doCopy = true;
            for (int k = 0; k < exceptCmds.length; ++k) {
                if (!cmd.equals(exceptCmds[k])) continue;
                doCopy = false;
                break;
            }
            if (!doCopy) continue;
            commands[j][0] = allCommands[i][0];
            commands[j][1] = allCommands[i][1];
            ++j;
        }
        return commands;
    }

    @Override
    public String[][] getFontNames(RichTextArea rta, String userAgent) {
        List list = Arrays.asList(this.fontNames);
        Collections.sort(list, new StringArrayComparator(1));
        return (String[][])list.toArray();
    }

    @Override
    public String[][] getFontSizes(RichTextArea rta, String userAgent) {
        return this.fontSizes;
    }

    @Override
    public String[][] getParagraphStyles(RichTextArea rta, String userAgent) {
        return this.paragraphStyles;
    }

    @Override
    public String[][] getSupportedCommands(RichTextArea rta, String userAgent) {
        if (userAgent.indexOf("Gecko") != -1) {
            return this.copyCommandsExcept(DEFAULT_SUPPORTED_COMMANDS, new String[]{"copy", "cut", "paste", "insertimage", "createlink"});
        }
        if (userAgent.indexOf("Explorer") != -1) {
            return this.copyCommandsExcept(DEFAULT_SUPPORTED_COMMANDS, new String[]{"undo", "redo"});
        }
        return DEFAULT_SUPPORTED_COMMANDS;
    }

    @Override
    public ImageReference getCommandImage(RichTextArea rta, String userAgent, String command) {
        return (ImageReference)this.commandImages.get(command);
    }

    public void setFontNames(String[][] strings) {
        this.fontNames = strings;
    }

    public void setFontSizes(String[][] strings) {
        this.fontSizes = strings;
    }

    public void setParagraphStyles(String[][] strings) {
        this.paragraphStyles = strings;
    }

    public void setCommandImage(String command, ImageReference image) {
        this.commandImages.put(command, image);
    }

    @Override
    public RichTextRenderer.CommandAppearance getCommandAppearance(RichTextArea rta, String userAgent) {
        return new RichTextRenderer.CommandAppearance(){

            @Override
            public Color getBackground() {
                return ColorKit.makeColor("#efefef");
            }

            @Override
            public Border getBorder() {
                return new Border(1, ColorKit.makeColor("#D6D3CE"), 1);
            }

            @Override
            public Color getRolloverBackground() {
                return ColorKit.makeColor("#DEF3FF");
            }

            @Override
            public Border getRolloverBorder() {
                return new Border(1, ColorKit.makeColor("#3169C6"), 1);
            }

            @Override
            public Color getSelectedBackground() {
                return ColorKit.makeColor("#C6D3EF");
            }

            @Override
            public Border getSelectedBorder() {
                return new Border(1, ColorKit.makeColor("#3169C6"), 1);
            }
        };
    }

    private class StringArrayComparator
    implements Comparator {
        private int compareIndex = 0;

        StringArrayComparator(int compareIndex) {
            this.compareIndex = compareIndex;
        }

        public int compare(Object o1, Object o2) {
            String[] s1 = (String[])o1;
            String[] s2 = (String[])o2;
            return s1[this.compareIndex].compareTo(s2[this.compareIndex]);
        }
    }
}

