/*
 * Decompiled with CFR 0.152.
 */
package echopointng.stylesheet;

import echopointng.stylesheet.CssClassDecl;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

class CssClassPropertyDecl
implements Cloneable {
    private int lineNo;
    private CssClassDecl classEntry;
    private String propertyName;
    private String targetClassName;
    private int index = -1;
    private List propertyValues = new ArrayList();

    CssClassPropertyDecl() {
    }

    boolean isSingleValue() {
        if (this.propertyValues.size() == 1) {
            return this.propertyValues.get(0) instanceof String;
        }
        return false;
    }

    void setClassEntry(CssClassDecl classEntry) {
        this.classEntry = classEntry;
    }

    String getPropertyValue() {
        if (this.isSingleValue()) {
            return (String)this.propertyValues.get(0);
        }
        return null;
    }

    CssClassPropertyDecl[] getProperties() {
        return this.propertyValues.toArray(new CssClassPropertyDecl[this.propertyValues.size()]);
    }

    void setPropertyValue(String value) {
        this.propertyValues.clear();
        this.propertyValues.add(value);
    }

    void addProperty(CssClassPropertyDecl propertyEntry) {
        this.propertyValues.add(propertyEntry);
    }

    CssClassDecl getClassEntry() {
        return this.classEntry;
    }

    boolean isIndexedProperty() {
        return this.index >= 0;
    }

    int getIndex() {
        return this.index;
    }

    void setIndex(int index) {
        this.index = index;
    }

    int getLineNo() {
        return this.lineNo;
    }

    String getPropertyName() {
        return this.propertyName;
    }

    void setPropertyName(String propertyName) {
        int opener = propertyName.indexOf(91);
        int ender = propertyName.indexOf(93);
        if (opener > 0 && ender == propertyName.length() - 1) {
            this.propertyName = propertyName.substring(0, opener);
            String indexNum = propertyName.substring(opener + 1, ender);
            try {
                this.index = Integer.parseInt(indexNum);
            }
            catch (Exception exception) {}
        } else {
            this.propertyName = propertyName;
        }
    }

    String getTargetClassName() {
        return this.targetClassName;
    }

    void setLineNo(int lineNo) {
        this.lineNo = lineNo;
    }

    void setTargetClassName(String targetClassName) {
        this.targetClassName = targetClassName;
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cnse) {
            return null;
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.propertyName);
        if (this.targetClassName != null) {
            sb.append(" targetClass:");
            sb.append(this.targetClassName);
        }
        sb.append(" : ");
        if (this.isSingleValue()) {
            sb.append(this.getPropertyValue());
        } else {
            sb.append(" {\n\t");
            Iterator iter = this.propertyValues.iterator();
            while (iter.hasNext()) {
                CssClassPropertyDecl element = (CssClassPropertyDecl)iter.next();
                sb.append(element);
                if (!iter.hasNext()) continue;
                sb.append(" , ");
            }
            sb.append("}\n");
        }
        return sb.toString();
    }
}

