/*
 * Decompiled with CFR 0.152.
 */
package echopointng.stylesheet;

import java.io.StreamTokenizer;
import java.io.StringReader;
import java.util.ArrayList;

public class CssObjectDeclarationParser {
    private static final String STATE_START = "STATE_START";
    private static final String STATE_END = "STATE_END";
    private static final String STATE_OBJNAME = "STATE_OBJNAME";
    private static final String STATE_OB = "STATE_OB";
    private static final String STATE_VAL = "STATE_VAL";
    private static final String STATE_INNEROBJ = "STATE_INNEROBJ";

    public static String[] parse(String objDecl) {
        return CssObjectDeclarationParser.tokenize(objDecl);
    }

    public static boolean isCssObjectDeclaration(String objDecl) {
        return CssObjectDeclarationParser.tokenize(objDecl).length > 0;
    }

    private static boolean isIdentifier(String s) {
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (!(i == 0 ? !Character.isJavaIdentifierStart(c) : !Character.isJavaIdentifierPart(c))) continue;
            return false;
        }
        return true;
    }

    private static String[] tokenize(String str) {
        return CssObjectDeclarationParser.doTokenize(str, "(),", 0, 32, 33, 255, true, false);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static String[] doTokenize(String str, String delims, int loWhiteSpace, int hiWhiteSpace, int loWordChar, int hiWordChar, boolean useQuotes, boolean noCommonWhiteSpace) {
        try {
            ArrayList<String> tokenList = new ArrayList<String>();
            StringReader sr = new StringReader(str);
            StreamTokenizer st = new StreamTokenizer(sr);
            st.resetSyntax();
            st.whitespaceChars(loWhiteSpace, hiWhiteSpace);
            st.wordChars(loWordChar, hiWordChar);
            for (int i = 0; i < delims.length(); ++i) {
                st.ordinaryChar(delims.charAt(i));
            }
            if (useQuotes) {
                st.quoteChar(39);
                st.quoteChar(34);
            }
            if (noCommonWhiteSpace) {
                st.wordChars(32, 32);
                st.wordChars(9, 9);
                st.wordChars(10, 10);
                st.wordChars(13, 13);
            }
            int tt = st.nextToken();
            int braceCount = 0;
            String state = STATE_START;
            String prevState = STATE_START;
            String currentVal = "";
            String token = "";
            while (tt != -1) {
                token = null;
                boolean isWordToken = true;
                switch (tt) {
                    case -3: {
                        token = st.sval;
                        break;
                    }
                    case 34: {
                        if (state == STATE_INNEROBJ) {
                            token = "\"" + st.sval + "\"";
                            break;
                        }
                        token = st.sval;
                        break;
                    }
                    case 39: {
                        if (state == STATE_INNEROBJ) {
                            token = "'" + st.sval + "'";
                            break;
                        }
                        token = st.sval;
                        break;
                    }
                    case -1: {
                        break;
                    }
                    default: {
                        token = new String(new char[]{(char)tt});
                        isWordToken = false;
                    }
                }
                if (state == STATE_START) {
                    if (!isWordToken) {
                        throw new RuntimeException("Expecting obj decl name");
                    }
                    if (!CssObjectDeclarationParser.isIdentifier(token)) {
                        throw new RuntimeException("obj name must be a java identifier");
                    }
                    tokenList.add(token);
                    currentVal = "";
                    prevState = state;
                    state = STATE_OBJNAME;
                } else if (state == STATE_OBJNAME) {
                    if (!token.equals("(")) {
                        throw new RuntimeException("Expecting ( after obj decl name");
                    }
                    prevState = state;
                    state = STATE_OB;
                } else if (state == STATE_OB) {
                    if (token.equals(")")) {
                        if (prevState != STATE_OBJNAME) {
                            tokenList.add(currentVal);
                        }
                        prevState = state;
                        state = STATE_END;
                        continue;
                    }
                    if (token.equals(",")) {
                        tokenList.add("");
                        currentVal = "";
                        prevState = state;
                        state = STATE_OB;
                    } else {
                        if (!isWordToken) {
                            throw new RuntimeException("Expecting a obj value here");
                        }
                        currentVal = token;
                        prevState = state;
                        state = STATE_VAL;
                    }
                } else if (state == STATE_VAL) {
                    if (token.equals("(")) {
                        currentVal = currentVal + token;
                        ++braceCount;
                        prevState = state;
                        state = STATE_INNEROBJ;
                    } else if (token.equals(",")) {
                        tokenList.add(currentVal);
                        currentVal = "";
                        prevState = state;
                        state = STATE_OB;
                    } else {
                        if (!token.equals(")")) throw new RuntimeException("Unexpected input" + token);
                        tokenList.add(currentVal);
                        prevState = state;
                        state = STATE_END;
                    }
                } else if (state == STATE_INNEROBJ) {
                    if (token.equals(")")) {
                        currentVal = currentVal + token;
                        if (--braceCount == 0) {
                            prevState = state;
                            state = STATE_VAL;
                        }
                    } else {
                        if (token.equals("(")) {
                            ++braceCount;
                        }
                        currentVal = currentVal + token;
                    }
                } else if (state == STATE_END) break;
                tt = st.nextToken();
            }
            if (state == STATE_END) return tokenList.toArray(new String[tokenList.size()]);
            return new String[0];
        }
        catch (Exception e) {
            return new String[0];
        }
    }
}

