/*
 * Decompiled with CFR 0.152.
 */
package echopointng.stylesheet;

import echopointng.stylesheet.CssClassDecl;
import echopointng.stylesheet.CssClassPropertyDecl;
import echopointng.stylesheet.CssObjectIntrospector;
import echopointng.stylesheet.CssPropertyPeerLoader;
import echopointng.stylesheet.CssStyleSheetException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import nextapp.echo2.app.MutableStyle;
import nextapp.echo2.app.Style;

class CssStyleSetter {
    CssStyleSetter() {
    }

    Style createStyle(CssClassDecl currentCE, ClassLoader classLoader) throws CssStyleSheetException {
        CssObjectIntrospector ci;
        MutableStyle propertyStyle = new MutableStyle();
        CssClassPropertyDecl[] entries = currentCE.getProperties();
        if (entries.length == 0) {
            return propertyStyle;
        }
        try {
            ci = CssObjectIntrospector.forName(currentCE.getClassName(), classLoader);
        }
        catch (ClassNotFoundException ex) {
            throw new CssStyleSheetException("Unable to instrospect component class: " + currentCE.getClassName(), ex, currentCE.getLineNo());
        }
        for (int i = 0; i < entries.length; ++i) {
            CssClassPropertyDecl pe = entries[i];
            String propertyName = pe.getPropertyName();
            Object propertyValue = this.getPropertyValue(classLoader, ci, pe);
            if (ci.isIndexedProperty(propertyName)) {
                propertyStyle.setIndexedProperty(propertyName, pe.getIndex(), propertyValue);
                continue;
            }
            propertyStyle.setProperty(propertyName, propertyValue);
        }
        return propertyStyle;
    }

    private Object getPropertyValue(ClassLoader classLoader, CssObjectIntrospector ci, CssClassPropertyDecl pe) throws CssStyleSheetException {
        CssObjectIntrospector propertyCI;
        Class<?> propertyClass;
        int lineNo = pe.getLineNo();
        String parentClassName = ci.getIntrospectedClass().getName();
        String propertyName = pe.getPropertyName();
        String propertyTargetClassName = pe.getTargetClassName();
        if (propertyTargetClassName != null) {
            try {
                if (propertyTargetClassName.indexOf(46) == -1) {
                    propertyTargetClassName = "nextapp.echo2.app." + propertyTargetClassName;
                }
                propertyClass = Class.forName(propertyTargetClassName, true, classLoader);
            }
            catch (ClassNotFoundException ex) {
                throw new CssStyleSheetException("Target property class not found: " + propertyTargetClassName, ex, lineNo);
            }
        } else {
            propertyClass = ci.getPropertyClass(propertyName);
        }
        if (propertyClass == null) {
            throw new CssStyleSheetException("Property does not exist: " + propertyName + " in class: " + parentClassName, null, lineNo);
        }
        if (pe.isSingleValue()) {
            String propertyValue = pe.getPropertyValue();
            Class componentClass = ci.getIntrospectedClass();
            CssPropertyPeerLoader peerLoader = CssPropertyPeerLoader.forClassLoader(classLoader);
            return peerLoader.getObject(classLoader, componentClass, propertyClass, propertyValue, pe.getLineNo());
        }
        try {
            propertyCI = CssObjectIntrospector.forName(propertyClass.getName(), classLoader);
        }
        catch (ClassNotFoundException e) {
            throw new CssStyleSheetException("Unable to instrospect class: " + propertyClass.getName(), e, lineNo);
        }
        CssClassPropertyDecl[] entries = pe.getProperties();
        Object[] childObjectValues = new Object[entries.length];
        for (int i = 0; i < entries.length; ++i) {
            Object propertyObjValue;
            CssClassPropertyDecl childPE = entries[i];
            childObjectValues[i] = propertyObjValue = this.getPropertyValue(classLoader, propertyCI, childPE);
        }
        Object objectInstance = this.noArgsContruction(propertyCI, propertyClass, entries, childObjectValues, lineNo);
        if (objectInstance == null) {
            objectInstance = this.constructorContruction(propertyCI, propertyClass, entries, childObjectValues, lineNo);
        }
        if (objectInstance == null) {
            throw new CssStyleSheetException("Unable to instantiate object instance for class: " + propertyClass.getName(), null, lineNo);
        }
        return objectInstance;
    }

    private Object noArgsContruction(CssObjectIntrospector ci, Class propertyClass, CssClassPropertyDecl[] entries, Object[] childObjectValues, int lineNo) throws CssStyleSheetException {
        Object propertyInstance;
        try {
            propertyInstance = propertyClass.newInstance();
        }
        catch (Exception e1) {
            return null;
        }
        for (int i = 0; i < entries.length; ++i) {
            CssClassPropertyDecl childPE = entries[i];
            String childPropertyName = childPE.getPropertyName();
            String childParentClassName = ci.getIntrospectedClass().getName();
            Object objectValue = childObjectValues[i];
            Method writeMethod = ci.getWriteMethod(childPropertyName);
            try {
                writeMethod.invoke(propertyInstance, objectValue);
                continue;
            }
            catch (Exception e2) {
                throw new CssStyleSheetException("Unable to set property :" + childPropertyName + " into object class: " + childParentClassName, e2, lineNo);
            }
        }
        return propertyInstance;
    }

    private Object constructorContruction(CssObjectIntrospector ci, Class propertyClass, CssClassPropertyDecl[] entries, Object[] childObjectValues, int lineNo) {
        try {
            Constructor constructor = ci.getConstructor(childObjectValues);
            if (constructor == null) {
                return null;
            }
            return constructor.newInstance(childObjectValues);
        }
        catch (SecurityException e) {
            return null;
        }
        catch (IllegalArgumentException e) {
            return null;
        }
        catch (InstantiationException e) {
            return null;
        }
        catch (IllegalAccessException e) {
            return null;
        }
        catch (InvocationTargetException e) {
            return null;
        }
    }
}

