/*
 * Decompiled with CFR 0.152.
 */
package echopointng.stylesheet;

import echopointng.stylesheet.CssClassDecl;
import echopointng.stylesheet.CssClassPropertyDecl;
import echopointng.stylesheet.CssStyleSheetException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StreamTokenizer;
import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import java.util.StringTokenizer;

class CssStyleSheetParser {
    private final int STATE_CLASSNAME = 0;
    private final int STATE_LEFTCURLY = 1;
    private final int STATE_RIGHTCURLY = 2;
    private final int STATE_ATTRNAME = 3;
    private final int STATE_ATTRVAL = 4;
    private final int STATE_SEMICOLON = 5;
    private final int STATE_COLON = 6;
    private final int STATE_EXTENDS = 7;
    private int state = 2;
    private List classEntryList = new ArrayList();
    private Stack propertyStack = new Stack();
    private InputStream input;

    public CssStyleSheetParser(InputStream in) {
        this.input = in;
    }

    void parse() throws CssStyleSheetException {
        String token = null;
        String currentPropertyName = null;
        String currentPropertyValue = null;
        String className = null;
        CssClassDecl currentCE = null;
        CssClassPropertyDecl currentPE = null;
        int tt = 0;
        int orderNum = 0;
        StreamTokenizer st = null;
        try {
            st = new StreamTokenizer(new InputStreamReader(this.input));
            CssStyleSheetParser.resetParserSyntaxTable(st, false);
            this.classEntryList.clear();
            tt = st.nextToken();
            while (tt != -1) {
                token = "";
                boolean isWordToken = true;
                switch (tt) {
                    case -3: {
                        token = st.sval;
                        break;
                    }
                    case 34: {
                        token = '\"' + st.sval + '\"';
                        break;
                    }
                    case 39: {
                        token = '\'' + st.sval + '\'';
                        break;
                    }
                    case -1: {
                        break;
                    }
                    default: {
                        token = "" + (char)st.ttype;
                        isWordToken = false;
                    }
                }
                switch (this.state) {
                    case 2: {
                        CssStyleSheetParser.resetParserSyntaxTable(st, false);
                        if (!isWordToken) {
                            this.throwTPE(st.lineno(), token, "class name expected");
                        }
                        className = token;
                        this.state = 0;
                        break;
                    }
                    case 0: {
                        if (isWordToken) {
                            if (token.equalsIgnoreCase("extends")) {
                                currentCE = new CssClassDecl();
                                currentCE.setLineNo(st.lineno());
                                currentCE.setClassName(className);
                                this.state = 7;
                                break;
                            }
                            className = className + " " + token;
                            break;
                        }
                        if (token.equals(",")) {
                            className = className + " ";
                            break;
                        }
                        if (token.equals(";")) {
                            this.state = 0;
                            break;
                        }
                        if (!token.equals("{")) {
                            this.throwTPE(st.lineno(), token, "opening brace '{' or comma ',' expected");
                        }
                        currentCE = new CssClassDecl();
                        currentCE.setLineNo(st.lineno());
                        currentCE.setClassName(className);
                        CssStyleSheetParser.resetParserSyntaxTable(st, true);
                        this.state = 1;
                        break;
                    }
                    case 7: {
                        if (isWordToken) {
                            currentCE.setExtendsStyleName(token);
                            break;
                        }
                        if (!token.equals("{")) {
                            this.throwTPE(st.lineno(), token, "opening brace '{' or comma ',' expected");
                        }
                        CssStyleSheetParser.resetParserSyntaxTable(st, true);
                        this.state = 1;
                        break;
                    }
                    case 1: {
                        if (!isWordToken) {
                            if (token.equals("}")) {
                                CssStyleSheetParser.resetParserSyntaxTable(st, false);
                                this.state = 2;
                                break;
                            }
                            if (token.equals(";")) break;
                            this.throwTPE(st.lineno(), token, "attribute name expected");
                            break;
                        }
                        currentPropertyName = token;
                        this.state = 3;
                        break;
                    }
                    case 3: {
                        if (currentPE == null) {
                            currentPE = new CssClassPropertyDecl();
                        }
                        currentPE.setLineNo(st.lineno());
                        if (isWordToken) {
                            currentPropertyName = currentPropertyName + token;
                            break;
                        }
                        if (token.equals("[") || token.equals("]")) {
                            currentPropertyName = currentPropertyName + token;
                            break;
                        }
                        if (!token.equals(":")) {
                            this.throwTPE(st.lineno(), token, "colon ':' expected");
                        }
                        this.state = 6;
                        break;
                    }
                    case 6: {
                        CssClassPropertyDecl parentPE;
                        if (!token.equals("{") && !isWordToken) {
                            this.throwTPE(st.lineno(), token, "attribute value expected");
                        }
                        currentPE.setPropertyName(currentPropertyName);
                        if (token.equals("{")) {
                            parentPE = this.peekProperty();
                            if (parentPE != null) {
                                parentPE.addProperty(currentPE);
                            } else {
                                currentCE.addProperty(currentPE);
                            }
                            this.pushProperty(currentPE);
                            currentPE = null;
                            this.state = 1;
                            break;
                        }
                        currentPropertyValue = token;
                        this.state = 4;
                        break;
                    }
                    case 4: {
                        CssClassPropertyDecl parentPE;
                        if (isWordToken) {
                            currentPropertyValue = currentPropertyValue + " " + token;
                            break;
                        }
                        if (!(token.equals(";") || token.equals("{") || token.equals("}"))) {
                            this.throwTPE(st.lineno(), token, "semi colon ';', opening brace '{' or closing brace '}' expected");
                        }
                        if (token.equals("{")) {
                            currentPE.setTargetClassName(currentPropertyValue);
                            parentPE = this.peekProperty();
                            if (parentPE != null) {
                                parentPE.addProperty(currentPE);
                            } else {
                                currentCE.addProperty(currentPE);
                            }
                            this.pushProperty(currentPE);
                            currentPE = null;
                            this.state = 1;
                            break;
                        }
                        currentPE.setPropertyValue(currentPropertyValue);
                        parentPE = this.peekProperty();
                        if (parentPE != null) {
                            parentPE.addProperty(currentPE);
                        } else {
                            currentCE.addProperty(currentPE);
                        }
                        currentPE = null;
                        if (token.equals(";")) {
                            this.state = 5;
                            break;
                        }
                        if (!token.equals("}")) break;
                        if (parentPE != null) {
                            this.popProperty();
                            this.state = 5;
                            break;
                        }
                        currentCE.setOrder(orderNum++);
                        this.classEntryList.add(currentCE);
                        currentCE = new CssClassDecl();
                        CssStyleSheetParser.resetParserSyntaxTable(st, false);
                        this.state = 2;
                        break;
                    }
                    case 5: {
                        if (isWordToken) {
                            currentPropertyName = token;
                            this.state = 3;
                            break;
                        }
                        if (!token.equals("}") && !token.equals(";")) {
                            this.throwTPE(st.lineno(), token, "closing brace '}' or semi colon ';' expected");
                        }
                        if (!token.equals("}")) break;
                        CssClassPropertyDecl parentPE = this.peekProperty();
                        if (parentPE != null) {
                            this.popProperty();
                            this.state = 5;
                            break;
                        }
                        currentCE.setOrder(orderNum++);
                        this.classEntryList.add(currentCE);
                        currentCE = new CssClassDecl();
                        CssStyleSheetParser.resetParserSyntaxTable(st, false);
                        this.state = 2;
                    }
                }
                tt = st.nextToken();
            }
            if (this.state != 2) {
                this.throwTPE(st.lineno(), "", "closing brace '}' expected not end of file");
            }
        }
        catch (IOException ioe) {
            int lineNo = -1;
            if (st != null) {
                lineNo = st.lineno();
            }
            throw new CssStyleSheetException(ioe.toString(), ioe, lineNo);
        }
        this.parseFixup();
    }

    private void parseFixup() {
        int j;
        for (j = 0; j < this.classEntryList.size(); ++j) {
            CssClassDecl newEntry = null;
            CssClassDecl entry = (CssClassDecl)this.classEntryList.get(j);
            String[] classNames = CssStyleSheetParser.split(entry.getClassName(), " ");
            if (classNames.length <= 1) continue;
            entry.setClassName(classNames[0]);
            for (int i = 1; i < classNames.length; ++i) {
                newEntry = (CssClassDecl)entry.clone();
                newEntry.setClassName(classNames[i]);
                this.classEntryList.add(newEntry);
            }
        }
        for (j = 0; j < this.classEntryList.size(); ++j) {
            CssClassDecl entry = (CssClassDecl)this.classEntryList.get(j);
            String[] names = CssStyleSheetParser.split(entry.getClassName(), "#");
            entry.setClassName(names[0]);
            if (names.length <= 1) continue;
            entry.setStyleName(names[1]);
        }
    }

    private void pushProperty(CssClassPropertyDecl attrEntry) {
        this.propertyStack.push(attrEntry);
    }

    private CssClassPropertyDecl popProperty() {
        return this.propertyStack.isEmpty() ? null : (CssClassPropertyDecl)this.propertyStack.pop();
    }

    private CssClassPropertyDecl peekProperty() {
        return this.propertyStack.isEmpty() ? null : (CssClassPropertyDecl)this.propertyStack.peek();
    }

    CssClassDecl[] getClassEntries() {
        return this.classEntryList.toArray(new CssClassDecl[this.classEntryList.size()]);
    }

    private static void resetParserSyntaxTable(StreamTokenizer st, boolean commasAreWords) {
        st.resetSyntax();
        st.whitespaceChars(0, 32);
        st.whitespaceChars(160, 160);
        st.wordChars(48, 122);
        st.ordinaryChars(33, 39);
        st.ordinaryChars(42, 43);
        st.ordinaryChars(45, 47);
        st.ordinaryChars(58, 64);
        st.ordinaryChars(91, 96);
        st.ordinaryChars(123, 127);
        st.wordChars(35, 35);
        st.wordChars(40, 41);
        st.wordChars(46, 46);
        st.wordChars(95, 95);
        st.wordChars(36, 36);
        st.wordChars(45, 45);
        st.wordChars(124, 124);
        st.wordChars(37, 37);
        st.wordChars(33, 33);
        if (commasAreWords) {
            st.wordChars(44, 44);
        } else {
            st.ordinaryChars(44, 44);
        }
        st.eolIsSignificant(false);
        st.slashSlashComments(true);
        st.slashStarComments(true);
        st.quoteChar(34);
        st.quoteChar(39);
    }

    private static String[] split(String s, String delimeters) {
        ArrayList<String> list = new ArrayList<String>();
        StringTokenizer st = new StringTokenizer(s, delimeters, false);
        while (st.hasMoreTokens()) {
            list.add(st.nextToken());
        }
        return list.toArray(new String[list.size()]);
    }

    private void throwTPE(int lineNo, String token, String message) throws CssStyleSheetException {
        if (this.input != null) {
            try {
                this.input.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        this.input = null;
        String msg = "CSS stylesheet parse failure : " + message;
        if (token != null || token.length() > 0) {
            msg = msg + " instead found '" + token + "' line : " + lineNo;
        }
        throw new CssStyleSheetException(msg, null, lineNo);
    }
}

