/*
 * Decompiled with CFR 0.152.
 */
package echopointng.stylesheet.propertypeer;

import echopointng.stylesheet.CssObjectDeclarationParser;
import echopointng.stylesheet.CssObjectIntrospector;
import echopointng.stylesheet.propertypeer.AbstractCssPropertyPeer;
import echopointng.stylesheet.propertypeer.ImageReferencePeer;
import echopointng.util.ExtentKit;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import nextapp.echo2.app.Extent;
import nextapp.echo2.app.FillImage;
import nextapp.echo2.app.ImageReference;

public class FillImagePeer
extends AbstractCssPropertyPeer {
    private static final Map REPEAT_CONSTANTS;

    @Override
    protected Class getConversionClass() {
        return FillImage.class;
    }

    @Override
    protected boolean canConvert(CssObjectIntrospector ci, String propertyValue) {
        if (FillImagePeer.isNullString(propertyValue)) {
            return true;
        }
        String[] tokens = CssObjectDeclarationParser.parse(propertyValue);
        if (!tokens[0].equalsIgnoreCase("fillimage")) {
            return false;
        }
        ImageReferencePeer imagePeer = new ImageReferencePeer();
        if (tokens.length == 2) {
            String objType = tokens[0];
            String imageRef = tokens[1];
            return objType.toLowerCase().equalsIgnoreCase("fillimage") && imagePeer.canConvert(ci, imageRef);
        }
        if (tokens.length == 5) {
            String objType = tokens[0];
            String imageRef = tokens[1];
            String horizontalOffset = tokens[2];
            String verticalOffset = tokens[3];
            return objType.toLowerCase().equals("fillimage") && imagePeer.canConvert(ci, imageRef) && ExtentKit.isExtent(horizontalOffset) && ExtentKit.isExtent(verticalOffset);
        }
        return false;
    }

    @Override
    protected Object getObject(CssObjectIntrospector ci, String propertyValue) {
        if (FillImagePeer.isNullString(propertyValue)) {
            return null;
        }
        String[] tokens = CssObjectDeclarationParser.parse(propertyValue);
        ImageReferencePeer imagePeer = (ImageReferencePeer)FillImagePeer.getPeer(ImageReference.class);
        if (tokens.length == 2) {
            String imageRef = tokens[1];
            ImageReference imageRefObj = (ImageReference)imagePeer.getObject(ci, imageRef);
            return new FillImage(imageRefObj);
        }
        if (tokens.length == 5) {
            String imageRef = tokens[1];
            Extent horizontalOffset = ExtentKit.makeExtent(tokens[2]);
            Extent verticalOffset = ExtentKit.makeExtent(tokens[3]);
            int repeat = FillImagePeer.getIntFromMap(REPEAT_CONSTANTS, tokens[4].toUpperCase());
            ImageReference imageRefObj = (ImageReference)imagePeer.getObject(ci, imageRef);
            return new FillImage(imageRefObj, horizontalOffset, verticalOffset, repeat);
        }
        return null;
    }

    @Override
    protected String getString(CssObjectIntrospector ci, Object object) {
        FillImage value = (FillImage)object;
        ImageReferencePeer imagePeer = (ImageReferencePeer)FillImagePeer.getPeer(ImageReference.class);
        StringBuffer sb = new StringBuffer();
        sb.append("fillimage(");
        sb.append(imagePeer.getString(ci, value.getImage()));
        sb.append(",");
        sb.append(String.valueOf(value.getHorizontalOffset()));
        sb.append(",");
        sb.append(String.valueOf(value.getVerticalOffset()));
        sb.append(",");
        sb.append(FillImagePeer.getConstantFromMap(REPEAT_CONSTANTS, value.getRepeat()));
        sb.append(")");
        return sb.toString();
    }

    static {
        HashMap<String, Integer> constantMap = new HashMap<String, Integer>();
        constantMap.put("NO_REPEAT", new Integer(0));
        constantMap.put("REPEAT", new Integer(3));
        constantMap.put("REPEAT_HORIZONTAL", new Integer(1));
        constantMap.put("REPEAT_VERTICAL", new Integer(2));
        REPEAT_CONSTANTS = Collections.unmodifiableMap(constantMap);
    }
}

