/*
 * Decompiled with CFR 0.152.
 */
package echopointng.table;

import echopointng.EPNG;
import echopointng.LiveTable;
import echopointng.table.LiveTableRenderer;
import echopointng.ui.util.Render;
import nextapp.echo2.app.Border;
import nextapp.echo2.app.Extent;
import nextapp.echo2.app.Style;
import nextapp.echo2.app.util.DomUtil;
import nextapp.echo2.webcontainer.RenderContext;
import nextapp.echo2.webcontainer.propertyrender.BorderRender;
import nextapp.echo2.webcontainer.propertyrender.ExtentRender;
import nextapp.echo2.webrender.output.CssStyle;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

public class DefaultLiveTableRenderer
implements LiveTableRenderer {
    protected static String NBSP = "\u00a0";

    @Override
    public void renderEmptyRow(LiveTable liveTable, Node parentNode) {
        Document doc = parentNode.getOwnerDocument();
        Element tr = doc.createElement("tr");
        parentNode.appendChild(tr);
        tr.setAttribute("class", "se" + liveTable.getRenderId());
        int cellCount = liveTable.getModel().getColumnCount();
        for (int i = 0; i < cellCount; ++i) {
            Element td = doc.createElement("td");
            tr.appendChild(td);
            td.setAttribute("class", "se" + liveTable.getRenderId());
            td.appendChild(doc.createTextNode(NBSP));
        }
    }

    @Override
    public void renderRows(LiveTable liveTable, Node parentNode, int rowStart, int rowEnd) {
        Document doc = parentNode.getOwnerDocument();
        for (int row = rowStart; row < rowEnd; ++row) {
            Element trE = doc.createElement("tr");
            parentNode.appendChild(trE);
            trE.setAttribute("class", "s" + liveTable.getRenderId());
            int cellCount = liveTable.getModel().getColumnCount();
            for (int column = 0; column < cellCount; ++column) {
                Element tdE = doc.createElement("td");
                trE.appendChild(tdE);
                tdE.setAttribute("class", "s" + liveTable.getRenderId());
                this.renderRowCell(liveTable, tdE, column, row);
            }
        }
    }

    protected void renderRowCell(LiveTable liveTable, Element parentTD, int column, int row) {
        Document doc = parentTD.getOwnerDocument();
        Object value = liveTable.getModel().getValueAt(column, row);
        Text textNode = doc.createTextNode(String.valueOf(value));
        parentTD.appendChild(textNode);
    }

    @Override
    public void renderStyles(LiveTable liveTable, Node parentNode) {
        Document doc = parentNode.getOwnerDocument();
        Extent rowHeight = (Extent)EPNG.getRP(liveTable, "rowsHeight");
        Border border = (Border)EPNG.getRP(liveTable, "border");
        String heightCss = "height:" + ExtentRender.renderCssAttributeValue(rowHeight) + ";";
        String borderCss = "";
        if (border != null && border.getColor() != null) {
            borderCss = "border:" + BorderRender.renderCssAttributeValue(border) + ";";
        }
        String extraCss = "white-space:nowrap;";
        String styleName = "tr.s" + liveTable.getRenderId();
        String styleText = styleName + " {" + heightCss + "}";
        Element styleE = doc.createElement("style");
        DomUtil.setElementText(styleE, styleText);
        parentNode.appendChild(styleE);
        styleName = "td.s" + liveTable.getRenderId();
        styleText = styleName + " {" + heightCss + borderCss + extraCss + "}";
        styleE = doc.createElement("style");
        DomUtil.setElementText(styleE, styleText);
        parentNode.appendChild(styleE);
        styleName = "tr.se" + liveTable.getRenderId();
        styleText = styleName + " {" + heightCss + "}";
        styleE = doc.createElement("style");
        DomUtil.setElementText(styleE, styleText);
        parentNode.appendChild(styleE);
        styleName = "td.se" + liveTable.getRenderId();
        styleText = styleName + " {" + heightCss + borderCss + extraCss + "}";
        styleE = doc.createElement("style");
        DomUtil.setElementText(styleE, styleText);
        parentNode.appendChild(styleE);
    }

    @Override
    public String renderRolloverStyle(LiveTable liveTable, Node parentNode, RenderContext rc) {
        Document doc = parentNode.getOwnerDocument();
        Style fallbackStyle = EPNG.getFallBackStyle(liveTable);
        CssStyle rolloverCssStyle = new CssStyle();
        Render.asColors(rolloverCssStyle, liveTable, "rolloverBackground", "rolloverForeground", fallbackStyle);
        Render.asFont(rolloverCssStyle, liveTable, "rolloverFont", fallbackStyle);
        Render.asFillImage(rolloverCssStyle, liveTable, "rolloverBackgroundImage", fallbackStyle, rc);
        String styleName = "sr" + liveTable.getRenderId();
        String styleText = "td." + styleName + " {" + rolloverCssStyle.renderInline() + "}";
        Element styleE = doc.createElement("style");
        DomUtil.setElementText(styleE, styleText);
        parentNode.appendChild(styleE);
        return styleName;
    }

    @Override
    public String renderSelectionStyle(LiveTable liveTable, Node parentNode, RenderContext rc) {
        Document doc = parentNode.getOwnerDocument();
        Style fallbackStyle = EPNG.getFallBackStyle(liveTable);
        CssStyle rolloverCssStyle = new CssStyle();
        Render.asColors(rolloverCssStyle, liveTable, "selectionBackground", "selectionForeground", fallbackStyle);
        Render.asFont(rolloverCssStyle, liveTable, "selectionFont", fallbackStyle);
        Render.asFillImage(rolloverCssStyle, liveTable, "selectionBackgroundImage", fallbackStyle, rc);
        String styleName = "ss" + liveTable.getRenderId();
        String styleText = "td." + styleName + " {" + rolloverCssStyle.renderInline() + "}";
        Element styleE = doc.createElement("style");
        DomUtil.setElementText(styleE, styleText);
        parentNode.appendChild(styleE);
        return styleName;
    }
}

