/*
 * Decompiled with CFR 0.152.
 */
package echopointng.table;

import echopointng.table.PageableTableModel;
import java.util.Arrays;
import java.util.List;
import nextapp.echo2.app.Button;
import nextapp.echo2.app.Extent;
import nextapp.echo2.app.Label;
import nextapp.echo2.app.Row;
import nextapp.echo2.app.SelectField;
import nextapp.echo2.app.Table;
import nextapp.echo2.app.event.ActionEvent;
import nextapp.echo2.app.event.ActionListener;

public class PageableTableNavigation
extends Row {
    private PageableTableModel model;
    private static final Object[] ROWS_PER_PAGE_OPTIONS = new String[]{"10", "25", "50", "100"};
    private static final List ROWS_PER_PAGE_LIST = Arrays.asList(ROWS_PER_PAGE_OPTIONS);

    public PageableTableNavigation(Table table) {
        this.model = (PageableTableModel)table.getModel();
    }

    @Override
    public void init() {
        super.init();
        this.reset();
    }

    protected void doLayout() {
        this.setCellSpacing(new Extent(10));
        this.add(this.getPreviousButton());
        this.add(this.getResultsPerPageSelect());
        this.add(this.getPageLabel());
        this.add(this.getPageSelect());
        this.add(this.getPageCountLabel());
        this.add(this.getNextButton());
    }

    protected void reset() {
        this.removeAll();
        this.doLayout();
    }

    protected PageableTableModel getModel() {
        return this.model;
    }

    private SelectField getPageSelect() {
        Object[] pages = new String[this.model.getTotalPages()];
        for (int i = 0; i < pages.length; ++i) {
            pages[i] = "" + (i + 1);
        }
        SelectField select = new SelectField(pages);
        select.setSelectedIndex(this.model.getCurrentPage());
        select.addActionListener(this.getPageSelectListener());
        return select;
    }

    private ActionListener getPageSelectListener() {
        return new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SelectField select = (SelectField)e.getSource();
                int selected = select.getSelectedIndex();
                PageableTableNavigation.this.model.setCurrentPage(selected);
                PageableTableNavigation.this.reset();
            }
        };
    }

    private Label getPageLabel() {
        Label label = new Label(" Page ");
        return label;
    }

    private Label getPageCountLabel() {
        Label label = new Label();
        label.setText(" of " + this.model.getTotalPages() + " ");
        this.setPageCountLabelText();
        return label;
    }

    private void setPageCountLabelText() {
    }

    private Button getPreviousButton() {
        Button previousButton = new Button(" < Previous ");
        previousButton.addActionListener(this.getPreviousListener());
        return previousButton;
    }

    private SelectField getResultsPerPageSelect() {
        SelectField resultsPerPage = new SelectField(ROWS_PER_PAGE_OPTIONS);
        resultsPerPage.addActionListener(this.getRowsPerPageListener());
        int index = ROWS_PER_PAGE_LIST.indexOf("" + this.model.getRowsPerPage());
        resultsPerPage.setSelectedIndex(index);
        return resultsPerPage;
    }

    private Button getNextButton() {
        Button previousButton = new Button(" Next > ");
        previousButton.addActionListener(this.getNextListener());
        return previousButton;
    }

    private ActionListener getPreviousListener() {
        return new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (PageableTableNavigation.this.getModel().getCurrentPage() > 0) {
                    PageableTableNavigation.this.getModel().setCurrentPage(PageableTableNavigation.this.getModel().getCurrentPage() - 1);
                    PageableTableNavigation.this.reset();
                }
            }
        };
    }

    private ActionListener getNextListener() {
        return new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int maxPage;
                int currentPage = PageableTableNavigation.this.getModel().getCurrentPage();
                if (currentPage + 1 < (maxPage = PageableTableNavigation.this.getModel().getTotalPages())) {
                    PageableTableNavigation.this.getModel().setCurrentPage(currentPage + 1);
                    PageableTableNavigation.this.reset();
                }
            }
        };
    }

    private ActionListener getRowsPerPageListener() {
        return new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SelectField select = (SelectField)e.getSource();
                Integer selected = new Integer((String)select.getSelectedItem());
                PageableTableNavigation.this.getModel().setRowsPerPage(selected);
                PageableTableNavigation.this.getModel().setCurrentPage(0);
                PageableTableNavigation.this.reset();
            }
        };
    }
}

