/*
 * Decompiled with CFR 0.152.
 */
package echopointng.tree;

import echopointng.tree.RowMapper;
import echopointng.tree.TreeListSelectionModel;
import echopointng.tree.TreePath;
import echopointng.tree.TreeSelectionEvent;
import echopointng.tree.TreeSelectionListener;
import echopointng.tree.TreeSelectionModel;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.Serializable;
import java.util.BitSet;
import java.util.EventListener;
import java.util.Vector;
import nextapp.echo2.app.event.EventListenerList;

public class DefaultTreeSelectionModel
implements TreeSelectionModel,
Serializable {
    public static final String SELECTION_MODE_PROPERTY = "selectionMode";
    protected PropertyChangeSupport changeSupport;
    protected int leadIndex = -1;
    protected TreePath leadPath;
    protected int leadRow = -1;
    protected EventListenerList listenerList = new EventListenerList();
    protected TreeListSelectionModel listSelectionModel = new TreeListSelectionModel();
    protected transient RowMapper rowMapper;
    protected TreePath[] selection;
    protected int selectionMode = 4;

    @Override
    public synchronized void addPropertyChangeListener(PropertyChangeListener listener) {
        if (this.changeSupport == null) {
            this.changeSupport = new PropertyChangeSupport(this);
        }
        this.changeSupport.addPropertyChangeListener(listener);
    }

    @Override
    public void addSelectionPath(TreePath path) {
        if (path != null) {
            TreePath[] toAdd = new TreePath[]{path};
            this.addSelectionPaths(toAdd);
        }
    }

    @Override
    public void addSelectionPaths(TreePath[] paths) {
        int newPathLength;
        int n = newPathLength = paths == null ? 0 : paths.length;
        if (newPathLength > 0) {
            if (this.selectionMode == 1 && this.selection != null && this.selection.length > 0) {
                this.setSelectionPaths(paths);
            } else if (this.selectionMode == 2 && !this.canPathsBeAdded(paths)) {
                if (this.arePathsContiguous(paths)) {
                    this.setSelectionPaths(paths);
                } else {
                    TreePath[] newPaths = new TreePath[]{paths[0]};
                    this.setSelectionPaths(newPaths);
                }
            } else {
                int counter;
                TreePath beginLeadPath = this.leadPath;
                Vector<TreeSpot> cPaths = null;
                int oldCount = this.selection == null ? 0 : this.selection.length;
                boolean didCopyPaths = false;
                this.leadPath = null;
                int validCount = 0;
                for (counter = 0; counter < paths.length; ++counter) {
                    if (paths[counter] == null) continue;
                    boolean inSelection = false;
                    for (int oldCounter = 0; oldCounter < oldCount; ++oldCounter) {
                        if (!paths[counter].equals(this.selection[oldCounter])) continue;
                        oldCounter = oldCount;
                        if (!didCopyPaths) {
                            TreePath[] copiedPaths = new TreePath[paths.length];
                            System.arraycopy(paths, 0, copiedPaths, 0, paths.length);
                            paths = copiedPaths;
                            didCopyPaths = true;
                        }
                        paths[counter] = null;
                        inSelection = true;
                    }
                    if (!inSelection) {
                        ++validCount;
                        if (cPaths == null) {
                            cPaths = new Vector<TreeSpot>();
                        }
                        cPaths.addElement(new TreeSpot(paths[counter], true));
                    }
                    if (this.leadPath != null) continue;
                    this.leadPath = paths[counter];
                }
                if (this.leadPath == null) {
                    this.leadPath = beginLeadPath;
                }
                if (validCount > 0) {
                    TreePath[] newSelection = new TreePath[oldCount + validCount];
                    if (oldCount > 0) {
                        System.arraycopy(this.selection, 0, newSelection, 0, oldCount);
                    }
                    if (validCount != paths.length) {
                        int validCounter = 0;
                        for (counter = 0; counter < paths.length; ++counter) {
                            if (paths[counter] == null) continue;
                            newSelection[oldCount + validCounter++] = paths[counter];
                        }
                    } else {
                        System.arraycopy(paths, 0, newSelection, oldCount, validCount);
                    }
                    this.selection = newSelection;
                    this.insureUniqueness();
                    this.updateLeadIndex();
                    this.resetRowSelection();
                    this.notifyPathChange(cPaths, beginLeadPath);
                } else {
                    this.leadPath = beginLeadPath;
                }
            }
        }
    }

    @Override
    public void addTreeSelectionListener(TreeSelectionListener x) {
        this.listenerList.addListener(TreeSelectionListener.class, x);
    }

    protected boolean arePathsContiguous(TreePath[] paths) {
        int counter;
        if (this.rowMapper == null || paths.length < 2) {
            return true;
        }
        BitSet bitSet = new BitSet(32);
        int pathCount = paths.length;
        int validCount = 0;
        TreePath[] tempPath = new TreePath[]{paths[0]};
        int min = this.rowMapper.getRowsForPaths(tempPath)[0];
        for (counter = 0; counter < pathCount; ++counter) {
            if (paths[counter] == null) continue;
            tempPath[0] = paths[counter];
            int anIndex = this.rowMapper.getRowsForPaths(tempPath)[0];
            if (anIndex == -1 || anIndex < min - pathCount || anIndex > min + pathCount) {
                return false;
            }
            if (anIndex < min) {
                min = anIndex;
            }
            if (bitSet.get(anIndex)) continue;
            bitSet.set(anIndex);
            ++validCount;
        }
        int maxCounter = validCount + min;
        for (counter = min; counter < maxCounter; ++counter) {
            if (bitSet.get(counter)) continue;
            return false;
        }
        return true;
    }

    protected boolean canPathsBeAdded(TreePath[] paths) {
        int counter;
        if (paths == null || paths.length == 0 || this.rowMapper == null || this.selection == null || this.selectionMode == 4) {
            return true;
        }
        BitSet bitSet = new BitSet();
        int min = this.listSelectionModel.getMinSelectedIndex();
        int max = this.listSelectionModel.getMaxSelectedIndex();
        TreePath[] tempPath = new TreePath[1];
        if (min != -1) {
            for (counter = min; counter <= max; ++counter) {
                if (!this.listSelectionModel.isSelectedIndex(min)) continue;
                bitSet.set(counter);
            }
        } else {
            tempPath[0] = paths[0];
            min = max = this.rowMapper.getRowsForPaths(tempPath)[0];
        }
        for (counter = paths.length - 1; counter >= 0; --counter) {
            if (paths[counter] == null) continue;
            tempPath[0] = paths[counter];
            int anIndex = this.rowMapper.getRowsForPaths(tempPath)[0];
            min = Math.min(anIndex, min);
            max = Math.max(anIndex, max);
            if (anIndex == -1) {
                return false;
            }
            bitSet.set(anIndex);
        }
        for (counter = min; counter <= max; ++counter) {
            if (bitSet.get(counter)) continue;
            return false;
        }
        return true;
    }

    protected boolean canPathsBeRemoved(TreePath[] paths) {
        int counter;
        if (this.rowMapper == null || this.selection == null || this.selectionMode == 4) {
            return true;
        }
        BitSet bitSet = new BitSet();
        int pathCount = paths.length;
        int min = -1;
        int validCount = 0;
        TreePath[] tPaths = new TreePath[pathCount];
        TreePath[] tempPath = new TreePath[1];
        System.arraycopy(paths, 0, tPaths, 0, pathCount);
        for (counter = this.selection.length - 1; counter >= 0; --counter) {
            boolean found = false;
            for (int rCounter = 0; rCounter < pathCount; ++rCounter) {
                if (tPaths[rCounter] == null || !this.selection[counter].equals(tPaths[rCounter])) continue;
                tPaths[rCounter] = null;
                found = true;
                break;
            }
            if (found) continue;
            tempPath[0] = this.selection[counter];
            int anIndex = this.rowMapper.getRowsForPaths(tempPath)[0];
            if (anIndex == -1 || bitSet.get(anIndex)) continue;
            ++validCount;
            min = min == -1 ? anIndex : Math.min(min, anIndex);
            bitSet.set(anIndex);
        }
        if (validCount > 1) {
            for (counter = min + validCount - 1; counter >= min; --counter) {
                if (bitSet.get(counter)) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public void clearSelection() {
        if (this.selection != null) {
            int selSize = this.selection.length;
            boolean[] newness = new boolean[selSize];
            for (int counter = 0; counter < selSize; ++counter) {
                newness[counter] = false;
            }
            TreeSelectionEvent event = new TreeSelectionEvent((Object)this, this.selection, newness, this.leadPath, null);
            this.leadPath = null;
            this.leadRow = -1;
            this.leadIndex = -1;
            this.selection = null;
            this.resetRowSelection();
            this.fireValueChanged(event);
        }
    }

    protected void fireValueChanged(TreeSelectionEvent e) {
        EventListener[] listeners = this.listenerList.getListeners(TreeSelectionListener.class);
        for (int i = 0; i < listeners.length; ++i) {
            ((TreeSelectionListener)listeners[i]).valueChanged(e);
        }
    }

    @Override
    public TreePath getLeadSelectionPath() {
        return this.leadPath;
    }

    public int getLeadSelectionRow() {
        return this.leadRow;
    }

    public int getMaxSelectionRow() {
        return this.listSelectionModel.getMaxSelectedIndex();
    }

    public int getMinSelectionRow() {
        return this.listSelectionModel.getMinSelectedIndex();
    }

    public RowMapper getRowMapper() {
        return this.rowMapper;
    }

    @Override
    public int getSelectionCount() {
        return this.selection == null ? 0 : this.selection.length;
    }

    @Override
    public int getSelectionMode() {
        return this.selectionMode;
    }

    @Override
    public TreePath getSelectionPath() {
        if (this.selection != null) {
            return this.selection[0];
        }
        return null;
    }

    @Override
    public TreePath[] getSelectionPaths() {
        if (this.selection != null) {
            int pathSize = this.selection.length;
            TreePath[] result = new TreePath[pathSize];
            System.arraycopy(this.selection, 0, result, 0, pathSize);
            return result;
        }
        return null;
    }

    public int[] getSelectionRows() {
        if (this.rowMapper != null && this.selection != null) {
            return this.rowMapper.getRowsForPaths(this.selection);
        }
        return null;
    }

    protected void insureRowContinuity() {
        if (this.selectionMode == 2 && this.selection != null && this.rowMapper != null) {
            int min = this.listSelectionModel.getMinSelectedIndex();
            if (min != -1) {
                int maxCounter = this.listSelectionModel.getMaxSelectedIndex();
                for (int counter = min; counter <= maxCounter; ++counter) {
                    if (this.listSelectionModel.isSelectedIndex(counter)) continue;
                    if (counter == min) {
                        this.clearSelection();
                        continue;
                    }
                    TreePath[] newSel = new TreePath[counter - min];
                    System.arraycopy(this.selection, 0, newSel, 0, counter - min);
                    this.setSelectionPaths(newSel);
                    break;
                }
            }
        } else if (this.selectionMode == 1 && this.selection != null && this.selection.length > 1) {
            this.setSelectionPath(this.selection[0]);
        }
    }

    protected void insureUniqueness() {
        int dupCount = 0;
        for (int compareCounter = 0; compareCounter < this.selection.length; ++compareCounter) {
            if (this.selection[compareCounter] == null) continue;
            for (int indexCounter = compareCounter + 1; indexCounter < this.selection.length; ++indexCounter) {
                if (this.selection[indexCounter] == null || !this.selection[compareCounter].equals(this.selection[indexCounter])) continue;
                ++dupCount;
                this.selection[indexCounter] = null;
            }
        }
        if (dupCount > 0) {
            TreePath[] newSelection = new TreePath[this.selection.length - dupCount];
            int validCounter = 0;
            for (int counter = 0; counter < this.selection.length; ++counter) {
                if (this.selection[counter] == null) continue;
                newSelection[validCounter++] = this.selection[counter];
            }
            this.selection = newSelection;
        }
    }

    @Override
    public boolean isPathSelected(TreePath path) {
        if (this.selection != null) {
            for (int counter = 0; counter < this.selection.length; ++counter) {
                if (!this.selection[counter].equals(path)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isRowSelected(int row) {
        return this.listSelectionModel.isSelectedIndex(row);
    }

    @Override
    public boolean isSelectionEmpty() {
        return this.selection == null;
    }

    protected void notifyPathChange(Vector changedPaths, TreePath oldLeadSelection) {
        int cPathCount = changedPaths.size();
        boolean[] newness = new boolean[cPathCount];
        TreePath[] paths = new TreePath[cPathCount];
        for (int counter = 0; counter < cPathCount; ++counter) {
            TreeSpot spot = (TreeSpot)changedPaths.elementAt(counter);
            newness[counter] = spot.isNew;
            paths[counter] = spot.path;
        }
        TreeSelectionEvent event = new TreeSelectionEvent((Object)this, paths, newness, oldLeadSelection, this.leadPath);
        this.fireValueChanged(event);
    }

    @Override
    public synchronized void removePropertyChangeListener(PropertyChangeListener listener) {
        if (this.changeSupport == null) {
            return;
        }
        this.changeSupport.removePropertyChangeListener(listener);
    }

    @Override
    public void removeSelectionPath(TreePath path) {
        if (path != null) {
            TreePath[] rPath = new TreePath[]{path};
            this.removeSelectionPaths(rPath);
        }
    }

    @Override
    public void removeSelectionPaths(TreePath[] paths) {
        if (paths != null && this.selection != null && paths.length > 0) {
            if (!this.canPathsBeRemoved(paths)) {
                this.clearSelection();
            } else {
                int oldCounter;
                TreePath beginLeadPath = this.leadPath;
                Vector<TreeSpot> pathsToRemove = null;
                int oldCount = this.selection.length;
                for (int removeCounter = 0; removeCounter < paths.length; ++removeCounter) {
                    if (paths[removeCounter] == null) continue;
                    if (this.leadPath != null && this.leadPath.equals(paths[removeCounter])) {
                        this.leadPath = null;
                    }
                    for (oldCounter = 0; oldCounter < oldCount; ++oldCounter) {
                        if (!paths[removeCounter].equals(this.selection[oldCounter])) continue;
                        this.selection[oldCounter] = null;
                        oldCounter = oldCount;
                        if (pathsToRemove == null) {
                            pathsToRemove = new Vector<TreeSpot>(paths.length);
                        }
                        if (pathsToRemove.contains(paths[removeCounter])) continue;
                        pathsToRemove.addElement(new TreeSpot(paths[removeCounter], false));
                    }
                }
                if (pathsToRemove != null) {
                    int removeCount = pathsToRemove.size();
                    if (removeCount == this.selection.length) {
                        this.selection = null;
                    } else {
                        int validCount = 0;
                        TreePath[] newSelection = new TreePath[this.selection.length - removeCount];
                        for (oldCounter = 0; oldCounter < oldCount; ++oldCounter) {
                            if (this.selection[oldCounter] == null) continue;
                            newSelection[validCount++] = this.selection[oldCounter];
                        }
                        this.selection = newSelection;
                    }
                    if (this.leadPath == null && this.selection != null) {
                        this.leadPath = this.selection[0];
                    }
                    this.updateLeadIndex();
                    this.resetRowSelection();
                    this.notifyPathChange(pathsToRemove, beginLeadPath);
                }
            }
        }
    }

    @Override
    public void removeTreeSelectionListener(TreeSelectionListener x) {
        this.listenerList.removeListener(TreeSelectionListener.class, x);
    }

    public void resetRowSelection() {
        this.listSelectionModel.clearSelection();
        if (this.selection != null && this.rowMapper != null) {
            int[] rows = this.rowMapper.getRowsForPaths(this.selection);
            int maxCounter = this.selection.length;
            for (int counter = 0; counter < maxCounter; ++counter) {
                int aRow = rows[counter];
                if (aRow == -1) continue;
            }
            if (this.leadIndex != -1) {
                this.leadRow = rows[this.leadIndex];
            }
            this.insureRowContinuity();
        } else {
            this.leadRow = -1;
        }
    }

    public void setRowMapper(RowMapper newMapper) {
        this.rowMapper = newMapper;
        this.resetRowSelection();
    }

    @Override
    public void setSelectionMode(int mode) {
        int oldMode = this.selectionMode;
        this.selectionMode = mode;
        if (this.selectionMode != 1 && this.selectionMode != 2 && this.selectionMode != 4) {
            this.selectionMode = 4;
        }
        if (oldMode != this.selectionMode && this.changeSupport != null) {
            this.changeSupport.firePropertyChange(SELECTION_MODE_PROPERTY, new Integer(oldMode), new Integer(this.selectionMode));
        }
    }

    @Override
    public void setSelectionPath(TreePath path) {
        if (path == null) {
            this.setSelectionPaths(null);
        } else {
            TreePath[] newPaths = new TreePath[]{path};
            this.setSelectionPaths(newPaths);
        }
    }

    @Override
    public void setSelectionPaths(TreePath[] pPaths) {
        int oldCount;
        TreePath[] paths = pPaths;
        int newCount = paths == null ? 0 : paths.length;
        if (newCount + (oldCount = this.selection == null ? 0 : this.selection.length) != 0) {
            int oldCounter;
            int newCounter;
            if (this.selectionMode == 1) {
                if (newCount > 1) {
                    paths = new TreePath[]{pPaths[0]};
                    newCount = 1;
                }
            } else if (this.selectionMode == 2 && newCount > 0 && !this.arePathsContiguous(paths)) {
                paths = new TreePath[]{pPaths[0]};
                newCount = 1;
            }
            int validCount = 0;
            TreePath beginLeadPath = this.leadPath;
            Vector<TreeSpot> cPaths = new Vector<TreeSpot>(newCount + oldCount);
            this.leadPath = null;
            for (newCounter = 0; newCounter < newCount; ++newCounter) {
                boolean found = false;
                if (paths[newCounter] == null) continue;
                ++validCount;
                for (oldCounter = 0; oldCounter < oldCount; ++oldCounter) {
                    if (this.selection[oldCounter] == null || !this.selection[oldCounter].equals(paths[newCounter])) continue;
                    this.selection[oldCounter] = null;
                    oldCounter = oldCount;
                    found = true;
                }
                if (!found) {
                    cPaths.addElement(new TreeSpot(paths[newCounter], true));
                }
                if (this.leadPath != null) continue;
                this.leadPath = paths[newCounter];
            }
            for (oldCounter = 0; oldCounter < oldCount; ++oldCounter) {
                if (this.selection[oldCounter] == null) continue;
                cPaths.addElement(new TreeSpot(this.selection[oldCounter], false));
            }
            if (validCount == 0) {
                this.selection = null;
            } else if (validCount != newCount) {
                this.selection = new TreePath[validCount];
                validCount = 0;
                for (newCounter = 0; newCounter < newCount; ++newCounter) {
                    if (paths[newCounter] == null) continue;
                    this.selection[validCount++] = paths[newCounter];
                }
            } else {
                this.selection = new TreePath[paths.length];
                System.arraycopy(paths, 0, this.selection, 0, paths.length);
            }
            if (this.selection != null) {
                this.insureUniqueness();
            }
            this.updateLeadIndex();
            this.resetRowSelection();
            if (cPaths.size() > 0) {
                this.notifyPathChange(cPaths, beginLeadPath);
            }
        }
    }

    public String toString() {
        int selCount = this.getSelectionCount();
        StringBuffer retBuffer = new StringBuffer();
        int[] rows = this.rowMapper != null ? this.rowMapper.getRowsForPaths(this.selection) : null;
        retBuffer.append(this.getClass().getName() + " " + this.hashCode() + " [ ");
        for (int counter = 0; counter < selCount; ++counter) {
            if (rows != null) {
                retBuffer.append(this.selection[counter].toString() + "@" + Integer.toString(rows[counter]) + " ");
                continue;
            }
            retBuffer.append(this.selection[counter].toString() + " ");
        }
        retBuffer.append("]");
        return retBuffer.toString();
    }

    protected void updateLeadIndex() {
        if (this.leadPath != null) {
            if (this.selection == null) {
                this.leadPath = null;
                this.leadRow = -1;
                this.leadIndex = -1;
            } else {
                this.leadIndex = -1;
                this.leadRow = -1;
                for (int counter = this.selection.length - 1; counter >= 0; --counter) {
                    if (!this.selection[counter].equals(this.leadPath)) continue;
                    this.leadIndex = counter;
                    break;
                }
            }
        }
    }

    class TreeSpot {
        protected boolean isNew;
        protected TreePath path;

        TreeSpot(TreePath path, boolean isNew) {
            this.path = path;
            this.isNew = isNew;
        }
    }
}

