/*
 * Decompiled with CFR 0.152.
 */
package echopointng.ui.syncpeer;

import echopointng.ContentPaneEx;
import echopointng.EPNG;
import echopointng.HttpPaneEx;
import echopointng.able.BackgroundImageable;
import echopointng.ui.resource.Resources;
import echopointng.ui.syncpeer.AbstractEchoPointContainerPeer;
import echopointng.ui.util.CssStyleEx;
import echopointng.ui.util.Render;
import echopointng.ui.util.RenderingContext;
import nextapp.echo2.app.Component;
import nextapp.echo2.app.Extent;
import nextapp.echo2.app.Style;
import nextapp.echo2.app.update.ServerComponentUpdate;
import nextapp.echo2.webcontainer.ComponentSynchronizePeer;
import nextapp.echo2.webcontainer.ContainerInstance;
import nextapp.echo2.webcontainer.DomUpdateSupport;
import nextapp.echo2.webcontainer.PartialUpdateParticipant;
import nextapp.echo2.webcontainer.PropertyUpdateProcessor;
import nextapp.echo2.webcontainer.RenderContext;
import nextapp.echo2.webcontainer.SynchronizePeerFactory;
import nextapp.echo2.webcontainer.propertyrender.ExtentRender;
import nextapp.echo2.webrender.ServerMessage;
import nextapp.echo2.webrender.Service;
import nextapp.echo2.webrender.WebRenderServlet;
import nextapp.echo2.webrender.output.CssStyle;
import nextapp.echo2.webrender.service.JavaScriptService;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class ContainerExPeer
extends AbstractEchoPointContainerPeer
implements PropertyUpdateProcessor {
    public static final Service CONTAINEREX_SERVICE = JavaScriptService.forResource("EPNG.ContainerEx", "/echopointng/ui/resource/js/containerex.js");

    public ContainerExPeer() {
        this.partialUpdateManager.add("horizontalScroll", new PartialUpdateParticipant(){

            @Override
            public void renderProperty(RenderContext rc, ServerComponentUpdate update) {
                ContainerExPeer.this.renderScrollDirective(rc, update.getParent(), true);
            }

            @Override
            public boolean canRenderProperty(RenderContext rc, ServerComponentUpdate update) {
                return true;
            }
        });
        this.partialUpdateManager.add("verticalScroll", new PartialUpdateParticipant(){

            @Override
            public void renderProperty(RenderContext rc, ServerComponentUpdate update) {
                ContainerExPeer.this.renderScrollDirective(rc, update.getParent(), false);
            }

            @Override
            public boolean canRenderProperty(RenderContext rc, ServerComponentUpdate update) {
                return true;
            }
        });
    }

    @Override
    public void processPropertyUpdate(ContainerInstance ci, Component component, Element propertyElement) {
        if ("horizontalScroll".equals(propertyElement.getAttribute("name"))) {
            Extent newValue = ExtentRender.toExtent(propertyElement.getAttribute("value"));
            ci.getUpdateManager().getClientUpdateManager().setComponentProperty(component, "horizontalScroll", newValue);
        } else if ("verticalScroll".equals(propertyElement.getAttribute("name"))) {
            Extent newValue = ExtentRender.toExtent(propertyElement.getAttribute("value"));
            ci.getUpdateManager().getClientUpdateManager().setComponentProperty(component, "verticalScroll", newValue);
        }
    }

    @Override
    public void renderHtml(RenderingContext rc, Node parentNode, Component component) {
        Style fallbackStyle = EPNG.getFallBackStyle(component);
        CssStyleEx style = new CssStyleEx(component, fallbackStyle);
        Render.asBackgroundImageable(rc, style, (BackgroundImageable)((Object)component), fallbackStyle);
        if (component instanceof ContentPaneEx) {
            style.setAttribute("position", "absolute");
            style.setAttribute("width", "100%");
            style.setAttribute("height", "100%");
            style.setAttribute("overflow", "auto");
        }
        Render.layoutFix(rc, style);
        Element paneE = rc.createE("div");
        parentNode.appendChild(paneE);
        paneE.setAttribute("id", rc.getElementId());
        paneE.setAttribute("style", style.renderInline());
        rc.addStandardWebSupport(paneE);
        if (component instanceof HttpPaneEx) {
            style = new CssStyleEx();
            style.setAttribute("position", "relative");
            style.setAttribute("width", "100%");
            style.setAttribute("height", "100%");
            style.setAttribute("border-style", "none");
            Element iframeE = rc.createE("iframe");
            iframeE.setAttribute("style", style.renderInline());
            iframeE.setAttribute("src", (String)rc.getRP("uri", fallbackStyle));
            paneE.appendChild(iframeE);
        }
        Component[] visibleChildren = component.getVisibleComponents();
        for (int i = 0; i < visibleChildren.length; ++i) {
            this.renderReplaceableChild(rc, rc.getServerComponentUpdate(), paneE, visibleChildren[i]);
        }
        rc.addLibrary(Resources.EP_SCRIPT_SERVICE);
        rc.addLibrary(Resources.EP_STRETCH_SERVICE);
        rc.addLibrary(CONTAINEREX_SERVICE);
        this.renderInitDirective(rc, component);
    }

    @Override
    protected Element renderReplaceableChild(RenderContext rc, ServerComponentUpdate update, Node parentNode, Component child) {
        Element containerTagElement = parentNode.getOwnerDocument().createElement("div");
        String containerId = this.getContainerId(child);
        containerTagElement.setAttribute("id", containerId);
        parentNode.appendChild(containerTagElement);
        ComponentSynchronizePeer syncPeer = SynchronizePeerFactory.getPeerForComponent(child.getClass());
        if (syncPeer instanceof DomUpdateSupport) {
            ((DomUpdateSupport)((Object)syncPeer)).renderHtml(rc, update, containerTagElement, child);
        } else {
            syncPeer.renderAdd(rc, update, containerId, child);
        }
        CssStyle containerStyle = Render.itsDisplayLayoutData(rc, child);
        if (containerStyle.hasAttributes()) {
            Render.itsDisplayLayoutData(rc, child, containerTagElement);
            containerTagElement.setAttribute("style", containerStyle.renderInline());
        }
        return containerTagElement;
    }

    @Override
    public void renderDispose(RenderContext rc, ServerComponentUpdate update, Component component) {
        super.renderDispose(rc, update, component);
        rc.getServerMessage().addLibrary(Resources.EP_SCRIPT_SERVICE.getId());
        rc.getServerMessage().addLibrary(Resources.EP_STRETCH_SERVICE.getId());
        rc.getServerMessage().addLibrary(CONTAINEREX_SERVICE.getId());
        this.renderDisposeDirective(rc, component);
    }

    private void renderScrollDirective(RenderContext rc, Component component, boolean horizontal) {
        ServerMessage serverMessage = rc.getServerMessage();
        Element scrollElement = serverMessage.appendPartDirective("postupdate", "EPContainerEx.MessageProcessor", horizontal ? "scroll-horizontal" : "scroll-vertical");
        Extent position = (Extent)component.getRenderProperty(horizontal ? "horizontalScroll" : "verticalScroll", new Extent(0));
        scrollElement.setAttribute("eid", ContainerInstance.getElementId(component));
        scrollElement.setAttribute("position", ExtentRender.renderCssAttributeValue(position));
    }

    private void renderDisposeDirective(RenderContext rc, Component component) {
        ServerMessage serverMessage = rc.getServerMessage();
        Element itemizedUpdateElement = serverMessage.getItemizedDirective("preremove", "EPContainerEx.MessageProcessor", "dispose", new String[0], new String[0]);
        Element itemElement = serverMessage.getDocument().createElement("item");
        itemElement.setAttribute("eid", ContainerInstance.getElementId(component));
        itemizedUpdateElement.appendChild(itemElement);
    }

    private void renderInitDirective(RenderingContext rc, Component component) {
        Extent verticalScroll;
        String elementId = ContainerInstance.getElementId(component);
        ServerMessage serverMessage = rc.getServerMessage();
        Element itemizedUpdateElement = serverMessage.getItemizedDirective("postupdate", "EPContainerEx.MessageProcessor", "init", new String[0], new String[0]);
        Element itemElement = serverMessage.getDocument().createElement("item");
        itemElement.setAttribute("eid", elementId);
        Extent horizontalScroll = (Extent)component.getRenderProperty("horizontalScroll");
        if (horizontalScroll != null && horizontalScroll.getValue() != 0) {
            itemElement.setAttribute("horizontal-scroll", ExtentRender.renderCssAttributeValue(horizontalScroll));
        }
        if ((verticalScroll = (Extent)component.getRenderProperty("verticalScroll")) != null && verticalScroll.getValue() != 0) {
            itemElement.setAttribute("vertical-scroll", ExtentRender.renderCssAttributeValue(verticalScroll));
        }
        itemElement.setAttribute("heightStretched", String.valueOf(rc.getRP("heightStretched", false)));
        itemElement.setAttribute("minimumStretchedHeight", this.getExtentPixels(rc.getRP("minimumStretchedHeight", null)));
        itemElement.setAttribute("maximumStretchedHeight", this.getExtentPixels(rc.getRP("maximumStretchedHeight", null)));
        itemizedUpdateElement.appendChild(itemElement);
    }

    private String getExtentPixels(Object extent) {
        if (extent instanceof Extent) {
            return String.valueOf(((Extent)extent).getValue());
        }
        return null;
    }

    static {
        WebRenderServlet.getServiceRegistry().add(CONTAINEREX_SERVICE);
    }
}

