/*
 * Decompiled with CFR 0.152.
 */
package echopointng.ui.syncpeer;

import echopointng.EPNG;
import echopointng.ExpandableSection;
import echopointng.TitleBar;
import echopointng.model.ExpansionGroup;
import echopointng.ui.resource.Resources;
import echopointng.ui.syncpeer.AbstractEchoPointContainerPeer;
import echopointng.ui.syncpeer.TitleBarPeer;
import echopointng.ui.util.CssStyleEx;
import echopointng.ui.util.Render;
import echopointng.ui.util.RenderingContext;
import nextapp.echo2.app.Component;
import nextapp.echo2.app.Style;
import nextapp.echo2.app.update.ServerComponentUpdate;
import nextapp.echo2.webcontainer.ContainerInstance;
import nextapp.echo2.webcontainer.PartialUpdateParticipant;
import nextapp.echo2.webcontainer.PropertyUpdateProcessor;
import nextapp.echo2.webcontainer.RenderContext;
import nextapp.echo2.webcontainer.SynchronizePeerFactory;
import nextapp.echo2.webrender.ServerMessage;
import nextapp.echo2.webrender.Service;
import nextapp.echo2.webrender.WebRenderServlet;
import nextapp.echo2.webrender.service.JavaScriptService;
import nextapp.echo2.webrender.util.DomUtil;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class ExpandableSectionPeer
extends AbstractEchoPointContainerPeer
implements PropertyUpdateProcessor {
    public static final Service ES_SERVICE = JavaScriptService.forResource("EPNG.ExpandableSection", "/echopointng/ui/resource/js/expandablesection.js");

    public ExpandableSectionPeer() {
        this.partialUpdateManager.add("expanded", new PartialUpdateParticipant(){

            @Override
            public boolean canRenderProperty(RenderContext rc, ServerComponentUpdate update) {
                return true;
            }

            @Override
            public void renderProperty(RenderContext rc, ServerComponentUpdate update) {
                ExpandableSection es = (ExpandableSection)update.getParent();
                boolean isExpanded = es.isExpanded();
                Element itemizedUpdateElement = rc.getServerMessage().getItemizedDirective("postupdate", "EPExpandableSection.MessageProcessor", "expansion", new String[0], new String[0]);
                Element itemElement = rc.getServerMessage().getDocument().createElement("item");
                itemElement.setAttribute("eid", ContainerInstance.getElementId(es));
                itemElement.setAttribute("expanded", String.valueOf(isExpanded));
                itemizedUpdateElement.appendChild(itemElement);
            }
        });
    }

    @Override
    public void processPropertyUpdate(ContainerInstance ci, Component component, Element propertyElement) {
        String propertyName = propertyElement.getAttribute("name");
        if ("expanded".equals(propertyName)) {
            String propertyValue = DomUtil.getElementText(propertyElement);
            ci.getUpdateManager().getClientUpdateManager().setComponentProperty(component, "expanded", Boolean.valueOf(propertyValue));
        }
    }

    @Override
    public boolean renderUpdate(RenderContext rc, ServerComponentUpdate update, String targetId) {
        return super.renderUpdate(rc, update, targetId);
    }

    @Override
    public void renderHtml(RenderingContext rc, Node parent, Component component) {
        Style fallbackStyle = EPNG.getFallBackStyle(component);
        ExpandableSection es = (ExpandableSection)component;
        this.createInitDirective(rc, es, fallbackStyle);
        rc.addLibrary(Resources.EP_SCRIPT_SERVICE);
        rc.addLibrary(ES_SERVICE);
        String elementId = rc.getElementId();
        CssStyleEx style = new CssStyleEx(component, fallbackStyle);
        Element divOuter = rc.createE("div");
        divOuter.setAttribute("id", elementId);
        divOuter.setAttribute("style", style.renderInline());
        rc.addStandardWebSupport(divOuter);
        parent.appendChild(divOuter);
        Element divTitleBar = rc.createE("div");
        divOuter.appendChild(divTitleBar);
        TitleBar tb = (TitleBar)rc.getRP("titleBar", fallbackStyle);
        boolean isExpanded = es.isExpanded();
        if (tb != null && tb.isRenderVisible()) {
            divTitleBar.setAttribute("id", elementId + "|TitleBar");
            this.renderTitleBarChild(rc, rc.getServerComponentUpdate(), divTitleBar, tb, elementId);
        }
        Element divContent = rc.createE("div");
        divOuter.appendChild(divContent);
        divContent.setAttribute("id", elementId + "|Content");
        CssStyleEx styleContent = new CssStyleEx();
        if (!isExpanded) {
            styleContent.setAttribute("position", "relative");
            styleContent.setAttribute("display", "none");
        } else {
            styleContent.setAttribute("position", "relative");
            styleContent.setAttribute("display", "block");
        }
        Render.layoutFix(rc, styleContent);
        divContent.setAttribute("style", styleContent.renderInline());
        Component[] children = component.getVisibleComponents();
        for (int i = 0; i < children.length; ++i) {
            if (children[i] == tb) continue;
            this.renderReplaceableChild(rc, rc.getServerComponentUpdate(), divContent, children[i]);
        }
    }

    @Override
    public void renderDispose(RenderContext rc, ServerComponentUpdate update, Component component) {
        super.renderDispose(rc, update, component);
        rc.getServerMessage().addLibrary(Resources.EP_SCRIPT_SERVICE.getId());
        rc.getServerMessage().addLibrary(ES_SERVICE.getId());
        this.createDisposeDirective(rc.getServerMessage(), component);
    }

    protected void createInitDirective(RenderingContext rc, ExpandableSection es, Style fallbackStyle) {
        TitleBar tb;
        Element itemizedUpdateElement = rc.getServerMessage().getItemizedDirective("postupdate", "EPExpandableSection.MessageProcessor", "init", new String[0], new String[0]);
        Element itemElement = rc.getServerMessage().getDocument().createElement("item");
        itemElement.setAttribute("eid", rc.getElementId());
        itemElement.setAttribute("expanded", String.valueOf(es.isExpanded()));
        ExpansionGroup group = (ExpansionGroup)rc.getRP("expansionGroup", fallbackStyle);
        if (group != null) {
            itemElement.setAttribute("groupId", group.getRenderId());
            itemElement.setAttribute("accordionMode", String.valueOf(group.isAccordionMode()));
        }
        if ((tb = (TitleBar)rc.getRP("titleBar", fallbackStyle)) != null) {
            itemElement.setAttribute("titleBarId", ContainerInstance.getElementId(tb));
        }
        itemizedUpdateElement.appendChild(itemElement);
    }

    protected void createDisposeDirective(ServerMessage serverMessage, Component component) {
        Element itemizedUpdateElement = serverMessage.getItemizedDirective("preremove", "EPExpandableSection.MessageProcessor", "dispose", new String[0], new String[0]);
        Element itemElement = serverMessage.getDocument().createElement("item");
        itemElement.setAttribute("eid", ContainerInstance.getElementId(component));
        itemizedUpdateElement.appendChild(itemElement);
    }

    protected void renderTitleBarChild(RenderingContext rc, ServerComponentUpdate update, Node parentNode, TitleBar child, String partnerComponentId) {
        Element containerDivElement = parentNode.getOwnerDocument().createElement("bdo");
        String containerId = this.getContainerId(child);
        containerDivElement.setAttribute("id", containerId);
        parentNode.appendChild(containerDivElement);
        TitleBarPeer tbPeer = (TitleBarPeer)SynchronizePeerFactory.getPeerForComponent(child.getClass());
        tbPeer.renderHtml(rc, rc.getServerComponentUpdate(), containerDivElement, child, partnerComponentId);
    }

    static {
        WebRenderServlet.getServiceRegistry().add(ES_SERVICE);
    }
}

