/*
 * Decompiled with CFR 0.152.
 */
package echopointng.ui.syncpeer;

import echopointng.EPNG;
import echopointng.LiveTable;
import echopointng.table.LiveTableRenderer;
import echopointng.ui.resource.Resources;
import echopointng.ui.syncpeer.AbstractEchoPointContainerPeer;
import echopointng.ui.util.CssStyleEx;
import echopointng.ui.util.RenderingContext;
import nextapp.echo2.app.Border;
import nextapp.echo2.app.Component;
import nextapp.echo2.app.Extent;
import nextapp.echo2.app.ImageReference;
import nextapp.echo2.app.Insets;
import nextapp.echo2.app.LayoutData;
import nextapp.echo2.app.Style;
import nextapp.echo2.app.layout.TableLayoutData;
import nextapp.echo2.app.table.TableColumnModel;
import nextapp.echo2.app.update.ServerComponentUpdate;
import nextapp.echo2.webcontainer.ActionProcessor;
import nextapp.echo2.webcontainer.ComponentSynchronizePeer;
import nextapp.echo2.webcontainer.ContainerInstance;
import nextapp.echo2.webcontainer.DomUpdateSupport;
import nextapp.echo2.webcontainer.RenderContext;
import nextapp.echo2.webcontainer.SynchronizePeerFactory;
import nextapp.echo2.webcontainer.image.ImageRenderSupport;
import nextapp.echo2.webcontainer.propertyrender.BorderRender;
import nextapp.echo2.webcontainer.propertyrender.CellLayoutDataRender;
import nextapp.echo2.webcontainer.propertyrender.ExtentRender;
import nextapp.echo2.webcontainer.propertyrender.InsetsRender;
import nextapp.echo2.webrender.ServerMessage;
import nextapp.echo2.webrender.Service;
import nextapp.echo2.webrender.WebRenderServlet;
import nextapp.echo2.webrender.output.CssStyle;
import nextapp.echo2.webrender.service.JavaScriptService;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class LiveTablePeer
extends AbstractEchoPointContainerPeer
implements ActionProcessor {
    public static final Service LIVETABLE_SERVICE = JavaScriptService.forResource("EPNG.LiveTableJS", "/echopointng/ui/resource/js/livetable.js");

    protected void createDisposeDirective(ServerMessage serverMessage, Component component) {
        Element itemizedUpdateElement = serverMessage.getItemizedDirective("preremove", "EPLiveTable.MessageProcessor", "dispose", new String[0], new String[0]);
        Element itemElement = serverMessage.getDocument().createElement("item");
        itemElement.setAttribute("eid", ContainerInstance.getElementId(component));
        itemizedUpdateElement.appendChild(itemElement);
    }

    protected void createInitDirective(RenderingContext rc, LiveTable liveTable, Style fallbackStyle) {
        Element itemizedUpdateElement = rc.getServerMessage().getItemizedDirective("postupdate", "EPLiveTable.MessageProcessor", "init", new String[0], new String[0]);
        LiveTableRenderer liveTableRenderer = (LiveTableRenderer)rc.getRP("renderer", fallbackStyle);
        Document doc = rc.getServerMessage().getDocument();
        int pageFetchSize = rc.getRP("pageFetchSize", fallbackStyle, 2);
        int rowsPerPage = rc.getRP("rowsPerPage", fallbackStyle, 100);
        int totalRows = liveTable.getModel().getRowCount();
        Element itemElement = doc.createElement("item");
        itemElement.setAttribute("eid", rc.getElementId());
        itemElement.setAttribute("enabled", String.valueOf(liveTable.isRenderEnabled()));
        itemElement.setAttribute("rowsPerPage", String.valueOf(rowsPerPage));
        itemElement.setAttribute("totalRows", String.valueOf(totalRows));
        itemElement.setAttribute("pageFetchSize", String.valueOf(pageFetchSize));
        itemElement.setAttribute("isHeaderVisible", String.valueOf(liveTable.isHeaderVisible()));
        Element styles = doc.createElement("styles");
        itemElement.appendChild(styles);
        liveTableRenderer.renderStyles(liveTable, styles);
        boolean rolloverEnabled = rc.getRP("rolloverEnabled", fallbackStyle, false);
        itemElement.setAttribute("rolloverEnabled", String.valueOf(rolloverEnabled));
        if (rolloverEnabled) {
            String rolloverStyleName = liveTableRenderer.renderRolloverStyle(liveTable, styles, rc);
            itemElement.setAttribute("rolloverStyleName", String.valueOf(rolloverStyleName));
        }
        boolean selectionEnabled = rc.getRP("selectionEnabled", fallbackStyle, false);
        itemElement.setAttribute("selectionEnabled", String.valueOf(selectionEnabled));
        if (selectionEnabled) {
            String selectionStyleName = liveTableRenderer.renderSelectionStyle(liveTable, styles, rc);
            itemElement.setAttribute("selectionStyleName", String.valueOf(selectionStyleName));
        }
        Element emptyRow = doc.createElement("emptyRow");
        itemElement.appendChild(emptyRow);
        liveTableRenderer.renderEmptyRow(liveTable, emptyRow);
        itemizedUpdateElement.appendChild(itemElement);
    }

    private TableLayoutData getLayoutData(Component child) {
        LayoutData layoutData = (LayoutData)child.getRenderProperty("layoutData");
        if (layoutData == null) {
            return null;
        }
        if (layoutData instanceof TableLayoutData) {
            return (TableLayoutData)layoutData;
        }
        throw new RuntimeException("Invalid LayoutData for LiveTable Child: " + layoutData.getClass().getName());
    }

    @Override
    public void processAction(ContainerInstance ci, Component component, Element actionElement) {
        String actionName = actionElement.getAttribute("name");
        String actionValue = actionElement.getAttribute("value");
        ci.getUpdateManager().getClientUpdateManager().setComponentAction(component, actionName, actionValue);
    }

    @Override
    public void renderDispose(RenderContext rc, ServerComponentUpdate update, Component component) {
        super.renderDispose(rc, update, component);
        rc.getServerMessage().addLibrary(Resources.EP_SCRIPT_SERVICE.getId());
        rc.getServerMessage().addLibrary(LIVETABLE_SERVICE.getId());
        this.createDisposeDirective(rc.getServerMessage(), component);
    }

    private void renderHeaderRow(RenderingContext rc, Element tbodyElement, LiveTable liveTable, String defaultInsetsAttributeValue) {
        Document document = tbodyElement.getOwnerDocument();
        String elementId = ContainerInstance.getElementId(liveTable);
        Extent rowHeight = (Extent)EPNG.getRP(liveTable, "rowsHeight");
        String heightCss = "height:" + ExtentRender.renderCssAttributeValue(rowHeight) + ";";
        Element trElement = document.createElement("tr");
        tbodyElement.appendChild(trElement);
        trElement.setAttribute("id", elementId + "_tr_header");
        trElement.setAttribute("style", heightCss);
        int columns = liveTable.getColumnModel().getColumnCount();
        for (int columnIndex = 0; columnIndex < columns; ++columnIndex) {
            Component childComponent = liveTable.getCellComponent(columnIndex, -1);
            Element tdElement = document.createElement("td");
            tdElement.setAttribute("id", elementId + "header_cell_" + childComponent.getRenderId());
            CssStyle tdCssStyle = new CssStyle();
            tdCssStyle.setAttribute("border-collapse", "collapse");
            BorderRender.renderToStyle(tdCssStyle, (Border)EPNG.getRP(liveTable, "border"));
            CellLayoutDataRender.renderToElementAndStyle(tdElement, tdCssStyle, childComponent, this.getLayoutData(childComponent), defaultInsetsAttributeValue);
            ImageRenderSupport irs = new ImageRenderSupport(){

                @Override
                public ImageReference getImage(Component component, String imageId) {
                    return CellLayoutDataRender.getCellLayoutDataBackgroundImage(component, imageId);
                }
            };
            CellLayoutDataRender.renderBackgroundImageToStyle(tdCssStyle, rc, irs, liveTable, childComponent);
            tdElement.setAttribute("style", tdCssStyle.renderInline());
            trElement.appendChild(tdElement);
            if (!childComponent.isRenderVisible()) continue;
            ComponentSynchronizePeer syncPeer = SynchronizePeerFactory.getPeerForComponent(childComponent.getClass());
            if (syncPeer instanceof DomUpdateSupport) {
                ((DomUpdateSupport)((Object)syncPeer)).renderHtml(rc, rc.getServerComponentUpdate(), tdElement, childComponent);
                continue;
            }
            syncPeer.renderAdd(rc, rc.getServerComponentUpdate(), this.getContainerId(childComponent), childComponent);
        }
    }

    @Override
    public void renderHtml(RenderingContext rc, Node parent, Component component) {
        Extent borderSize;
        Style fallbackStyle = EPNG.getFallBackStyle(component);
        LiveTable liveTable = (LiveTable)component;
        LiveTableRenderer liveTableRenderer = (LiveTableRenderer)rc.getRP("renderer", fallbackStyle);
        this.createInitDirective(rc, liveTable, fallbackStyle);
        rc.addLibrary(Resources.EP_SCRIPT_SERVICE);
        rc.addLibrary(LIVETABLE_SERVICE);
        String elementId = rc.getElementId();
        CssStyleEx style = new CssStyleEx(component, fallbackStyle);
        Element scrollerDivE = rc.createE("div");
        scrollerDivE.setAttribute("id", elementId);
        scrollerDivE.setAttribute("style", style.renderInline());
        rc.addStandardWebSupport(scrollerDivE);
        parent.appendChild(scrollerDivE);
        Element tableE = rc.createE("table");
        scrollerDivE.appendChild(tableE);
        tableE.setAttribute("cellpadding", "0");
        tableE.setAttribute("cellspacing", "0");
        tableE.setAttribute("border", "0");
        CssStyle tableCssStyle = new CssStyle();
        tableCssStyle.setAttribute("border-collapse", "collapse");
        tableCssStyle.setAttribute("width", "95%");
        Insets tableInsets = (Insets)rc.getRP("insets", fallbackStyle);
        String defaultInsetsAttributeValue = tableInsets == null ? "0px" : InsetsRender.renderCssAttributeValue(tableInsets);
        Border border = (Border)rc.getRP("border", fallbackStyle);
        Extent extent = borderSize = border == null ? null : border.getSize();
        if (rc.getRP("selectionEnabled", fallbackStyle, false)) {
            tableCssStyle.setAttribute("cursor", "pointer");
        }
        BorderRender.renderToStyle(tableCssStyle, border);
        if (borderSize != null && !rc.getContainerInstance().getClientProperties().getBoolean("quirkCssBorderCollapseInside")) {
            tableCssStyle.setAttribute("margin", ExtentRender.renderCssAttributeValueHalf(borderSize));
        }
        tableE.setAttribute("style", tableCssStyle.renderInline());
        TableColumnModel columnModel = liveTable.getColumnModel();
        int columnCount = columnModel.getColumnCount();
        boolean someColumnsHaveWidths = false;
        for (int i = 0; i < columnCount; ++i) {
            if (columnModel.getColumn(i).getWidth() == null) continue;
            someColumnsHaveWidths = true;
        }
        int rowsPerPage = rc.getRP("rowsPerPage", fallbackStyle, 100);
        int pageFetchSize = rc.getRP("pageFetchSize", fallbackStyle, 2);
        for (int i = 0; i < pageFetchSize; ++i) {
            Element tbodyE = rc.createE("tbody");
            tableE.appendChild(tbodyE);
            int startRow = i * rowsPerPage;
            int endRow = startRow + rowsPerPage;
            liveTableRenderer.renderRows(liveTable, tbodyE, startRow, endRow);
        }
    }

    @Override
    public boolean renderUpdate(RenderContext rc, ServerComponentUpdate update, String targetId) {
        return this.renderUpdateBaseImpl(rc, update, targetId, true);
    }

    static {
        WebRenderServlet.getServiceRegistry().add(LIVETABLE_SERVICE);
    }
}

