/*
 * Decompiled with CFR 0.152.
 */
package echopointng.ui.syncpeer;

import echopointng.EPNG;
import echopointng.ui.resource.Resources;
import echopointng.ui.util.RenderingContext;
import nextapp.echo2.app.Component;
import nextapp.echo2.app.Style;
import nextapp.echo2.app.update.ServerComponentUpdate;
import nextapp.echo2.webcontainer.ActionProcessor;
import nextapp.echo2.webcontainer.ComponentSynchronizePeer;
import nextapp.echo2.webcontainer.ContainerInstance;
import nextapp.echo2.webcontainer.PartialUpdateManager;
import nextapp.echo2.webcontainer.PartialUpdateParticipant;
import nextapp.echo2.webcontainer.PropertyUpdateProcessor;
import nextapp.echo2.webcontainer.RenderContext;
import nextapp.echo2.webrender.ServerMessage;
import nextapp.echo2.webrender.Service;
import nextapp.echo2.webrender.WebRenderServlet;
import nextapp.echo2.webrender.service.JavaScriptService;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class NativeWindowPeer
implements ComponentSynchronizePeer,
PropertyUpdateProcessor,
ActionProcessor {
    public static final Service NATIVE_WINDOW_SERVICE = JavaScriptService.forResource("EPNG.NativeWindow", "/echopointng/ui/resource/js/nativewindow.js");
    private PartialUpdateManager partialUpdateManager = new PartialUpdateManager();

    public NativeWindowPeer() {
        PartialUpdateParticipant updateParticipant = new PartialUpdateParticipant(){

            @Override
            public boolean canRenderProperty(RenderContext rc, ServerComponentUpdate update) {
                return true;
            }

            @Override
            public void renderProperty(RenderContext rcIn, ServerComponentUpdate update) {
                Component component = update.getParent();
                RenderingContext rc = new RenderingContext(rcIn, update, component);
                Style fallbackStyle = EPNG.getFallBackStyle(component);
                Document doc = rc.getServerMessage().getDocument();
                Element itemizedUpdateElement = rc.getServerMessage().getItemizedDirective("postupdate", "EPNativeWindow.MessageProcessor", "update", new String[0], new String[0]);
                Element itemElement = doc.createElement("item");
                itemElement.setAttribute("eid", ContainerInstance.getElementId(component));
                String[] propertyNames = update.getUpdatedPropertyNames();
                for (int i = 0; i < propertyNames.length; ++i) {
                    String propertyName = propertyNames[i];
                    Object newValue = rc.getRP(propertyName, fallbackStyle, null);
                    if (newValue == null) continue;
                    itemElement.setAttribute(propertyName, String.valueOf(newValue));
                }
                itemizedUpdateElement.appendChild(itemElement);
            }
        };
        this.partialUpdateManager.add("dependent", updateParticipant);
        this.partialUpdateManager.add("modal", updateParticipant);
        this.partialUpdateManager.add("open", updateParticipant);
        this.partialUpdateManager.add("URL", updateParticipant);
        this.partialUpdateManager.add("left", updateParticipant);
        this.partialUpdateManager.add("top", updateParticipant);
        this.partialUpdateManager.add("height", updateParticipant);
        this.partialUpdateManager.add("width", updateParticipant);
        this.partialUpdateManager.add("centered", updateParticipant);
        this.partialUpdateManager.add("features", updateParticipant);
    }

    @Override
    public void processPropertyUpdate(ContainerInstance ci, Component component, Element propertyElement) {
        if ("open".equals(propertyElement.getAttribute("name"))) {
            String newValue = propertyElement.getAttribute("value");
            ci.getUpdateManager().getClientUpdateManager().setComponentProperty(component, "open", new Boolean(newValue));
        }
    }

    @Override
    public void processAction(ContainerInstance ci, Component component, Element actionElement) {
        String actionName = actionElement.getAttribute("name");
        String actionValue = actionElement.getAttribute("value");
        ci.getUpdateManager().getClientUpdateManager().setComponentAction(component, actionName, actionValue);
    }

    @Override
    public String getContainerId(Component child) {
        throw new IllegalStateException("NativeWindowPeer does not support children directly.  Use AbstractEchoPointContainerPeer instead");
    }

    @Override
    public void renderAdd(RenderContext rc, ServerComponentUpdate update, String targetId, Component component) {
        this.createInitDirective(new RenderingContext(rc, update, component), component);
    }

    @Override
    public boolean renderUpdate(RenderContext rc, ServerComponentUpdate update, String targetId) {
        if (update.hasUpdatedProperties() && this.partialUpdateManager.canProcess(rc, update)) {
            this.partialUpdateManager.process(rc, update);
        }
        return true;
    }

    private void createInitDirective(RenderingContext rc, Component component) {
        Style fallbackStyle = EPNG.getFallBackStyle(component);
        ServerMessage serverMessage = rc.getServerMessage();
        serverMessage.addLibrary(Resources.EP_SCRIPT_SERVICE.getId());
        serverMessage.addLibrary(NATIVE_WINDOW_SERVICE.getId());
        Element itemizedUpdateElement = serverMessage.getItemizedDirective("postupdate", "EPNativeWindow.MessageProcessor", "init", new String[0], new String[0]);
        Element itemElement = serverMessage.getDocument().createElement("item");
        itemElement.setAttribute("eid", ContainerInstance.getElementId(component));
        itemElement.setAttribute("dependent", rc.getRP("dependent", fallbackStyle, false) ? "true" : "false");
        itemElement.setAttribute("modal", rc.getRP("modal", fallbackStyle, false) ? "true" : "false");
        itemElement.setAttribute("open", rc.getRP("open", fallbackStyle, false) ? "true" : "false");
        itemElement.setAttribute("centered", rc.getRP("centered", fallbackStyle, false) ? "true" : "false");
        itemElement.setAttribute("features", String.valueOf(rc.getRP("features", fallbackStyle, 0)));
        itemElement.setAttribute("url", (String)rc.getRP("URL", ""));
        if (rc.getRP("left") != null) {
            itemElement.setAttribute("left", (String)rc.getRP("left"));
        }
        if (rc.getRP("top") != null) {
            itemElement.setAttribute("top", (String)rc.getRP("top"));
        }
        if (rc.getRP("height") != null) {
            itemElement.setAttribute("height", (String)rc.getRP("height"));
        }
        if (rc.getRP("width") != null) {
            itemElement.setAttribute("width", (String)rc.getRP("width"));
        }
        itemizedUpdateElement.appendChild(itemElement);
    }

    @Override
    public void renderDispose(RenderContext rc, ServerComponentUpdate update, Component component) {
        rc.getServerMessage().addLibrary(Resources.EP_SCRIPT_SERVICE.getId());
        rc.getServerMessage().addLibrary(NATIVE_WINDOW_SERVICE.getId());
        this.createDisposeDirective(rc.getServerMessage(), component);
    }

    private void createDisposeDirective(ServerMessage serverMessage, Component component) {
        Element itemizedUpdateElement = serverMessage.getItemizedDirective("preremove", "EPNativeWindow.MessageProcessor", "dispose", new String[0], new String[0]);
        Element itemElement = serverMessage.getDocument().createElement("item");
        itemElement.setAttribute("eid", ContainerInstance.getElementId(component));
        itemizedUpdateElement.appendChild(itemElement);
    }

    static {
        WebRenderServlet.getServiceRegistry().add(NATIVE_WINDOW_SERVICE);
    }
}

