/*
 * Decompiled with CFR 0.152.
 */
package echopointng.ui.syncpeer;

import echopointng.EPNG;
import echopointng.Slider;
import echopointng.ui.resource.Resources;
import echopointng.ui.syncpeer.AbstractEchoPointContainerPeer;
import echopointng.ui.util.CssStyleEx;
import echopointng.ui.util.Render;
import echopointng.ui.util.RenderingContext;
import nextapp.echo2.app.Color;
import nextapp.echo2.app.Component;
import nextapp.echo2.app.Style;
import nextapp.echo2.app.update.ServerComponentUpdate;
import nextapp.echo2.webcontainer.ActionProcessor;
import nextapp.echo2.webcontainer.ContainerInstance;
import nextapp.echo2.webcontainer.PartialUpdateParticipant;
import nextapp.echo2.webcontainer.PropertyUpdateProcessor;
import nextapp.echo2.webcontainer.RenderContext;
import nextapp.echo2.webrender.ServerMessage;
import nextapp.echo2.webrender.Service;
import nextapp.echo2.webrender.ServiceRegistry;
import nextapp.echo2.webrender.WebRenderServlet;
import nextapp.echo2.webrender.service.JavaScriptService;
import nextapp.echo2.webrender.service.StaticBinaryService;
import nextapp.echo2.webrender.util.DomUtil;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class SliderPeer
extends AbstractEchoPointContainerPeer
implements PropertyUpdateProcessor,
ActionProcessor {
    public static final Service SLIDER_SERVICE = JavaScriptService.forResource("EPNG.Slider", "/echopointng/ui/resource/js/slider.js");
    private static final Service SLIDER_HORZ_IMAGE = StaticBinaryService.forResource("EPNG.Slider.HorzImage", "image/gif", "/echopointng/ui/resource/images/slider_horz_handle.gif");
    private static final Service SLIDER_VERT_IMAGE = StaticBinaryService.forResource("EPNG.Slider.VertImage", "image/gif", "/echopointng/ui/resource/images/slider_vert_handle.gif");
    private static final Service SLIDER_HORZ_IMAGE_ROLLOVER = StaticBinaryService.forResource("EPNG.Slider.HorzRolloverImage", "image/gif", "/echopointng/ui/resource/images/slider_horz_handle_rollover.gif");
    private static final Service SLIDER_VERT_IMAGE_ROLLOVER = StaticBinaryService.forResource("EPNG.Slider.VertRolloverImage", "image/gif", "/echopointng/ui/resource/images/slider_vert_handle_rollover.gif");

    public SliderPeer() {
        this.partialUpdateManager.add("value", new PartialUpdateParticipant(){

            @Override
            public boolean canRenderProperty(RenderContext rc, ServerComponentUpdate update) {
                return true;
            }

            @Override
            public void renderProperty(RenderContext rc, ServerComponentUpdate update) {
                Slider slider = (Slider)update.getParent();
                int value = slider.getValue();
                Element itemizedUpdateElement = rc.getServerMessage().getItemizedDirective("postupdate", "EPSlider.MessageProcessor", "value", new String[0], new String[0]);
                Element itemElement = rc.getServerMessage().getDocument().createElement("item");
                itemElement.setAttribute("eid", ContainerInstance.getElementId(slider));
                itemElement.setAttribute("value", String.valueOf(value));
                itemizedUpdateElement.appendChild(itemElement);
            }
        });
    }

    @Override
    public void processPropertyUpdate(ContainerInstance ci, Component component, Element propertyElement) {
        String propertyName = propertyElement.getAttribute("name");
        if ("value".equals(propertyName)) {
            String propertyValue = DomUtil.getElementText(propertyElement);
            ci.getUpdateManager().getClientUpdateManager().setComponentProperty(component, "value", Integer.valueOf(propertyValue));
        }
    }

    @Override
    public void processAction(ContainerInstance ci, Component component, Element actionElement) {
        String value = actionElement.getAttribute("value");
        ci.getUpdateManager().getClientUpdateManager().setComponentProperty(component, "value", Integer.valueOf(value));
    }

    @Override
    public boolean renderUpdate(RenderContext rc, ServerComponentUpdate update, String targetId) {
        return this.renderUpdateBaseImpl(rc, update, targetId, true);
    }

    @Override
    public void renderHtml(RenderingContext rc, Node parent, Component component) {
        String handleURI;
        Style fallbackStyle = EPNG.getFallBackStyle(component);
        Slider slider = (Slider)component;
        this.createInitDirective(rc, slider, fallbackStyle);
        rc.addLibrary(Resources.EP_SCRIPT_SERVICE);
        rc.addLibrary(Resources.EP_DRAG_SERVICE);
        rc.addLibrary(SLIDER_SERVICE);
        int orientation = rc.getRP("orientation", fallbackStyle, 0);
        String elementId = rc.getElementId();
        CssStyleEx cssStyle = new CssStyleEx();
        cssStyle.setAttribute("position", "relative");
        Render.asWidthable(cssStyle, slider, fallbackStyle);
        Render.asHeightable(cssStyle, slider, fallbackStyle);
        Render.asMouseCursorable(cssStyle, slider, fallbackStyle);
        Element divOuter = rc.createE("div");
        parent.appendChild(divOuter);
        divOuter.setAttribute("id", elementId);
        divOuter.setAttribute("style", cssStyle.renderInline());
        rc.addStandardWebSupport(divOuter);
        cssStyle = new CssStyleEx();
        Render.asWidthable(cssStyle, slider, fallbackStyle);
        Render.asHeightable(cssStyle, slider, fallbackStyle);
        Render.asBorderable(cssStyle, slider, fallbackStyle);
        cssStyle.setBackground((Color)rc.getRP("background", fallbackStyle));
        cssStyle.setAttribute("position", "absolute");
        if (orientation == 0) {
            cssStyle.setAttribute("bottom", "0px");
        } else {
            cssStyle.setAttribute("left", "0px");
        }
        Render.layoutFix(rc, cssStyle);
        Element divRail = rc.createE("div");
        divOuter.appendChild(divRail);
        divRail.setAttribute("id", elementId + "|Rail");
        divRail.setAttribute("style", cssStyle.renderInline());
        divRail.appendChild(rc.createE("span"));
        cssStyle = new CssStyleEx();
        cssStyle.setAttribute("position", "absolute");
        cssStyle.setAttribute("z-index", "1");
        cssStyle.setAttribute("float", "left");
        cssStyle.setAttribute("border", "none");
        if (orientation == 0) {
            handleURI = rc.getContainerInstance().getServiceUri(SLIDER_HORZ_IMAGE);
            cssStyle.setAttribute("bottom", "-5px");
            cssStyle.setAttribute("left", "-5px");
            cssStyle.setAttribute("width", "11px");
            cssStyle.setAttribute("height", "21px");
        } else {
            handleURI = rc.getContainerInstance().getServiceUri(SLIDER_VERT_IMAGE);
            cssStyle.setAttribute("left", "-5px");
            cssStyle.setAttribute("top", "-5px");
            cssStyle.setAttribute("width", "21px");
            cssStyle.setAttribute("height", "11px");
        }
        Render.layoutFix(rc, cssStyle);
        Element handleE = rc.createE("img");
        divOuter.appendChild(handleE);
        handleE.setAttribute("id", elementId + "|Handle");
        handleE.setAttribute("src", handleURI);
        handleE.setAttribute("style", cssStyle.renderInline());
        cssStyle = new CssStyleEx();
        cssStyle.setAttribute("position", "absolute");
        cssStyle.setAttribute("z-index", "2");
        cssStyle.setAttribute("width", "50px");
        cssStyle.setAttribute("text-align", "center");
        cssStyle.setAttribute("display", "none");
        cssStyle.setAttribute("visibility", "none");
        cssStyle.setAttribute("background-color", "#FFFFE0");
        cssStyle.setAttribute("border", "1px black solid");
        cssStyle.setAttribute("padding", "2px");
        cssStyle.setAttribute("font-size", "8pt");
        Render.layoutFix(rc, cssStyle);
        Element divInfo = rc.createE("div");
        divOuter.appendChild(divInfo);
        divInfo.setAttribute("id", elementId + "|Info");
        divInfo.setAttribute("style", cssStyle.renderInline());
    }

    @Override
    public void renderDispose(RenderContext rc, ServerComponentUpdate update, Component component) {
        super.renderDispose(rc, update, component);
        rc.getServerMessage().addLibrary(Resources.EP_SCRIPT_SERVICE.getId());
        rc.getServerMessage().addLibrary(SLIDER_SERVICE.getId());
        this.createDisposeDirective(rc.getServerMessage(), component);
    }

    protected void createInitDirective(RenderingContext rc, Component component, Style fallbackStyle) {
        Slider slider = (Slider)component;
        int orientation = rc.getRP("orientation", fallbackStyle, 0);
        Element itemizedUpdateElement = rc.getServerMessage().getItemizedDirective("postupdate", "EPSlider.MessageProcessor", "init", new String[0], new String[0]);
        Element itemElement = rc.getServerMessage().getDocument().createElement("item");
        itemElement.setAttribute("eid", rc.getElementId());
        itemElement.setAttribute("enabled", String.valueOf(component.isRenderEnabled()));
        itemElement.setAttribute("min", String.valueOf(slider.getMinimum()));
        itemElement.setAttribute("max", String.valueOf(slider.getMaximum()));
        itemElement.setAttribute("horizontal", String.valueOf(orientation == 0));
        itemElement.setAttribute("value", String.valueOf(slider.getValue()));
        itemElement.setAttribute("valueRatio", String.valueOf(rc.getRP("valueRatio", fallbackStyle, 1.0)));
        itemElement.setAttribute("valueDecimalPlaces", String.valueOf(rc.getRP("valueRatio", fallbackStyle, 0)));
        itemElement.setAttribute("immediateNotification", String.valueOf(rc.getRP("immediateNotification", fallbackStyle, false)));
        if (orientation == 0) {
            String handleURI = rc.getContainerInstance().getServiceUri(SLIDER_HORZ_IMAGE);
            itemElement.setAttribute("handleURI", handleURI);
            handleURI = rc.getContainerInstance().getServiceUri(SLIDER_HORZ_IMAGE_ROLLOVER);
            itemElement.setAttribute("handleRolloverURI", handleURI);
        } else {
            String handleURI = rc.getContainerInstance().getServiceUri(SLIDER_VERT_IMAGE);
            itemElement.setAttribute("handleURI", handleURI);
            handleURI = rc.getContainerInstance().getServiceUri(SLIDER_VERT_IMAGE_ROLLOVER);
            itemElement.setAttribute("handleRolloverURI", handleURI);
        }
        itemizedUpdateElement.appendChild(itemElement);
    }

    protected void createDisposeDirective(ServerMessage serverMessage, Component component) {
        Element itemizedUpdateElement = serverMessage.getItemizedDirective("preremove", "EPSlider.MessageProcessor", "dispose", new String[0], new String[0]);
        Element itemElement = serverMessage.getDocument().createElement("item");
        itemElement.setAttribute("eid", ContainerInstance.getElementId(component));
        itemizedUpdateElement.appendChild(itemElement);
    }

    static {
        ServiceRegistry registery = WebRenderServlet.getServiceRegistry();
        registery.add(SLIDER_SERVICE);
        registery.add(SLIDER_HORZ_IMAGE);
        registery.add(SLIDER_VERT_IMAGE);
        registery.add(SLIDER_HORZ_IMAGE_ROLLOVER);
        registery.add(SLIDER_VERT_IMAGE_ROLLOVER);
    }
}

