/*
 * Decompiled with CFR 0.152.
 */
package echopointng.ui.syncpeer;

import echopointng.Tree;
import echopointng.tree.TreeCellRenderer;
import echopointng.tree.TreeIcons;
import echopointng.tree.TreeModel;
import echopointng.tree.TreePath;
import echopointng.ui.util.HtmlTable;
import echopointng.ui.util.ImageManager;
import echopointng.ui.util.RenderingContext;
import echopointng.xhtml.XhtmlFragment;
import java.util.ArrayList;
import java.util.Stack;
import nextapp.echo2.app.Alignment;
import nextapp.echo2.app.Color;
import nextapp.echo2.app.Component;
import nextapp.echo2.app.Font;
import nextapp.echo2.app.ImageReference;
import nextapp.echo2.app.Label;
import nextapp.echo2.app.Style;
import nextapp.echo2.webcontainer.ComponentSynchronizePeer;
import nextapp.echo2.webcontainer.DomUpdateSupport;
import nextapp.echo2.webcontainer.SynchronizePeerFactory;
import nextapp.echo2.webcontainer.propertyrender.AlignmentRender;
import nextapp.echo2.webcontainer.propertyrender.ColorRender;
import nextapp.echo2.webcontainer.propertyrender.FontRender;
import nextapp.echo2.webrender.output.CssStyle;
import nextapp.echo2.webrender.util.DomUtil;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

public class TreeRenderer {
    private Tree tree;
    private TreeModel treeModel;
    private TreeIcons treeIcons;
    private ImageManager imageManager;
    private RenderingContext rc;
    private Style fallbackStyle;
    private EventSupportCallBack eventSupportCallBack;
    private TreeCellRenderer cellRenderer;
    private boolean showLines;
    private boolean isRootVisible;
    private boolean showRootHandles;
    private boolean isCellWidthConstrained;
    private boolean isSelectionIncludesIcon;
    private static final Alignment TOP_VERT_ALIGNMENT = new Alignment(0, 6);
    private static final Alignment BOTTOM_VERT_ALIGNMENT = new Alignment(0, 7);
    private static final int DEBUG_TABLE_BORDER = 0;
    private static final boolean DEBUG_PATH_IDS = false;

    public static String createPathId(TreePath treeNodePath, TreeModel model) {
        Object[] path = treeNodePath.getPath();
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < path.length; ++i) {
            sb.append('[');
            if (i == 0) {
                sb.append("root");
            } else {
                sb.append(model.getNodeId(path[i]));
            }
            sb.append(']');
        }
        return sb.toString();
    }

    public TreeRenderer(RenderingContext rc, EventSupportCallBack eventSupportCallBack, Tree tree, Style fallbackStyle, ImageManager imageManager) {
        this.rc = rc;
        this.eventSupportCallBack = eventSupportCallBack;
        this.tree = tree;
        this.imageManager = imageManager;
        this.fallbackStyle = fallbackStyle;
        this.treeModel = (TreeModel)this.getRP("model", fallbackStyle);
        this.treeIcons = (TreeIcons)this.getRP("treeIcons", fallbackStyle);
        this.cellRenderer = (TreeCellRenderer)this.getRP("cellRenderer", fallbackStyle);
        this.showLines = this.getRP("linesDrawn", true, fallbackStyle);
        this.isRootVisible = this.getRP("rootVisible", true, fallbackStyle);
        this.showRootHandles = this.getRP("showsRootHandles", true, fallbackStyle);
        this.isCellWidthConstrained = this.getRP("cellWidthContrained", false, fallbackStyle);
        this.isSelectionIncludesIcon = this.getRP("selectionIncludesIcon", true, fallbackStyle);
    }

    private Object getRP(String propertyName, Style style) {
        Object value = this.tree.getRenderProperty(propertyName);
        if (value == null && style != null) {
            value = style.getProperty(propertyName);
        }
        return value;
    }

    private boolean getRP(String propertyName, boolean defaultValue, Style style) {
        Object value = this.tree.getRenderProperty(propertyName);
        if (value == null && style != null) {
            value = style.getProperty(propertyName);
        }
        if (value == null) {
            return defaultValue;
        }
        return (Boolean)value;
    }

    private boolean isLastSibling(TreePath treeNodePath) {
        TreePath parentPath = this.getParent(treeNodePath);
        if (parentPath == null) {
            return true;
        }
        Object parentNode = parentPath.getLastPathComponent();
        Object treeNode = treeNodePath.getLastPathComponent();
        int childCount = this.treeModel.getChildCount(parentNode);
        int childIndex = this.treeModel.getIndexOfChild(parentNode, treeNode);
        return childIndex == childCount - 1;
    }

    private TreePath getParent(TreePath treeNodePath) {
        TreePath path;
        Object root = this.treeModel.getRoot();
        Object treeNode = treeNodePath.getLastPathComponent();
        if (treeNode.equals(root)) {
            return null;
        }
        TreePath parentPath = treeNodePath.getParentPath();
        if (parentPath == null && (parentPath = this.findParentDownwards(root, path = new TreePath(root), treeNode)) == null) {
            throw new IllegalStateException("Unexpected tree node state.  The node is visible but its parent is not!");
        }
        return parentPath;
    }

    private TreePath findParentDownwards(Object currentParent, TreePath currentTreePath, Object searchNode) {
        if (this.treeModel.isLeaf(currentParent) || !this.tree.isExpanded(currentTreePath)) {
            return null;
        }
        int childCount = this.treeModel.getChildCount(currentParent);
        for (int i = 0; i < childCount; ++i) {
            Object childNode = this.treeModel.getChild(currentParent, i);
            TreePath childPath = new TreePath(currentTreePath, childNode);
            if (searchNode.equals(childNode)) {
                return currentTreePath;
            }
            TreePath newParentPath = this.findParentDownwards(childNode, childPath, searchNode);
            if (newParentPath == null) continue;
            return newParentPath;
        }
        return null;
    }

    private void createCellCommandsStack(Stack stack, TreePath treeNodePath) {
        Object treeNode;
        Object root = this.treeModel.getRoot();
        if (root.equals(treeNode = treeNodePath.getLastPathComponent())) {
            return;
        }
        while (true) {
            TreePath parentPath;
            if (root.equals((parentPath = this.getParent(treeNodePath)).getLastPathComponent())) {
                if (this.isRootVisible && this.showRootHandles) {
                    stack.push("empty");
                }
                return;
            }
            if (this.isLastSibling(parentPath)) {
                stack.push("empty");
            } else {
                stack.push("line");
            }
            treeNodePath = parentPath;
        }
    }

    private CssStyle createStyleFromLabel(Label cellLabel) {
        Font font;
        Color foreground;
        if (cellLabel == null) {
            return new CssStyle();
        }
        Color background = (Color)cellLabel.getRenderProperty("background");
        if (background == null) {
            background = (Color)this.getRP("background", this.fallbackStyle);
        }
        if ((foreground = (Color)cellLabel.getRenderProperty("foreground")) == null) {
            foreground = (Color)this.getRP("foreground", this.fallbackStyle);
        }
        if ((font = (Font)cellLabel.getRenderProperty("font")) == null) {
            font = (Font)this.getRP("font", this.fallbackStyle);
        }
        CssStyle cssStyle = new CssStyle();
        AlignmentRender.renderToStyle(cssStyle, BOTTOM_VERT_ALIGNMENT);
        Alignment cellAlignment = (Alignment)cellLabel.getRenderProperty("textAlignment");
        AlignmentRender.renderToStyle(cssStyle, cellAlignment);
        ColorRender.renderToStyle(cssStyle, foreground, background);
        FontRender.renderToStyle(cssStyle, font);
        return cssStyle;
    }

    private CssStyle createStyleFromTree(Tree tree) {
        Color background = (Color)this.getRP("background", this.fallbackStyle);
        Color foreground = (Color)this.getRP("foreground", this.fallbackStyle);
        Font font = (Font)this.getRP("font", this.fallbackStyle);
        CssStyle cssStyle = new CssStyle();
        ColorRender.renderToStyle(cssStyle, foreground, background);
        FontRender.renderToStyle(cssStyle, font);
        return cssStyle;
    }

    private void renderCellImage(ImageReference cellImageRef, Element cellTD) {
        if (cellImageRef != null) {
            CssStyle cssStyle = new CssStyle();
            AlignmentRender.renderToStyle(cssStyle, TOP_VERT_ALIGNMENT);
            if (cellImageRef.getWidth() != null) {
                cssStyle.setAttribute("width", cellImageRef.getWidth().toString());
            }
            if (cellImageRef.getHeight() != null) {
                cssStyle.setAttribute("height", cellImageRef.getHeight().toString());
            }
            Element imgE = ImageManager.createImgE(this.rc, cssStyle, cellImageRef);
            cellTD.appendChild(imgE);
        }
    }

    private void renderCellImageSetWidths(CssStyle cssStyle, ImageReference cellImageRef, Element cellTD) {
        if (cellImageRef != null) {
            this.renderCellImage(cellImageRef, cellTD);
            cssStyle.setAttribute("padding", "0");
            cssStyle.setAttribute("margin", "0");
            if (cellImageRef.getWidth() != null) {
                cssStyle.setAttribute("width", cellImageRef.getWidth().toString());
            }
        }
    }

    private void renderEmptyCell(Element cellTD) {
        ImageReference icon = this.treeIcons.getIcon("empty");
        if (icon != null) {
            this.imageManager.addImage(icon);
            Element imgE = ImageManager.createImgE(this.rc, null, icon);
            cellTD.appendChild(imgE);
        }
        CssStyle cssStyle = this.createStyleFromTree(this.tree);
        cellTD.setAttribute("style", cssStyle.renderInline());
        cellTD.setAttribute("nowrap", "nowrap");
    }

    private void renderBackgroundImageIntoStyle(ImageReference cellImageRef, CssStyle cssStyle) {
        if (cellImageRef != null) {
            String iconUri = ImageManager.getURI(this.rc, cellImageRef);
            cssStyle.setAttribute("background-image", "url(" + iconUri + ")");
            cssStyle.setAttribute("background-repeat", "repeat-y");
        }
    }

    private void renderBackgroundLineCell(Element cellTD) {
        ImageReference cellImageRef = this.showLines ? this.treeIcons.getIcon("line") : this.treeIcons.getIcon("empty");
        CssStyle cssStyle = this.createStyleFromTree(this.tree);
        if (cellImageRef != null) {
            this.imageManager.addImage(cellImageRef);
            String iconUri = ImageManager.getURI(this.rc, cellImageRef);
            cssStyle.setAttribute("background-image", "url(" + iconUri + ")");
            if (cellImageRef.getWidth() != null) {
                cssStyle.setAttribute("width", cellImageRef.getWidth().toString());
            }
            Element imgE = ImageManager.createImgE(this.rc, null, cellImageRef);
            cellTD.appendChild(imgE);
        }
        if (cssStyle.hasAttributes()) {
            cellTD.setAttribute("style", cssStyle.renderInline());
        }
        cellTD.setAttribute("nowrap", "nowrap");
    }

    private void renderExpandoCell(Object treeNode, TreePath treeNodePath, Element cellTD) {
        ImageReference icon;
        boolean lastSibling = this.isLastSibling(treeNodePath);
        boolean isExpanded = this.tree.isExpanded(treeNodePath);
        boolean isRootNode = treeNode.equals(this.treeModel.getRoot());
        boolean isLeaf = this.treeModel.isLeaf(treeNode);
        boolean needsEventHandling = false;
        if (!isLeaf) {
            needsEventHandling = true;
            icon = lastSibling && this.showLines && !isRootNode ? (isExpanded ? this.treeIcons.getIcon("minusbottom") : this.treeIcons.getIcon("plusbottom")) : (isRootNode && !this.showRootHandles ? this.treeIcons.getIcon("empty") : (isExpanded ? this.treeIcons.getIcon("minus") : this.treeIcons.getIcon("plus")));
        } else {
            needsEventHandling = false;
            icon = this.showLines ? (lastSibling ? this.treeIcons.getIcon("joinbottom") : this.treeIcons.getIcon("join")) : this.treeIcons.getIcon("joinnoline");
        }
        this.imageManager.addImage(icon);
        CssStyle cellStyle = this.createStyleFromTree(this.tree);
        if (this.showLines && !lastSibling && !isRootNode) {
            ImageReference lineIcon = this.treeIcons.getIcon("line");
            this.imageManager.addImage(lineIcon);
            this.renderBackgroundImageIntoStyle(lineIcon, cellStyle);
        }
        this.renderCellImageSetWidths(cellStyle, icon, cellTD);
        if (needsEventHandling) {
            String eventElementId = this.eventSupportCallBack.onExpandoCell(this.rc, cellStyle, cellTD, this.tree, treeNode, treeNodePath);
            cellTD.setAttribute("id", eventElementId);
        }
        cellTD.setAttribute("style", cellStyle.renderInline());
        cellTD.setAttribute("nowrap", "nowrap");
    }

    private void renderNodeCell(Object treeNode, TreePath treeNodePath, HtmlTable treeRowTable) {
        Element cellTD;
        boolean isExpanded = this.tree.isExpanded(treeNodePath);
        boolean isLeaf = this.treeModel.isLeaf(treeNode);
        boolean isSelected = this.tree.isPathSelected(treeNodePath);
        Label cellLabel = this.cellRenderer.getTreeCellRendererText(this.tree, treeNode, isSelected, isExpanded, isLeaf);
        if (cellLabel != null) {
            CssStyle cssStyleText = this.createStyleFromLabel(cellLabel);
            ImageReference icon = cellLabel.getIcon();
            if (icon != null) {
                this.imageManager.addImage(icon);
                cellTD = treeRowTable.newTD();
                Label iconCellLabel = cellLabel;
                if (!this.isSelectionIncludesIcon) {
                    iconCellLabel = this.cellRenderer.getTreeCellRendererText(this.tree, treeNode, false, isExpanded, isLeaf);
                }
                CssStyle cssStyleIcon = this.createStyleFromLabel(iconCellLabel);
                this.renderCellImageSetWidths(cssStyleIcon, icon, cellTD);
                String eventElementId = this.eventSupportCallBack.onNodeIconCell(this.rc, cssStyleIcon, cellTD, this.tree, treeNode, treeNodePath);
                cellTD.setAttribute("id", eventElementId);
                cellTD.setAttribute("style", cssStyleIcon.renderInline());
            }
            cssStyleText.setAttribute("white-space", "pre");
            if (!this.isCellWidthConstrained) {
                cssStyleText.setAttribute("width", "100%");
            }
            cellTD = treeRowTable.newTD();
            cellTD.setAttribute("nowrap", "nowrap");
            String text = (String)cellLabel.getRenderProperty("text");
            if (text != null && text.length() > 0) {
                DomUtil.setElementText(cellTD, text);
            }
            String eventElementId = this.eventSupportCallBack.onNodeTextCell(this.rc, cssStyleText, cellTD, this.tree, treeNode, treeNodePath);
            cellTD.setAttribute("id", eventElementId);
            cellTD.setAttribute("style", cssStyleText.renderInline());
        } else {
            Component cellComponent = this.tree.getComponent(treeNode);
            if (cellComponent != null) {
                CssStyle cssStyleComponent = new CssStyle();
                cssStyleComponent.setAttribute("text-align", "left");
                cssStyleComponent.setAttribute("vertical-align", "top");
                cssStyleComponent.setAttribute("white-space", "pre");
                if (!this.isCellWidthConstrained) {
                    cssStyleComponent.setAttribute("width", "100%");
                }
                Element cellTD2 = treeRowTable.newTD();
                String eventElementId = this.eventSupportCallBack.onNodeIconCell(this.rc, cssStyleComponent, cellTD2, this.tree, treeNode, treeNodePath);
                cellTD2.setAttribute("id", eventElementId);
                cellTD2.setAttribute("style", cssStyleComponent.renderInline());
                ComponentSynchronizePeer syncPeer = SynchronizePeerFactory.getPeerForComponent(cellComponent.getClass());
                if (syncPeer instanceof DomUpdateSupport) {
                    ((DomUpdateSupport)((Object)syncPeer)).renderHtml(this.rc, this.rc.getServerComponentUpdate(), cellTD2, cellComponent);
                } else {
                    syncPeer.renderAdd(this.rc, this.rc.getServerComponentUpdate(), eventElementId, cellComponent);
                }
                return;
            }
            XhtmlFragment fragment = this.cellRenderer.getTreeCellRendererXhtml(this.tree, treeNode, isSelected, isExpanded, isLeaf);
            if (fragment != null) {
                CssStyle cssStyleFragment = new CssStyle();
                cssStyleFragment.setAttribute("text-align", "left");
                cssStyleFragment.setAttribute("vertical-align", "top");
                cssStyleFragment.setAttribute("white-space", "pre");
                if (!this.isCellWidthConstrained) {
                    cssStyleFragment.setAttribute("width", "100%");
                }
                cellTD = treeRowTable.newTD();
                String eventElementId = this.eventSupportCallBack.onNodeIconCell(this.rc, cssStyleFragment, cellTD, this.tree, treeNode, treeNodePath);
                cellTD.setAttribute("id", eventElementId);
                cellTD.setAttribute("style", cssStyleFragment.renderInline());
                if (fragment.isJustText()) {
                    String xhtmlText = fragment.getFragment();
                    Text textNode = treeRowTable.getOwnerDocument().createTextNode(xhtmlText);
                    cellTD.appendChild(textNode);
                } else {
                    Node[] fragments = null;
                    try {
                        fragments = fragment.toDOM(treeRowTable.getOwnerDocument());
                    }
                    catch (Exception e) {
                        throw new RuntimeException("The XhtmlFragment is not valid XHTML : " + fragment.getFragment(), e);
                    }
                    for (int i = 0; i < fragments.length; ++i) {
                        cellTD.appendChild(fragments[i]);
                    }
                }
            }
        }
        if (this.isCellWidthConstrained) {
            cellTD = treeRowTable.newTD();
            cellTD.setAttribute("style", "width:100%");
        }
    }

    private void renderTreeRecursive(Object parentTreeNode, TreePath parentTreePath) {
        boolean renderParent = true;
        if (parentTreeNode.equals(this.treeModel.getRoot()) && !this.isRootVisible) {
            renderParent = false;
        }
        if (renderParent) {
            this.renderTreeRow(parentTreeNode, parentTreePath);
        }
        if (!this.treeModel.isLeaf(parentTreeNode) && this.tree.isExpanded(parentTreePath)) {
            int cc = this.treeModel.getChildCount(parentTreeNode);
            for (int i = 0; i < cc; ++i) {
                Object nodeTreeChild = this.treeModel.getChild(parentTreeNode, i);
                this.renderTreeRecursive(nodeTreeChild, new TreePath(parentTreePath, nodeTreeChild));
            }
        }
    }

    public void renderTree() {
        Object root = this.treeModel.getRoot();
        this.renderTreeRecursive(root, new TreePath(root));
    }

    public Element renderTreeRow(Object treeNode, TreePath treeNodePath) {
        boolean isRootPath = this.getParent(treeNodePath) == null;
        HtmlTable treeRowTable = new HtmlTable(this.rc.getDocument(), false, 0, 0, 0);
        treeRowTable.newTRnoTD();
        Element cellTD = null;
        Stack cellCommandStack = new Stack();
        this.createCellCommandsStack(cellCommandStack, treeNodePath);
        while (!cellCommandStack.isEmpty()) {
            cellTD = treeRowTable.newTD();
            String cellCommand = (String)cellCommandStack.pop();
            if (cellCommand.equals("line")) {
                this.renderBackgroundLineCell(cellTD);
                continue;
            }
            this.renderEmptyCell(cellTD);
        }
        if (isRootPath && this.showRootHandles || !isRootPath) {
            cellTD = treeRowTable.newTD();
            this.renderExpandoCell(treeNode, treeNodePath, cellTD);
        }
        this.renderNodeCell(treeNode, treeNodePath, treeRowTable);
        CssStyle cssTreeStyle = new CssStyle();
        cssTreeStyle.setAttribute("border-collapse", "collapse");
        treeRowTable.getTABLE().setAttribute("border", "0");
        treeRowTable.getTABLE().setAttribute("width", "100%");
        this.eventSupportCallBack.onTreeRow(this.rc, cssTreeStyle, treeRowTable.getTABLE(), this.tree, treeNodePath);
        treeRowTable.getTABLE().setAttribute("style", cssTreeStyle.renderInline());
        return treeRowTable.getTABLE();
    }

    protected ArrayList compileVisiblePaths() {
        Object root = this.treeModel.getRoot();
        ArrayList paths = new ArrayList();
        this.compileVisiblePaths(paths, root, new TreePath(root));
        return paths;
    }

    private void compileVisiblePaths(ArrayList paths, Object node, TreePath path) {
        boolean renderNode;
        boolean bl = renderNode = !node.equals(this.treeModel.getRoot()) || this.isRootVisible;
        if (renderNode) {
            paths.add(path);
        }
        if (!this.treeModel.isLeaf(node) && this.tree.isExpanded(path)) {
            int cc = this.treeModel.getChildCount(node);
            for (int i = 0; i < cc; ++i) {
                Object childNode = this.treeModel.getChild(node, i);
                this.compileVisiblePaths(paths, childNode, new TreePath(path, childNode));
            }
        }
    }

    public static interface EventSupportCallBack {
        public String onExpandoCell(RenderingContext var1, CssStyle var2, Element var3, Tree var4, Object var5, TreePath var6);

        public String onNodeIconCell(RenderingContext var1, CssStyle var2, Element var3, Tree var4, Object var5, TreePath var6);

        public String onNodeTextCell(RenderingContext var1, CssStyle var2, Element var3, Tree var4, Object var5, TreePath var6);

        public String onNodeComponentCell(RenderingContext var1, CssStyle var2, Element var3, Tree var4, Object var5, TreePath var6);

        public void onTreeRow(RenderingContext var1, CssStyle var2, Element var3, Tree var4, TreePath var5);
    }
}

