/*
 * Decompiled with CFR 0.152.
 */
package echopointng.ui.syncpeer.command;

import echopointng.command.CssStyleAdd;
import echopointng.command.CssStyleAddValues;
import echopointng.command.CssStyleApplyTo;
import echopointng.command.CssStyleRemove;
import echopointng.command.CssStyleRemoveFrom;
import echopointng.command.CssStyleSheetAdd;
import echopointng.ui.resource.Resources;
import nextapp.echo2.app.Command;
import nextapp.echo2.webcontainer.CommandSynchronizePeer;
import nextapp.echo2.webcontainer.ContainerInstance;
import nextapp.echo2.webcontainer.RenderContext;
import nextapp.echo2.webrender.ServerMessage;
import nextapp.echo2.webrender.Service;
import nextapp.echo2.webrender.WebRenderServlet;
import nextapp.echo2.webrender.service.JavaScriptService;
import org.w3c.dom.Element;

public class CssStyleCommandPeer
implements CommandSynchronizePeer {
    public static final Service CSS_COMMAND_SERVICE = JavaScriptService.forResource("EPNG.CssCommand", "/echopointng/ui/resource/js/csscommand.js");

    @Override
    public void render(RenderContext rc, Command command) {
        ServerMessage serverMessage = rc.getServerMessage();
        serverMessage.addLibrary(Resources.EP_SCRIPT_SERVICE.getId());
        serverMessage.addLibrary(CSS_COMMAND_SERVICE.getId());
        if (command instanceof CssStyleAdd) {
            this.renderCssStyleAdd(rc, (CssStyleAdd)command);
        } else if (command instanceof CssStyleAddValues) {
            this.renderCssStyleAddValues(rc, (CssStyleAddValues)command);
        } else if (command instanceof CssStyleSheetAdd) {
            this.renderCssStyleSheetAdd(rc, (CssStyleSheetAdd)command);
        } else if (command instanceof CssStyleRemove) {
            this.renderCssStyleRemove(rc, (CssStyleRemove)command);
        } else if (command instanceof CssStyleApplyTo) {
            this.renderCssStyleApplyTo(rc, (CssStyleApplyTo)command);
        } else if (command instanceof CssStyleRemoveFrom) {
            this.renderCssStyleRemoveFrom(rc, (CssStyleRemoveFrom)command);
        } else {
            throw new IllegalArgumentException("Unhandled Command type : " + String.valueOf(command));
        }
    }

    private void renderCssStyleAdd(RenderContext rc, CssStyleAdd command) {
        ServerMessage serverMessage = rc.getServerMessage();
        Element itemE = serverMessage.appendPartDirective("postupdate", "EPCssCommand.MessageProcessor", "addStyle");
        itemE.setAttribute("eid", command.getRenderId());
        Element styleE = serverMessage.getDocument().createElement("style");
        styleE.setAttribute("type", "text/css");
        styleE.setAttribute("media", command.getMedia());
        styleE.appendChild(serverMessage.getDocument().createTextNode(command.getStyleText()));
        itemE.appendChild(styleE);
    }

    private void renderCssStyleAddValues(RenderContext rc, CssStyleAddValues command) {
        ServerMessage serverMessage = rc.getServerMessage();
        Element itemE = serverMessage.appendPartDirective("postupdate", "EPCssCommand.MessageProcessor", "addStyleValue");
        itemE.setAttribute("eid", ContainerInstance.getElementId(command.getTargetComponent()));
        itemE.setAttribute("styleText", command.getStyleText());
    }

    private void renderCssStyleSheetAdd(RenderContext rc, CssStyleSheetAdd command) {
        ServerMessage serverMessage = rc.getServerMessage();
        Element itemE = serverMessage.appendPartDirective("postupdate", "EPCssCommand.MessageProcessor", "addStyleSheet");
        itemE.setAttribute("eid", command.getRenderId());
        Element linkE = serverMessage.getDocument().createElement("link");
        linkE.setAttribute("media", command.getMedia());
        linkE.setAttribute("href", command.getStyleSheetURI());
        linkE.setAttribute("type", "text/css");
        linkE.setAttribute("rel", "Stylesheet");
        itemE.appendChild(linkE);
    }

    private void renderCssStyleRemove(RenderContext rc, CssStyleRemove command) {
        ServerMessage serverMessage = rc.getServerMessage();
        Element itemE = serverMessage.appendPartDirective("postupdate", "EPCssCommand.MessageProcessor", "removeStyle");
        itemE.setAttribute("eid", command.getRenderId());
    }

    private void renderCssStyleApplyTo(RenderContext rc, CssStyleApplyTo command) {
        ServerMessage serverMessage = rc.getServerMessage();
        Element itemE = serverMessage.appendPartDirective("postupdate", "EPCssCommand.MessageProcessor", "applyTo");
        itemE.setAttribute("eid", ContainerInstance.getElementId(command.getTargetComponent()));
        itemE.setAttribute("className", command.getClassName());
    }

    private void renderCssStyleRemoveFrom(RenderContext rc, CssStyleRemoveFrom command) {
        ServerMessage serverMessage = rc.getServerMessage();
        Element itemE = serverMessage.appendPartDirective("postupdate", "EPCssCommand.MessageProcessor", "removeFrom");
        itemE.setAttribute("eid", ContainerInstance.getElementId(command.getTargetComponent()));
        itemE.setAttribute("className", command.getClassName());
    }

    static {
        WebRenderServlet.getServiceRegistry().add(CSS_COMMAND_SERVICE);
    }
}

