/*
 * Decompiled with CFR 0.152.
 */
package echopointng.ui.template;

import echopointng.template.TemplateCompilerHints;
import echopointng.template.TemplateDataSource;
import echopointng.ui.template.TemplateCompiler;
import java.io.InputStream;
import java.io.InputStreamReader;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import nextapp.echo2.webcontainer.RenderContext;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;

public class XHTMLTemplateCompiler
implements TemplateCompiler {
    private static final ThreadLocal nonvalidatingDocumentBuilders = new ThreadLocal(){

        protected Object initialValue() {
            return XHTMLTemplateCompiler.buildDocumentBuilder(null);
        }
    };

    protected static final DocumentBuilder buildDocumentBuilder(TemplateCompilerHints compilerHints) {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            if (compilerHints == null) {
                factory.setNamespaceAware(true);
                factory.setValidating(false);
                factory.setAttribute("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
            } else {
                factory.setCoalescing(compilerHints.isCoalescing());
                factory.setExpandEntityReferences(compilerHints.isExpandEntityReferences());
                factory.setIgnoringComments(compilerHints.isIgnoringComments());
                factory.setIgnoringElementContentWhitespace(compilerHints.isIgnoringElementContentWhitespace());
                factory.setNamespaceAware(compilerHints.isNamespaceAware());
                factory.setValidating(compilerHints.isValidating());
                String[] attrNames = compilerHints.getAttributeNames();
                if (attrNames != null) {
                    for (int i = 0; i < attrNames.length; ++i) {
                        Object value = compilerHints.getAttributeValue(attrNames[i]);
                        factory.setAttribute(attrNames[i], value);
                    }
                }
            }
            DocumentBuilder builder = factory.newDocumentBuilder();
            return builder;
        }
        catch (ParserConfigurationException ex) {
            throw new RuntimeException(ex);
        }
    }

    protected static DocumentBuilder getNonValidatingDocumentBuilder() {
        return (DocumentBuilder)nonvalidatingDocumentBuilders.get();
    }

    @Override
    public Element compileTemplateDataIntoXHTML(RenderContext rc, TemplateDataSource tds) throws Exception {
        return this.compileXHTML(tds.getInputStream(), tds);
    }

    protected Element compileXHTML(InputStream inputStream, TemplateDataSource tds) throws Exception {
        long startMS = System.currentTimeMillis();
        String characterEncoding = tds.getCharacterEncoding();
        TemplateCompilerHints compilerHints = tds.getCompilerHints();
        InputStreamReader isr = characterEncoding != null ? new InputStreamReader(inputStream, characterEncoding) : new InputStreamReader(inputStream);
        InputSource inputSource = new InputSource();
        inputSource.setCharacterStream(isr);
        inputSource.setByteStream(inputStream);
        inputSource.setEncoding(characterEncoding);
        DocumentBuilder docBuilder = null;
        docBuilder = compilerHints == null ? XHTMLTemplateCompiler.getNonValidatingDocumentBuilder() : XHTMLTemplateCompiler.buildDocumentBuilder(compilerHints);
        Document document = docBuilder.parse(inputSource);
        Element documentElement = document.getDocumentElement();
        long compileMS = System.currentTimeMillis() - startMS;
        if (compileMS == 0L) {
            // empty if block
        }
        return documentElement;
    }
}

