/*
 * Decompiled with CFR 0.152.
 */
package echopointng.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.StreamTokenizer;
import java.io.StringReader;
import java.util.ArrayList;

public class TokenizerKit {
    private TokenizerKit() {
    }

    public static String[] tokenize(String str, String delims) {
        return TokenizerKit.doTokenize(str, delims, 0, 32, 33, 255, true, false, false);
    }

    public static String[] tokenizeStrict(String str, String delims) {
        return TokenizerKit.doTokenize(str, delims, 0, 32, 33, 255, true, true, false);
    }

    public static String[] tokenize(String str, String delims, boolean returnDelimeters) {
        return TokenizerKit.doTokenize(str, delims, 0, 32, 33, 255, true, false, returnDelimeters);
    }

    public static String[] tokenizeStrict(String str, String delims, boolean returnDelimeters) {
        return TokenizerKit.doTokenize(str, delims, 0, 32, 33, 255, true, true, returnDelimeters);
    }

    public static String[] splitIntoLines(String str) {
        ArrayList<String> strList = new ArrayList<String>();
        StringReader sr = new StringReader(str);
        BufferedReader br = new BufferedReader(sr);
        try {
            String line = br.readLine();
            while (line != null) {
                strList.add(line);
                line = br.readLine();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return strList.toArray(new String[strList.size()]);
    }

    private static String[] doTokenize(String str, String delims, int loWhiteSpace, int hiWhiteSpace, int loWordChar, int hiWordChar, boolean useQuotes, boolean noCommonWhiteSpace, boolean returnDelims) {
        try {
            ArrayList<String> tokenList = new ArrayList<String>();
            StringReader sr = new StringReader(str);
            StreamTokenizer st = new StreamTokenizer(sr);
            st.resetSyntax();
            st.whitespaceChars(loWhiteSpace, hiWhiteSpace);
            st.wordChars(loWordChar, hiWordChar);
            for (int i = 0; i < delims.length(); ++i) {
                st.ordinaryChar(delims.charAt(i));
            }
            if (useQuotes) {
                st.quoteChar(39);
                st.quoteChar(34);
            }
            if (noCommonWhiteSpace) {
                st.wordChars(32, 32);
                st.wordChars(9, 9);
                st.wordChars(10, 10);
                st.wordChars(13, 13);
            }
            String token = "";
            int tt = st.nextToken();
            while (tt != -1) {
                token = null;
                switch (tt) {
                    case -3: {
                        token = st.sval;
                        break;
                    }
                    case 34: {
                        token = st.sval;
                        break;
                    }
                    case 39: {
                        token = st.sval;
                        break;
                    }
                    case -1: {
                        break;
                    }
                    default: {
                        token = returnDelims ? new String(new char[]{(char)tt}) : null;
                    }
                }
                if (token != null) {
                    tokenList.add(token);
                }
                tt = st.nextToken();
            }
            return tokenList.toArray(new String[tokenList.size()]);
        }
        catch (IOException ieo) {
            return new String[0];
        }
    }
}

