/*
 * Decompiled with CFR 0.152.
 */
package echopointng.util.throwable;

import echopointng.util.reflect.ReflectionKit;
import echopointng.util.throwable.ThrowableDescriptor;
import echopointng.util.throwable.ThrowablePropertyDescriptor;
import java.io.BufferedReader;
import java.io.CharArrayWriter;
import java.io.IOException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringReader;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class ThrowableKit {
    private ThrowableKit() {
    }

    public static Throwable makeThrowable(Class throwableClass, String message, Throwable cause) {
        if (throwableClass == null || !Throwable.class.isAssignableFrom(throwableClass)) {
            throw new IllegalArgumentException("The class you provided :" + throwableClass + " is not derived from Throwable.class");
        }
        try {
            Constructor c = throwableClass.getDeclaredConstructor(String.class, Throwable.class);
            Object t = c.newInstance(message, cause);
            return (Throwable)t;
        }
        catch (Exception c) {
            try {
                String messageText = message == null ? cause.toString() : message + " : " + cause.toString();
                Constructor c2 = throwableClass.getDeclaredConstructor(String.class);
                Object t = c2.newInstance(messageText);
                return (Throwable)t;
            }
            catch (Exception e) {
                throw new IllegalStateException("A constructor(String) was not available for class :" + throwableClass);
            }
        }
    }

    public static Throwable makeThrowable(Class throwableClass, Throwable cause) {
        return ThrowableKit.makeThrowable(throwableClass, null, cause);
    }

    public static RuntimeException makeRuntimeException(String message, Throwable cause) {
        return (RuntimeException)ThrowableKit.makeThrowable(RuntimeException.class, message, cause);
    }

    public static RuntimeException makeRuntimeException(Throwable cause) {
        return ThrowableKit.makeRuntimeException(null, cause);
    }

    public static Throwable attachCause(Throwable throwable, Throwable cause) {
        try {
            Method m = Throwable.class.getDeclaredMethod("initCause", Throwable.class);
            throwable = (Throwable)m.invoke((Object)throwable, cause);
        }
        catch (SecurityException securityException) {
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (IllegalStateException illegalStateException) {
        }
        catch (InvocationTargetException invocationTargetException) {
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        return throwable;
    }

    public static Throwable initCause(Throwable throwable, Throwable cause) {
        return ThrowableKit.attachCause(throwable, cause);
    }

    public static ThrowableDescriptor describeThrowable(Throwable throwable) {
        HashMap<Throwable, Throwable> seenThrowables = new HashMap<Throwable, Throwable>();
        ThrowableDescriptor descriptor = new ThrowableDescriptor(throwable);
        seenThrowables.put(throwable, throwable);
        ThrowableKit.examineThrowable(descriptor, throwable, seenThrowables);
        return descriptor;
    }

    private static void examineThrowable(ThrowableDescriptor descriptor, Throwable throwable, Map seenThrowables) {
        Method[] properties = ReflectionKit.getAllDeclaredMethods(throwable.getClass());
        ArrayList<ThrowablePropertyDescriptor> propertyList = new ArrayList<ThrowablePropertyDescriptor>(properties.length);
        ArrayList<ThrowableDescriptor> causeList = new ArrayList<ThrowableDescriptor>(properties.length);
        String throwableMessage = throwable.getMessage();
        for (int i = 0; i < properties.length; ++i) {
            int modifiers;
            Object value;
            Class<?> type;
            String name;
            block8: {
                Method getter = properties[i];
                if (!ReflectionKit.isGetter(getter)) continue;
                name = null;
                type = null;
                value = null;
                modifiers = getter.getModifiers();
                try {
                    getter.setAccessible(true);
                    value = getter.invoke((Object)throwable, null);
                    type = getter.getReturnType();
                    name = ReflectionKit.decapitalize(getter.getName());
                    if (name.equals("class") || name.equals("message") || name.equals("ourStackTrace") || name.equals("stackTraceDepth")) continue;
                    if (name.equals("stackTrace")) {
                    }
                    break block8;
                }
                catch (IllegalArgumentException e1) {
                }
                catch (SecurityException e1) {
                }
                catch (IllegalAccessException e1) {
                }
                catch (InvocationTargetException e1) {}
                continue;
            }
            if (Throwable.class.isAssignableFrom(type)) {
                Throwable child;
                if (value == null || seenThrowables.containsKey(child = (Throwable)value)) continue;
                seenThrowables.put(child, child);
                ThrowableDescriptor childDesc = new ThrowableDescriptor(child);
                ThrowableKit.examineThrowable(childDesc, child, seenThrowables);
                causeList.add(childDesc);
                continue;
            }
            if (value == throwableMessage) continue;
            ThrowablePropertyDescriptor propertyDesc = new ThrowablePropertyDescriptor(type, name, value, modifiers);
            propertyList.add(propertyDesc);
        }
        descriptor.setCauses(causeList.toArray(new ThrowableDescriptor[causeList.size()]));
        descriptor.setProperties(propertyList.toArray(new ThrowablePropertyDescriptor[propertyList.size()]));
        descriptor.setStackTrace(ThrowableKit.examineStackTrace(throwable));
    }

    private static String[] examineStackTrace(Throwable parentThrowable) {
        CharArrayWriter caw = new CharArrayWriter();
        PrintWriter pw = new PrintWriter(caw);
        parentThrowable.printStackTrace(pw);
        ArrayList<String> stackTraceList = new ArrayList<String>();
        StringReader sr = new StringReader(caw.toString());
        BufferedReader reader = new BufferedReader(sr);
        boolean atStart = true;
        while (true) {
            String line = null;
            try {
                line = reader.readLine();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (line == null || line.startsWith("Caused by")) break;
            if (atStart) {
                atStart = false;
                continue;
            }
            stackTraceList.add(line);
        }
        return stackTraceList.toArray(new String[stackTraceList.size()]);
    }

    public static void printThrowableDescription(Throwable throwable, PrintStream out, boolean indent) {
        if (throwable == null || out == null) {
            return;
        }
        ThrowableDescriptor desc = ThrowableKit.describeThrowable(throwable);
        ThrowableKit.printThrowableDescription0(desc, out, -1, indent);
    }

    public static void printThrowableDescription(Throwable throwable, PrintStream out) {
        ThrowableKit.printThrowableDescription(throwable, out, true);
    }

    private static void printThrowableDescription0(ThrowableDescriptor desc, PrintStream out, int tabLevel, boolean indent) {
        if (indent) {
            ++tabLevel;
        }
        boolean doneHeader = false;
        ThrowableKit.printTabs(out, tabLevel);
        out.print(desc.getType().getName());
        out.print(" : ");
        out.print(desc.getMessage());
        out.println();
        ThrowablePropertyDescriptor[] properties = desc.getProperties();
        for (int i = 0; i < properties.length; ++i) {
            if (!doneHeader) {
                doneHeader = true;
                ThrowableKit.printTabs(out, tabLevel);
                out.println("Properties : ");
            }
            ThrowableKit.printTabs(out, tabLevel);
            out.print('\t');
            out.print(properties[i].getName());
            out.print(" : ");
            out.print(properties[i].getValueAsString());
            out.print(" (");
            out.print(properties[i].getType().getName());
            out.print(" ");
            String modifiers = Modifier.toString(properties[i].getModifiers());
            out.print(modifiers == null || modifiers.length() == 0 ? "default" : modifiers);
            out.print(")");
            out.println();
        }
        doneHeader = false;
        String[] stackTrace = desc.getStackTrace();
        for (int i = 0; i < stackTrace.length; ++i) {
            if (!doneHeader) {
                doneHeader = true;
                ThrowableKit.printTabs(out, tabLevel);
                out.println("Stack Trace : ");
            }
            ThrowableKit.printTabs(out, tabLevel);
            out.println(stackTrace[i]);
        }
        doneHeader = false;
        ThrowableDescriptor[] causes = desc.getCauses();
        for (int i = 0; i < causes.length; ++i) {
            if (!doneHeader) {
                doneHeader = true;
                ThrowableKit.printTabs(out, tabLevel);
                out.println("Caused By : ");
            }
            ThrowableKit.printThrowableDescription0(causes[i], out, tabLevel, indent);
        }
    }

    private static void printTabs(PrintStream out, int tabLevel) {
        for (int i = 0; i < tabLevel; ++i) {
            out.print("\t");
        }
    }
}

