/*
 * Decompiled with CFR 0.152.
 */
package echopointng.xhtml;

import java.io.IOException;
import java.io.Serializable;
import java.io.StringReader;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import nextapp.echo2.app.LayoutData;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class XhtmlFragment
implements Serializable {
    private static final ThreadLocal nonvalidatingDocumentBuilders = new ThreadLocal(){

        protected Object initialValue() {
            return XhtmlFragment.buildDocumentBuilder();
        }
    };
    private String fragment;
    private LayoutData layoutData;

    private static final DocumentBuilder buildDocumentBuilder() {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setNamespaceAware(true);
            factory.setValidating(false);
            factory.setAttribute("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
            DocumentBuilder builder = factory.newDocumentBuilder();
            return builder;
        }
        catch (ParserConfigurationException ex) {
            throw new RuntimeException(ex);
        }
    }

    private static DocumentBuilder getNonValidatingDocumentBuilder() {
        return (DocumentBuilder)nonvalidatingDocumentBuilders.get();
    }

    public static Exception isValidXML(String fragment) {
        try {
            XhtmlFragment.parseFragment(fragment);
            return null;
        }
        catch (SAXException e) {
            return e;
        }
        catch (IOException e) {
            return e;
        }
    }

    private static Node[] parseFragment(String fragment) throws SAXException, IOException {
        String xhtml = fragment == null ? "" : fragment;
        xhtml = "<div>" + xhtml + "</div>";
        StringReader sr = new StringReader(xhtml);
        InputSource inputSource = new InputSource(sr);
        Document document = XhtmlFragment.getNonValidatingDocumentBuilder().parse(inputSource);
        Element documentElement = document.getDocumentElement();
        NodeList nodeList = documentElement.getChildNodes();
        Node[] children = new Node[nodeList.getLength()];
        int l = nodeList.getLength();
        for (int i = 0; i < l; ++i) {
            Node child;
            children[i] = child = nodeList.item(i);
        }
        return children;
    }

    public XhtmlFragment() {
        this(null);
    }

    public XhtmlFragment(String fragment) {
        this(fragment, null);
    }

    public XhtmlFragment(String fragment, LayoutData layoutData) {
        this.setFragment(fragment);
        this.layoutData = layoutData;
    }

    public String getFragment() {
        return this.fragment;
    }

    public LayoutData getLayoutData() {
        return this.layoutData;
    }

    public void setFragment(String fragment) {
        this.fragment = fragment == null ? "" : fragment;
    }

    public void setLayoutData(LayoutData layoutData) {
        this.layoutData = layoutData;
    }

    public Node[] toDOM(Document targetDocument) throws SAXException, IOException {
        Node[] rawNodes = XhtmlFragment.parseFragment(this.fragment);
        Node[] xhtmlNodes = new Node[rawNodes.length];
        for (int i = 0; i < rawNodes.length; ++i) {
            Node child;
            xhtmlNodes[i] = child = targetDocument.importNode(rawNodes[i], true);
        }
        return xhtmlNodes;
    }

    public boolean isJustText() {
        if (this.fragment.indexOf(60) != -1 && this.fragment.indexOf(62) != -1) {
            return false;
        }
        if (this.fragment.indexOf(38) != -1 && this.fragment.indexOf(62) != -1) {
            return false;
        }
        return this.fragment.indexOf("=\"") == -1;
    }

    public String toString() {
        return this.fragment;
    }
}

