/*
 * Decompiled with CFR 0.152.
 */
package nextapp.echo2.app;

import nextapp.echo2.app.Border;
import nextapp.echo2.app.Component;
import nextapp.echo2.app.Extent;
import nextapp.echo2.app.Insets;

public class Grid
extends Component {
    public static final int DEFAULT_SIZE = 2;
    public static final int ORIENTATION_HORIZONTAL = 0;
    public static final int ORIENTATION_VERTICAL = 1;
    public static final String PROPERTY_BORDER = "border";
    public static final String PROPERTY_COLUMN_WIDTH = "columnWidth";
    public static final String PROPERTY_HEIGHT = "height";
    public static final String PROPERTY_INSETS = "insets";
    public static final String PROPERTY_ORIENTATION = "orientation";
    public static final String PROPERTY_ROW_HEIGHT = "rowHeight";
    public static final String PROPERTY_SIZE = "size";
    public static final String PROPERTY_WIDTH = "width";

    public Grid() {
    }

    public Grid(int size) {
        this.setSize(size);
    }

    public Border getBorder() {
        return (Border)this.getProperty(PROPERTY_BORDER);
    }

    public Extent getColumnWidth(int columnIndex) {
        return (Extent)this.getIndexedProperty(PROPERTY_COLUMN_WIDTH, columnIndex);
    }

    public Extent getHeight() {
        return (Extent)this.getProperty(PROPERTY_HEIGHT);
    }

    public Insets getInsets() {
        return (Insets)this.getProperty(PROPERTY_INSETS);
    }

    public int getOrientation() {
        Integer orientationValue = (Integer)this.getProperty(PROPERTY_ORIENTATION);
        return orientationValue == null ? 0 : orientationValue;
    }

    public Extent getRowHeight(int rowIndex) {
        return (Extent)this.getIndexedProperty(PROPERTY_ROW_HEIGHT, rowIndex);
    }

    public int getSize() {
        Integer sizeValue = (Integer)this.getProperty(PROPERTY_SIZE);
        if (sizeValue == null) {
            return 2;
        }
        return sizeValue;
    }

    public Extent getWidth() {
        return (Extent)this.getProperty(PROPERTY_WIDTH);
    }

    public void setBorder(Border newValue) {
        this.setProperty(PROPERTY_BORDER, newValue);
    }

    public void setColumnWidth(int columnIndex, Extent newValue) {
        this.setIndexedProperty(PROPERTY_COLUMN_WIDTH, columnIndex, newValue);
    }

    public void setHeight(Extent newValue) {
        this.setProperty(PROPERTY_HEIGHT, newValue);
    }

    public void setInsets(Insets newValue) {
        this.setProperty(PROPERTY_INSETS, newValue);
    }

    public void setOrientation(int newValue) {
        this.setProperty(PROPERTY_ORIENTATION, new Integer(newValue));
    }

    public void setRowHeight(int rowIndex, Extent newValue) {
        this.setIndexedProperty(PROPERTY_ROW_HEIGHT, rowIndex, newValue);
    }

    public void setSize(int newValue) {
        this.setProperty(PROPERTY_SIZE, new Integer(newValue));
    }

    public void setWidth(Extent newValue) {
        this.setProperty(PROPERTY_WIDTH, newValue);
    }
}

